/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.fft;

import ffx.numerics.fft.MixedRadixFactor;
import ffx.numerics.fft.PassConstants;
import ffx.numerics.fft.PassData;

public class MixedRadixFactorPrime
extends MixedRadixFactor {
    public MixedRadixFactorPrime(PassConstants passConstants) {
        super(passConstants);
    }

    @Override
    protected void passScalar(PassData passData) {
        int k1;
        int k;
        int idx;
        int i;
        int i2;
        double[] data = passData.in;
        double[] ret = passData.out;
        int sign = passData.sign;
        if (this.im != 1) {
            throw new IllegalArgumentException(" Support for large prime factors requires interleaved data.");
        }
        int dataOffset = passData.inOffset;
        int retOffset = passData.outOffset;
        int jump = (this.factor - 1) * this.innerLoopLimit;
        for (i2 = 0; i2 < this.nextInput; ++i2) {
            ret[retOffset + 2 * i2] = data[dataOffset + 2 * i2];
            ret[retOffset + 2 * i2 + 1] = data[dataOffset + 2 * i2 + 1];
        }
        for (int e = 1; e < (this.factor - 1) / 2 + 1; ++e) {
            for (i = 0; i < this.nextInput; ++i) {
                idx = i + e * this.nextInput;
                int idxc = i + (this.factor - e) * this.nextInput;
                ret[retOffset + 2 * idx] = data[dataOffset + 2 * idx] + data[dataOffset + 2 * idxc];
                ret[retOffset + 2 * idx + 1] = data[dataOffset + 2 * idx + 1] + data[dataOffset + 2 * idxc + 1];
                ret[retOffset + 2 * idxc] = data[dataOffset + 2 * idx] - data[dataOffset + 2 * idxc];
                ret[retOffset + 2 * idxc + 1] = data[dataOffset + 2 * idx + 1] - data[dataOffset + 2 * idxc + 1];
            }
        }
        for (i2 = 0; i2 < this.nextInput; ++i2) {
            data[dataOffset + 2 * i2] = ret[retOffset + 2 * i2];
            data[dataOffset + 2 * i2 + 1] = ret[retOffset + 2 * i2 + 1];
        }
        for (int e1 = 1; e1 < (this.factor - 1) / 2 + 1; ++e1) {
            for (i = 0; i < this.nextInput; ++i) {
                int i1 = retOffset + 2 * (i + e1 * this.nextInput);
                int n = dataOffset + 2 * i;
                data[n] = data[n] + ret[i1];
                int n2 = dataOffset + 2 * i + 1;
                data[n2] = data[n2] + ret[i1 + 1];
            }
        }
        double[] twiddl = this.twiddles[this.outerLoopLimit];
        for (int e = 1; e < (this.factor - 1) / 2 + 1; ++e) {
            idx = e;
            int em = e * this.nextInput;
            int ecm = (this.factor - e) * this.nextInput;
            for (int i3 = 0; i3 < this.nextInput; ++i3) {
                data[dataOffset + 2 * (i3 + em)] = ret[retOffset + 2 * i3];
                data[dataOffset + 2 * (i3 + em) + 1] = ret[retOffset + 2 * i3 + 1];
                data[dataOffset + 2 * (i3 + ecm)] = ret[retOffset + 2 * i3];
                data[dataOffset + 2 * (i3 + ecm) + 1] = ret[retOffset + 2 * i3 + 1];
            }
            for (int e1 = 1; e1 < (this.factor - 1) / 2 + 1; ++e1) {
                double wi;
                double wr;
                if (idx == 0) {
                    wr = 1.0;
                    wi = 0.0;
                } else {
                    wr = twiddl[2 * (idx - 1)];
                    wi = (double)(-sign) * twiddl[2 * (idx - 1) + 1];
                }
                for (int i4 = 0; i4 < this.nextInput; ++i4) {
                    int i1 = retOffset + 2 * (i4 + e1 * this.nextInput);
                    int i22 = retOffset + 2 * (i4 + (this.factor - e1) * this.nextInput);
                    double ap = wr * ret[i1];
                    double am = wi * ret[i22 + 1];
                    double bp = wr * ret[i1 + 1];
                    double bm = wi * ret[i22];
                    int n = dataOffset + 2 * (i4 + em);
                    data[n] = data[n] + (ap - am);
                    int n3 = dataOffset + 2 * (i4 + em) + 1;
                    data[n3] = data[n3] + (bp + bm);
                    int n4 = dataOffset + 2 * (i4 + ecm);
                    data[n4] = data[n4] + (ap + am);
                    int n5 = dataOffset + 2 * (i4 + ecm) + 1;
                    data[n5] = data[n5] + (bp - bm);
                }
                idx += e;
                idx %= this.factor;
            }
        }
        for (int k12 = 0; k12 < this.innerLoopLimit; ++k12) {
            ret[retOffset + 2 * k12] = data[dataOffset + 2 * k12];
            ret[retOffset + 2 * k12 + 1] = data[dataOffset + 2 * k12 + 1];
        }
        for (int e1 = 1; e1 < this.factor; ++e1) {
            for (int k13 = 0; k13 < this.innerLoopLimit; ++k13) {
                int i5 = retOffset + 2 * (k13 + e1 * this.innerLoopLimit);
                int i1 = dataOffset + 2 * (k13 + e1 * this.nextInput);
                ret[i5] = data[i1];
                ret[i5 + 1] = data[i1 + 1];
            }
        }
        i = this.innerLoopLimit;
        int j = this.product;
        for (k = 1; k < this.outerLoopLimit; ++k) {
            for (k1 = 0; k1 < this.innerLoopLimit; ++k1) {
                ret[retOffset + 2 * j] = data[dataOffset + 2 * i];
                ret[retOffset + 2 * j + 1] = data[dataOffset + 2 * i + 1];
                ++i;
                ++j;
            }
            j += jump;
        }
        i = this.innerLoopLimit;
        j = this.product;
        for (k = 1; k < this.outerLoopLimit; ++k) {
            twiddl = this.twiddles[k];
            for (k1 = 0; k1 < this.innerLoopLimit; ++k1) {
                for (int e1 = 1; e1 < this.factor; ++e1) {
                    int i1 = dataOffset + 2 * (i + e1 * this.nextInput);
                    double xr = data[i1];
                    double xi = data[i1 + 1];
                    double wr = twiddl[2 * (e1 - 1)];
                    double wi = (double)(-sign) * twiddl[2 * (e1 - 1) + 1];
                    int i23 = retOffset + 2 * (j + e1 * this.innerLoopLimit);
                    ret[i23] = Math.fma(wr, xr, -wi * xi);
                    ret[i23 + 1] = Math.fma(wr, xi, wi * xr);
                }
                ++i;
                ++j;
            }
            j += jump;
        }
    }

    @Override
    protected void passSIMD(PassData passData) {
        this.passScalar(passData);
    }
}

