/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.fft;

import ffx.numerics.fft.Complex;
import ffx.numerics.fft.Complex2D;
import ffx.numerics.fft.DataLayout1D;
import ffx.numerics.fft.DataLayout2D;
import ffx.numerics.fft.DataLayout3D;

public class Complex3D {
    private final int nX;
    private final int nY;
    private final int nZ;
    private final int im;
    private final int ii;
    private final int nextX;
    private final int nextY;
    private final int nextZ;
    private final Complex2D fftXY;
    private final Complex fftZN;
    private final double[] work;
    private final int internalImZ;
    private final int internalNextZ;
    private final double[] recip;
    private boolean useSIMD;
    private boolean packFFTs;

    public Complex3D(int nX, int nY, int nZ) {
        this(nX, nY, nZ, DataLayout3D.INTERLEAVED);
    }

    public Complex3D(int nX, int nY, int nZ, DataLayout3D layout) {
        DataLayout1D dataLayoutZ;
        DataLayout2D dataLayoutXY;
        this.nX = nX;
        this.nY = nY;
        this.nZ = nZ;
        switch (layout) {
            default: {
                this.im = 1;
                this.ii = 2;
                this.nextX = 2;
                this.nextY = 2 * nX;
                this.nextZ = 2 * nX * nY;
                dataLayoutXY = DataLayout2D.INTERLEAVED;
                dataLayoutZ = DataLayout1D.INTERLEAVED;
                this.internalNextZ = 2;
                this.internalImZ = 1;
                break;
            }
            case BLOCKED_X: {
                this.im = nX;
                this.ii = 1;
                this.nextX = 1;
                this.nextY = 2 * nX;
                this.nextZ = 2 * nX * nY;
                dataLayoutXY = DataLayout2D.BLOCKED_X;
                dataLayoutZ = DataLayout1D.BLOCKED;
                this.internalNextZ = 1;
                this.internalImZ = nY * nZ;
                break;
            }
            case BLOCKED_XY: {
                this.im = nX * nY;
                this.ii = 1;
                this.nextX = 1;
                this.nextY = nX;
                this.nextZ = 2 * nY * nX;
                dataLayoutXY = DataLayout2D.BLOCKED_XY;
                dataLayoutZ = DataLayout1D.BLOCKED;
                this.internalNextZ = 1;
                this.internalImZ = nY * nZ;
                break;
            }
            case BLOCKED_XYZ: {
                this.im = nX * nY * nZ;
                this.ii = 1;
                this.nextX = 1;
                this.nextY = nX;
                this.nextZ = nY * nX;
                dataLayoutXY = DataLayout2D.BLOCKED_XY;
                dataLayoutZ = DataLayout1D.BLOCKED;
                this.internalNextZ = 1;
                this.internalImZ = nY * nZ;
            }
        }
        this.useSIMD = true;
        String simd = System.getProperty("fft.simd", Boolean.toString(this.useSIMD));
        try {
            this.useSIMD = Boolean.parseBoolean(simd);
        }
        catch (Exception e) {
            this.useSIMD = false;
        }
        this.packFFTs = true;
        String pack = System.getProperty("fft.pack", Boolean.toString(this.packFFTs));
        try {
            this.packFFTs = Boolean.parseBoolean(pack);
        }
        catch (Exception e) {
            this.packFFTs = false;
        }
        this.recip = new double[nX * nY * nZ];
        this.fftXY = new Complex2D(nX, nY, dataLayoutXY, this.im);
        this.fftXY.setPackFFTs(this.packFFTs);
        this.fftXY.setUseSIMD(this.useSIMD);
        this.fftZN = new Complex(nZ, dataLayoutZ, this.internalImZ, nY);
        this.fftZN.setUseSIMD(this.useSIMD);
        this.work = new double[2 * nZ * nY];
    }

    public void setUseSIMD(boolean useSIMD) {
        this.useSIMD = useSIMD;
        this.fftXY.setUseSIMD(useSIMD);
        this.fftZN.setUseSIMD(useSIMD);
    }

    public void setPackFFTs(boolean packFFTs) {
        this.packFFTs = packFFTs;
        this.fftXY.setPackFFTs(packFFTs);
    }

    public static int interleavedIndex(int i, int j, int k, int nX, int nY) {
        return 2 * (i + nX * (j + nY * k));
    }

    public static int index3D(int i, int j, int k, int nX, int nY, DataLayout3D layout) {
        return switch (layout) {
            default -> throw new MatchException(null, null);
            case DataLayout3D.INTERLEAVED -> Complex3D.interleavedIndex(i, j, k, nX, nY);
            case DataLayout3D.BLOCKED_X -> i + 2 * (nX * (j + nY * k));
            case DataLayout3D.BLOCKED_XY -> i + nX * (j + 2 * nY * k);
            case DataLayout3D.BLOCKED_XYZ -> i + nX * (j + nY * k);
        };
    }

    public void fft(double[] input) {
        for (int z = 0; z < this.nZ; ++z) {
            this.fftXY.fft(input, z * this.nextZ);
        }
        int offset = 0;
        for (int x = 0; x < this.nX; ++x) {
            this.selectYZPlane(offset, input);
            this.fftZN.fft(this.work, 0, this.ii);
            this.replaceYZPlane(offset, input);
            offset += this.nextX;
        }
    }

    public void ifft(double[] input) {
        int offset = 0;
        for (int x = 0; x < this.nX; ++x) {
            this.selectYZPlane(offset, input);
            this.fftZN.ifft(this.work, 0, this.ii);
            this.replaceYZPlane(offset, input);
            offset += this.nextX;
        }
        for (int z = 0; z < this.nZ; ++z) {
            this.fftXY.ifft(input, z * this.nextZ);
        }
    }

    public void convolution(double[] input) {
        int z;
        for (z = 0; z < this.nZ; ++z) {
            this.fftXY.fft(input, z * this.nextZ);
        }
        int offset = 0;
        for (int x = 0; x < this.nX; ++x) {
            this.selectYZPlane(offset, input);
            this.fftZN.fft(this.work, 0, this.internalNextZ);
            this.recipConv(x, this.work);
            this.fftZN.ifft(this.work, 0, this.internalNextZ);
            this.replaceYZPlane(offset, input);
            offset += this.nextX;
        }
        for (z = 0; z < this.nZ; ++z) {
            this.fftXY.ifft(input, z * this.nextZ);
        }
    }

    public void setRecip(double[] recip) {
        int recipNextY = this.nX;
        int recipNextZ = this.nY * this.nX;
        int index = 0;
        for (int x = 0; x < this.nX; ++x) {
            int dx = x;
            for (int z = 0; z < this.nZ; ++z) {
                int dz = dx + z * recipNextZ;
                for (int y = 0; y < this.nY; ++y) {
                    int conv = y * recipNextY + dz;
                    this.recip[index] = recip[conv];
                    ++index;
                }
            }
        }
    }

    private void selectYZPlane(int offset, double[] input) {
        int index = 0;
        for (int z = 0; z < this.nZ; ++z) {
            int dz = offset + z * this.nextZ;
            for (int y = 0; y < this.nY; ++y) {
                double real = input[y * this.nextY + dz];
                double imag = input[y * this.nextY + dz + this.im];
                this.work[index] = real;
                this.work[index + this.internalImZ] = imag;
                index += this.ii;
            }
        }
    }

    private void replaceYZPlane(int offset, double[] output) {
        int index = 0;
        for (int z = 0; z < this.nZ; ++z) {
            int dzOut = offset + z * this.nextZ;
            for (int y = 0; y < this.nY; ++y) {
                int dyOut = y * this.nextY;
                double real = this.work[index];
                double imag = this.work[index + this.internalImZ];
                index += this.ii;
                output[dyOut + dzOut] = real;
                output[dyOut + dzOut + this.im] = imag;
            }
        }
    }

    private void recipConv(int x, double[] work) {
        int index = 0;
        int rindex = x * (this.nY * this.nZ);
        for (int z = 0; z < this.nZ; ++z) {
            for (int y = 0; y < this.nY; ++y) {
                double r = this.recip[rindex++];
                int n = index;
                work[n] = work[n] * r;
                int n2 = index + this.internalImZ;
                work[n2] = work[n2] * r;
                index += this.ii;
            }
        }
    }
}

