/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.estimator;

import ffx.numerics.estimator.StatisticalEstimator;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class SequentialEstimator
implements StatisticalEstimator {
    protected final double[] lamValues;
    protected final int nStates;
    protected final double[][] eLambdaMinusdL;
    protected final double[][] eLambda;
    protected final double[][] eLambdaPlusdL;
    protected final double[][][] eAll;
    protected double[][] eAllFlat;
    protected int[] nSamples;
    protected final double[] temperatures;

    public SequentialEstimator(double[] lambdaValues, double[][] eLambdaMinusdL, double[][] eLambda, double[][] eLambdaPlusdL, double[] temperature) {
        this.nStates = lambdaValues.length;
        this.eAll = null;
        this.eAllFlat = null;
        this.nSamples = null;
        assert (Arrays.stream(eLambdaMinusdL[0]).allMatch(Double::isNaN) && Arrays.stream(eLambdaPlusdL[this.nStates - 1]).allMatch(Double::isNaN));
        assert (this.nStates == eLambda.length && this.nStates == eLambdaMinusdL.length && this.nStates == eLambdaPlusdL.length) : "One of the energy arrays is of the incorrect length in the first dimension!";
        this.lamValues = Arrays.copyOf(lambdaValues, this.nStates);
        this.temperatures = new double[this.nStates];
        if (temperature.length == 1) {
            Arrays.fill(this.temperatures, temperature[0]);
        } else {
            System.arraycopy(temperature, 0, this.temperatures, 0, this.nStates);
        }
        this.eLambdaMinusdL = new double[this.nStates][];
        this.eLambda = new double[this.nStates][];
        this.eLambdaPlusdL = new double[this.nStates][];
        for (int i = 0; i < this.nStates; ++i) {
            if (i != 0) {
                this.eLambdaMinusdL[i] = Arrays.copyOf(eLambdaMinusdL[i], eLambdaMinusdL[i].length);
            }
            this.eLambda[i] = Arrays.copyOf(eLambda[i], eLambda[i].length);
            if (i == this.nStates - 1) continue;
            this.eLambdaPlusdL[i] = Arrays.copyOf(eLambdaPlusdL[i], eLambdaPlusdL[i].length);
        }
    }

    public SequentialEstimator(double[] lambdaValues, double[][][] energiesAll, double[] temperature) {
        int i;
        int j;
        int i2;
        Object temp;
        int j2;
        int i3;
        this.nStates = lambdaValues.length;
        assert (this.nStates == energiesAll.length) : "The energy arrays is of the incorrect length in the first lambda dimension!";
        assert (this.nStates == energiesAll[0].length) : "The energy arrays is of the incorrect length in the second lambda dimension!";
        this.lamValues = Arrays.copyOf(lambdaValues, this.nStates);
        this.temperatures = new double[this.nStates];
        if (temperature.length == 1) {
            Arrays.fill(this.temperatures, temperature[0]);
        } else {
            System.arraycopy(temperature, 0, this.temperatures, 0, this.nStates);
        }
        this.eAll = new double[this.nStates][][];
        int maxSnaps = 0;
        for (i3 = 0; i3 < this.nStates; ++i3) {
            this.eAll[i3] = new double[energiesAll[i3].length][];
            for (j2 = 0; j2 < energiesAll[i3].length; ++j2) {
                this.eAll[i3][j2] = Arrays.copyOf(energiesAll[i3][j2], energiesAll[i3][j2].length);
                maxSnaps = Math.max(maxSnaps, this.eAll[i3][j2].length);
            }
        }
        for (i3 = 0; i3 < this.nStates; ++i3) {
            for (j2 = 0; j2 < this.nStates; ++j2) {
                if (this.eAll[i3][j2].length >= maxSnaps) continue;
                temp = new double[maxSnaps];
                System.arraycopy(this.eAll[i3][j2], 0, temp, 0, this.eAll[i3][j2].length);
                for (int k = this.eAll[i3][j2].length; k < maxSnaps; ++k) {
                    temp[k] = Double.NaN;
                }
                this.eAll[i3][j2] = (double[])temp;
            }
        }
        this.nSamples = new int[this.nStates];
        int[] nanCount = new int[this.nStates];
        this.eAllFlat = new double[this.nStates][];
        for (i2 = 0; i2 < this.nStates; ++i2) {
            temp = new ArrayList();
            for (j = 0; j < this.nStates; ++j) {
                int count = 0;
                int countNaN = 0;
                for (int k = 0; k < this.eAll[j][i2].length; ++k) {
                    if (!Double.isNaN(this.eAll[j][i2][k])) {
                        ((ArrayList)temp).add(this.eAll[j][i2][k]);
                        ++count;
                        continue;
                    }
                    ++countNaN;
                }
                this.nSamples[j] = count;
                nanCount[j] = countNaN;
            }
            this.eAllFlat[i2] = temp.stream().mapToDouble(Double::doubleValue).toArray();
        }
        for (i2 = 0; i2 < this.nStates; ++i2) {
            if (this.nSamples[i2] + nanCount[i2] == maxSnaps) continue;
            throw new IllegalArgumentException("Lambda window " + i2 + " is not set properly. You need to fill in the missing states with NaN.");
        }
        for (i2 = 0; i2 < this.nStates; ++i2) {
            assert (this.eAll[i2].length == this.nStates) : "The energy arrays is of the incorrect length in the second lambda dimension at lambda " + i2 + "!";
            int nSnapshots = this.eAll[i2][0].length;
            for (j = 0; j < this.nStates; ++j) {
                assert (this.eAll[i2][j].length == nSnapshots) : "The energy arrays is of the incorrect length in numSnaps dimension at lambda " + i2 + " for evaluation at lambda " + j + "!";
            }
        }
        ArrayList<Integer> nonZeroSampleStates = new ArrayList<Integer>();
        for (i = 0; i < this.nStates; ++i) {
            if (this.nSamples[i] == 0) continue;
            nonZeroSampleStates.add(i);
        }
        this.eLambdaMinusdL = new double[nonZeroSampleStates.size()][this.eAll[0][0].length];
        Arrays.fill(this.eLambdaMinusdL[0], Double.NaN);
        this.eLambda = new double[nonZeroSampleStates.size()][];
        this.eLambdaPlusdL = new double[nonZeroSampleStates.size()][this.eAll[0][0].length];
        Arrays.fill(this.eLambdaPlusdL[nonZeroSampleStates.size() - 1], Double.NaN);
        for (i = 0; i < nonZeroSampleStates.size(); ++i) {
            int index = (Integer)nonZeroSampleStates.get(i);
            if (i != 0) {
                int indexLow = (Integer)nonZeroSampleStates.get(i - 1);
                this.eLambdaMinusdL[i] = Arrays.copyOf(this.eAll[index][indexLow], this.nSamples[index]);
            }
            this.eLambda[i] = Arrays.copyOf(this.eAll[index][index], this.nSamples[index]);
            if (i == nonZeroSampleStates.size() - 1) continue;
            int indexHigh = (Integer)nonZeroSampleStates.get(i + 1);
            this.eLambdaPlusdL[i] = Arrays.copyOf(this.eAll[index][indexHigh], this.nSamples[index]);
        }
    }

    public SequentialEstimator(double[] lambdaValues, int[] nSamples, double[][] eAllFlat, double[] temperature) {
        this.nStates = lambdaValues.length;
        assert (this.nStates == eAllFlat.length) : "The energy arrays is of the incorrect length in the first lambda dimension!";
        this.lamValues = Arrays.copyOf(lambdaValues, this.nStates);
        this.temperatures = new double[this.nStates];
        if (temperature.length == 1) {
            Arrays.fill(this.temperatures, temperature[0]);
        } else {
            System.arraycopy(temperature, 0, this.temperatures, 0, this.nStates);
        }
        this.eAllFlat = eAllFlat;
        this.nSamples = nSamples;
        this.eLambdaMinusdL = null;
        this.eLambda = null;
        this.eLambdaPlusdL = null;
        this.eAll = null;
    }
}

