/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.clustering.visualization;

import ffx.numerics.clustering.Cluster;
import ffx.numerics.clustering.visualization.ClusterComponent;
import ffx.numerics.clustering.visualization.VCoord;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class DendrogramPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final BasicStroke SOLID_STROKE = new BasicStroke(1.0f, 0, 1);
    private Cluster model;
    private ClusterComponent component;
    private Color lineColor = Color.BLACK;
    private boolean showDistanceValues = false;
    private boolean showScale = true;
    private int borderTop = 20;
    private int borderLeft = 20;
    private int borderRight = 20;
    private int borderBottom = 20;
    private int scalePadding = 10;
    private int scaleTickLength = 4;
    private int scaleTickLabelPadding = 4;
    private double scaleValueInterval = 0.0;
    private int scaleValueDecimals = 0;
    private double xModelOrigin = 0.0;
    private double yModelOrigin = 0.0;
    private double wModel = 0.0;
    private double hModel = 0.0;

    public boolean isShowDistanceValues() {
        return this.showDistanceValues;
    }

    public void setShowDistances(boolean showDistanceValues) {
        this.showDistanceValues = showDistanceValues;
    }

    public boolean isShowScale() {
        return this.showScale;
    }

    public void setShowScale(boolean showScale) {
        this.showScale = showScale;
    }

    public int getScalePadding() {
        return this.scalePadding;
    }

    public void setScalePadding(int scalePadding) {
        this.scalePadding = scalePadding;
    }

    public int getScaleTickLength() {
        return this.scaleTickLength;
    }

    public void setScaleTickLength(int scaleTickLength) {
        this.scaleTickLength = scaleTickLength;
    }

    public double getScaleValueInterval() {
        return this.scaleValueInterval;
    }

    public void setScaleValueInterval(double scaleTickInterval) {
        this.scaleValueInterval = scaleTickInterval;
    }

    public int getScaleValueDecimals() {
        return this.scaleValueDecimals;
    }

    public void setScaleValueDecimals(int scaleValueDecimals) {
        this.scaleValueDecimals = scaleValueDecimals;
    }

    public int getBorderTop() {
        return this.borderTop;
    }

    public void setBorderTop(int borderTop) {
        this.borderTop = borderTop;
    }

    public int getBorderLeft() {
        return this.borderLeft;
    }

    public void setBorderLeft(int borderLeft) {
        this.borderLeft = borderLeft;
    }

    public int getBorderRight() {
        return this.borderRight;
    }

    public void setBorderRight(int borderRight) {
        this.borderRight = borderRight;
    }

    public int getBorderBottom() {
        return this.borderBottom;
    }

    public void setBorderBottom(int borderBottom) {
        this.borderBottom = borderBottom;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Cluster getModel() {
        return this.model;
    }

    public void setModel(Cluster model) {
        this.model = model;
        this.component = this.createComponent(model);
        this.updateModelMetrics();
    }

    private void updateModelMetrics() {
        double minX = this.component.getRectMinX();
        double maxX = this.component.getRectMaxX();
        double minY = this.component.getRectMinY();
        double maxY = this.component.getRectMaxY();
        this.xModelOrigin = minX;
        this.yModelOrigin = minY;
        this.wModel = maxX - minX;
        this.hModel = maxY - minY;
    }

    private ClusterComponent createComponent(Cluster cluster, VCoord initCoord, double clusterHeight) {
        ClusterComponent comp = null;
        if (cluster != null) {
            comp = new ClusterComponent(cluster, cluster.isLeaf(), initCoord);
            double leafHeight = clusterHeight / (double)cluster.countLeafs();
            double yChild = initCoord.y() - clusterHeight / 2.0;
            double distance = cluster.getDistanceValue() == null ? 0.0 : cluster.getDistanceValue();
            for (Cluster child : cluster.getChildren()) {
                int childLeafCount = child.countLeafs();
                double childHeight = (double)childLeafCount * leafHeight;
                double childDistance = child.getDistanceValue() == null ? 0.0 : child.getDistanceValue();
                VCoord childInitCoord = new VCoord(initCoord.x() + (distance - childDistance), yChild + childHeight / 2.0);
                yChild += childHeight;
                ClusterComponent childComp = this.createComponent(child, childInitCoord, childHeight);
                childComp.setLinkPoint(initCoord);
                comp.getChildren().add(childComp);
            }
        }
        return comp;
    }

    private ClusterComponent createComponent(Cluster model) {
        double virtualModelHeight = 1.0;
        VCoord initCoord = new VCoord(0.0, virtualModelHeight / 2.0);
        ClusterComponent comp = this.createComponent(model, initCoord, virtualModelHeight);
        comp.setLinkPoint(initCoord);
        return comp;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.lineColor);
        g2.setStroke(SOLID_STROKE);
        int wDisplay = this.getWidth() - this.borderLeft - this.borderRight;
        int hDisplay = this.getHeight() - this.borderTop - this.borderBottom;
        int xDisplayOrigin = this.borderLeft;
        int yDisplayOrigin = this.borderBottom;
        if (this.component != null) {
            int nameGutterWidth = this.component.getMaxNameWidth(g2, false) + this.component.getNamePadding();
            wDisplay -= nameGutterWidth;
            if (this.showScale) {
                Rectangle2D rect = g2.getFontMetrics().getStringBounds("0", g2);
                int scaleHeight = (int)rect.getHeight() + this.scalePadding + this.scaleTickLength + this.scaleTickLabelPadding;
                hDisplay -= scaleHeight;
                yDisplayOrigin += scaleHeight;
            }
            double xFactor = (double)wDisplay / this.wModel;
            double yFactor = (double)hDisplay / this.hModel;
            int xOffset = (int)((double)xDisplayOrigin - this.xModelOrigin * xFactor);
            int yOffset = (int)((double)yDisplayOrigin - this.yModelOrigin * yFactor);
            this.component.paint(g2, xOffset, yOffset, xFactor, yFactor, this.showDistanceValues);
            if (this.showScale) {
                int x1 = xDisplayOrigin;
                int y1 = yDisplayOrigin - this.scalePadding;
                int x2 = x1 + wDisplay;
                int y2 = y1;
                g2.drawLine(x1, y1, x2, y2);
                double totalDistance = this.component.getCluster().getTotalDistance();
                double xModelInterval = this.scaleValueInterval <= 0.0 ? totalDistance / 10.0 : this.scaleValueInterval;
                int xTick = xDisplayOrigin + wDisplay;
                y1 = yDisplayOrigin - this.scalePadding;
                y2 = yDisplayOrigin - this.scalePadding - this.scaleTickLength;
                double distanceValue = 0.0;
                double xDisplayInterval = xModelInterval * xFactor;
                while (xTick >= xDisplayOrigin) {
                    g2.drawLine(xTick, y1, xTick, y2);
                    String distanceValueStr = String.format("%." + this.scaleValueDecimals + "f", distanceValue);
                    Rectangle2D rect = g2.getFontMetrics().getStringBounds(distanceValueStr, g2);
                    g2.drawString(distanceValueStr, (int)((double)xTick - rect.getWidth() / 2.0), y2 - this.scaleTickLabelPadding);
                    xTick = (int)((double)xTick - xDisplayInterval);
                    distanceValue += xModelInterval;
                }
            }
        } else {
            String str = "No data";
            Rectangle2D rect = g2.getFontMetrics().getStringBounds(str, g2);
            int xt = (int)((double)wDisplay / 2.0 - rect.getWidth() / 2.0);
            int yt = (int)((double)hDisplay / 2.0 - rect.getHeight() / 2.0);
            g2.drawString(str, xt, yt);
        }
    }
}

