/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.clustering;

import ffx.numerics.clustering.Cluster;
import ffx.numerics.clustering.ClusterPair;
import ffx.numerics.clustering.ClusteringAlgorithm;
import ffx.numerics.clustering.Distance;
import ffx.numerics.clustering.DistanceMap;
import ffx.numerics.clustering.HierarchyBuilder;
import ffx.numerics.clustering.LinkageStrategy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class DefaultClusteringAlgorithm
implements ClusteringAlgorithm {
    @Override
    public Cluster performClustering(double[][] distances, String[] clusterNames, LinkageStrategy linkageStrategy) {
        this.checkArguments(distances, clusterNames, linkageStrategy);
        List<Cluster> clusters = this.createClusters(clusterNames);
        DistanceMap linkages = this.createLinkages(distances, clusters);
        HierarchyBuilder builder = new HierarchyBuilder(clusters, linkages);
        while (!builder.isTreeComplete()) {
            builder.agglomerate(linkageStrategy);
        }
        return builder.getRootCluster();
    }

    @Override
    public List<Cluster> performFlatClustering(double[][] distances, String[] clusterNames, LinkageStrategy linkageStrategy, Double threshold) {
        this.checkArguments(distances, clusterNames, linkageStrategy);
        List<Cluster> clusters = this.createClusters(clusterNames);
        DistanceMap linkages = this.createLinkages(distances, clusters);
        HierarchyBuilder builder = new HierarchyBuilder(clusters, linkages);
        return builder.flatAgg(linkageStrategy, threshold);
    }

    private void checkArguments(double[][] distances, String[] clusterNames, LinkageStrategy linkageStrategy) {
        if (distances == null || distances.length == 0 || distances[0].length != distances.length) {
            throw new IllegalArgumentException("Invalid distance matrix");
        }
        if (distances.length != clusterNames.length) {
            throw new IllegalArgumentException("Invalid cluster name array");
        }
        if (linkageStrategy == null) {
            throw new IllegalArgumentException("Undefined linkage strategy");
        }
        int uniqueCount = new HashSet<String>(Arrays.asList(clusterNames)).size();
        if (uniqueCount != clusterNames.length) {
            throw new IllegalArgumentException("Duplicate names");
        }
    }

    @Override
    public Cluster performWeightedClustering(double[][] distances, String[] clusterNames, double[] weights, LinkageStrategy linkageStrategy) {
        this.checkArguments(distances, clusterNames, linkageStrategy);
        if (weights.length != clusterNames.length) {
            throw new IllegalArgumentException("Invalid weights array");
        }
        List<Cluster> clusters = this.createClusters(clusterNames, weights);
        DistanceMap linkages = this.createLinkages(distances, clusters);
        HierarchyBuilder builder = new HierarchyBuilder(clusters, linkages);
        while (!builder.isTreeComplete()) {
            builder.agglomerate(linkageStrategy);
        }
        return builder.getRootCluster();
    }

    private DistanceMap createLinkages(double[][] distances, List<Cluster> clusters) {
        DistanceMap linkages = new DistanceMap();
        for (int col = 0; col < clusters.size(); ++col) {
            for (int row = col + 1; row < clusters.size(); ++row) {
                ClusterPair link = new ClusterPair();
                Cluster lCluster = clusters.get(col);
                Cluster rCluster = clusters.get(row);
                link.setLinkageDistance(distances[col][row]);
                link.setlCluster(lCluster);
                link.setrCluster(rCluster);
                linkages.add(link);
            }
        }
        return linkages;
    }

    private List<Cluster> createClusters(String[] clusterNames) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        for (String clusterName : clusterNames) {
            Cluster cluster = new Cluster(clusterName);
            cluster.addLeafName(clusterName);
            clusters.add(cluster);
        }
        return clusters;
    }

    private List<Cluster> createClusters(String[] clusterNames, double[] weights) {
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        for (int i = 0; i < weights.length; ++i) {
            Cluster cluster = new Cluster(clusterNames[i]);
            cluster.setDistance(new Distance(0.0, weights[i]));
            clusters.add(cluster);
        }
        return clusters;
    }
}

