/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics.clustering;

import ffx.numerics.clustering.Distance;
import java.util.ArrayList;
import java.util.List;

public class Cluster {
    private String name;
    private Cluster parent;
    private List<Cluster> children;
    private final List<String> leafNames;
    private Distance distance = new Distance();

    public Cluster(String name) {
        this.name = name;
        this.leafNames = new ArrayList<String>();
    }

    public Distance getDistance() {
        return this.distance;
    }

    public Double getWeightValue() {
        return this.distance.getWeight();
    }

    public Double getDistanceValue() {
        return this.distance.getDistance();
    }

    public void setDistance(Distance distance) {
        this.distance = distance;
    }

    public List<Cluster> getChildren() {
        if (this.children == null) {
            this.children = new ArrayList<Cluster>();
        }
        return this.children;
    }

    public void addLeafName(String lname) {
        this.leafNames.add(lname);
    }

    public void appendLeafNames(List<String> lnames) {
        this.leafNames.addAll(lnames);
    }

    public List<String> getLeafNames() {
        return this.leafNames;
    }

    public void setChildren(List<Cluster> children) {
        this.children = children;
    }

    public Cluster getParent() {
        return this.parent;
    }

    public void setParent(Cluster parent) {
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addChild(Cluster cluster) {
        this.getChildren().add(cluster);
    }

    public boolean contains(Cluster cluster) {
        return this.getChildren().contains(cluster);
    }

    public String toString() {
        return "Cluster " + this.name;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (this.name == null) {
            return other.name == null;
        }
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean isLeaf() {
        return this.getChildren().isEmpty();
    }

    public int countLeafs() {
        return this.countLeafs(this, 0);
    }

    public int countLeafs(Cluster node, int count) {
        if (node.isLeaf()) {
            ++count;
        }
        for (Cluster child : node.getChildren()) {
            count += child.countLeafs();
        }
        return count;
    }

    public void toConsole(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("  ");
        }
        String name = this.getName() + (this.isLeaf() ? " (leaf)" : "") + (String)(this.distance != null ? "  distance: " + String.valueOf(this.distance) : "");
        System.out.println(name);
        for (Cluster child : this.getChildren()) {
            child.toConsole(indent + 1);
        }
    }

    public String toNewickString(int indent) {
        StringBuilder cdtString = new StringBuilder();
        if (!this.isLeaf()) {
            cdtString.append("(");
        }
        cdtString.append(" ".repeat(Math.max(0, indent)));
        if (this.isLeaf()) {
            cdtString.append(this.getName());
        }
        List<Cluster> children = this.getChildren();
        boolean firstChild = true;
        for (Cluster child : children) {
            cdtString.append(child.toNewickString(indent));
            String distanceString = this.distance.getDistance().toString().replace(",", ".");
            String weightString = this.distance.getWeight().toString().replace(",", ".");
            if (firstChild) {
                cdtString.append(":").append(distanceString).append(",");
            } else {
                cdtString.append(":").append(weightString);
            }
            firstChild = false;
        }
        cdtString.append(" ".repeat(Math.max(0, indent)));
        if (!this.isLeaf()) {
            cdtString.append(")");
        }
        return cdtString.toString();
    }

    public double getTotalDistance() {
        double dist;
        double d = dist = this.getDistance() == null ? 0.0 : this.getDistance().getDistance();
        if (!this.getChildren().isEmpty()) {
            dist += this.children.getFirst().getTotalDistance();
        }
        return dist;
    }
}

