/*
 * Decompiled with CFR 0.152.
 */
package ffx.numerics;

import ffx.numerics.Potential;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public interface OptimizationInterface {
    default public boolean destroy() {
        return true;
    }

    public double energy(double[] var1);

    default public double energy(double[] x, boolean verbose) {
        return this.energy(x);
    }

    public double energyAndGradient(double[] var1, double[] var2);

    default public double energyAndGradient(double[] x, double[] g, boolean verbose) {
        return this.energyAndGradient(x, g);
    }

    public double[] getCoordinates(double[] var1);

    public void setCoordinates(double[] var1);

    public int getNumberOfVariables();

    public double[] getScaling();

    public void setScaling(@Nullable double[] var1);

    public double getTotalEnergy();

    default public List<Potential> getUnderlyingPotentials() {
        return Collections.emptyList();
    }

    default public void scaleCoordinates(double[] x) {
        double[] scaling = this.getScaling();
        if (scaling != null) {
            int nParams = x.length;
            for (int i = 0; i < nParams; ++i) {
                int n = i;
                x[n] = x[n] * scaling[i];
            }
        }
    }

    default public void scaleCoordinatesAndGradient(double[] x, double[] g) {
        double[] scaling = this.getScaling();
        if (scaling != null) {
            int len = x.length;
            for (int i = 0; i < len; ++i) {
                int n = i;
                x[n] = x[n] * scaling[i];
                int n2 = i;
                g[n2] = g[n2] / scaling[i];
            }
        }
    }

    default public void unscaleCoordinates(double[] x) {
        double[] scaling = this.getScaling();
        if (scaling != null) {
            int nParams = x.length;
            for (int i = 0; i < nParams; ++i) {
                int n = i;
                x[n] = x[n] / scaling[i];
            }
        }
    }
}

