/*
 * Decompiled with CFR 0.152.
 */
package com.apple.mrj.datatransfer;

import com.apple.mrj.MRJOSType;
import java.awt.datatransfer.DataFlavor;
import java.util.Hashtable;

public class OSTypeFlavor
extends DataFlavor {
    public static final String kOSTypeMIMEType = "application/x-mac-data";
    public static final String kOSTypeMIMETypeAttribute = "ostype";
    private static final String kOSTypeMIMEPrefix = "application/x-mac-data; ostype=";
    private final MRJOSType fOSType;
    private static final Object[] kDefaultTypeMap = new Object[]{MRJOSType.kTypeTEXT, "text/plain;charset=x-mac-roman", MRJOSType.kTypeUtxt, "text/plain;charset=unicode", MRJOSType.kTypePICT, "image/x-pict", MRJOSType.kTypeGIFF, "image/gif", MRJOSType.kTypeJPEG, "image/jpeg", MRJOSType.kTypeURL, "application/x-url", MRJOSType.kTypeMoov, "video/quicktime", MRJOSType.kTypeJser, "application/x-java-serialized-object"};
    private static final Hashtable sMimeToOSType = new Hashtable(kDefaultTypeMap.length / 2);
    private static final Hashtable sOSTypeToMime = new Hashtable(kDefaultTypeMap.length / 2);
    public static final OSTypeFlavor kTypeTEXT;
    public static final OSTypeFlavor kTypeStyl;
    public static final OSTypeFlavor kTypeUtxt;
    public static final OSTypeFlavor kTypeUstl;
    public static final OSTypeFlavor kTypePICT;
    public static final OSTypeFlavor kTypeHFS;
    public static final OSTypeFlavor kTypeURL;

    public OSTypeFlavor(MRJOSType mRJOSType, String string, String string2) {
        super(string, string2);
        if (mRJOSType == null || string == null) {
            throw new IllegalArgumentException();
        }
        this.fOSType = mRJOSType;
    }

    public OSTypeFlavor(MRJOSType mRJOSType, String string) {
        this(mRJOSType, OSTypeFlavor.getMimeTypeForOSType(mRJOSType), string);
    }

    public OSTypeFlavor(MRJOSType mRJOSType) {
        this(mRJOSType, OSTypeFlavor.getMimeTypeForOSType(mRJOSType), "'" + mRJOSType + "'");
    }

    public MRJOSType getOSType() {
        return this.fOSType;
    }

    public boolean equals(Object object) {
        return this == object || object instanceof DataFlavor && ((DataFlavor)object).equals(this);
    }

    public int hashCode() {
        return this.fOSType.hashCode();
    }

    public static boolean addMapping(MRJOSType mRJOSType, String string) {
        if (mRJOSType == null || string == null) {
            throw new NullPointerException();
        }
        sOSTypeToMime.put(mRJOSType, string);
        return sMimeToOSType.put(string, mRJOSType) != null;
    }

    public static String getMimeTypeForOSType(MRJOSType mRJOSType) {
        String string = (String)sOSTypeToMime.get(mRJOSType);
        if (string == null) {
            string = OSTypeFlavor.synthesizeMimeType(mRJOSType);
        }
        return string;
    }

    public static MRJOSType getOSTypeForMimeType(String string) {
        MRJOSType mRJOSType = (MRJOSType)sMimeToOSType.get(string);
        if (mRJOSType != null) {
            return mRJOSType;
        }
        int n = string.indexOf(59);
        if (n >= 0 && (mRJOSType = (MRJOSType)sMimeToOSType.get(string = string.substring(0, n).trim())) != null) {
            return mRJOSType;
        }
        return OSTypeFlavor.readSynthesizedMimeType(string);
    }

    public static String synthesizeMimeType(MRJOSType mRJOSType) {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(kOSTypeMIMEPrefix);
        stringBuffer.append('\"');
        int n = mRJOSType.toInt();
        int n2 = 0;
        while (n2 < 4) {
            char c = (char)(n >> 24 & 0xFF);
            n <<= 8;
            if (c >= ' ' && c < '\u0080' && c != '%') {
                stringBuffer.append(c);
            } else {
                stringBuffer.append("%");
                if (c < '\u0010') {
                    stringBuffer.append('0');
                }
                stringBuffer.append(Integer.toHexString(c));
            }
            ++n2;
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }

    public static MRJOSType readSynthesizedMimeType(String string) {
        if (string.startsWith(kOSTypeMIMEPrefix)) {
            try {
                int n = kOSTypeMIMEPrefix.length();
                char c = string.charAt(n);
                if (c == '\"') {
                    ++n;
                }
                int n2 = 0;
                int n3 = 0;
                while (n3 < 4) {
                    c = string.charAt(n++);
                    n2 <<= 8;
                    if (c != '%') {
                        n2 |= c & 0xFF;
                    } else {
                        int n4;
                        if ((n4 = Character.digit(string.charAt(n++), 16)) < 0) {
                            return null;
                        }
                        n2 |= n4 << 4;
                        if ((n4 = Character.digit(string.charAt(n++), 16)) < 0) {
                            return null;
                        }
                        n2 |= n4;
                    }
                    ++n3;
                }
                return new MRJOSType(n2);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            }
        }
        return null;
    }

    static {
        int n = 0;
        while (n < kDefaultTypeMap.length) {
            OSTypeFlavor.addMapping((MRJOSType)kDefaultTypeMap[n], (String)kDefaultTypeMap[n + 1]);
            n += 2;
        }
        kTypeTEXT = new OSTypeFlavor(MRJOSType.kTypeTEXT);
        kTypeStyl = new OSTypeFlavor(MRJOSType.kTypeStyl);
        kTypeUtxt = new OSTypeFlavor(MRJOSType.kTypeUtxt);
        kTypeUstl = new OSTypeFlavor(MRJOSType.kTypeUstl);
        kTypePICT = new OSTypeFlavor(MRJOSType.kTypePICT);
        kTypeHFS = new OSTypeFlavor(MRJOSType.kTypeHFS);
        kTypeURL = new OSTypeFlavor(MRJOSType.kTypeURL);
    }
}

