/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.utils;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import uk.ac.manchester.tornado.api.types.HalfFloat;

public final class TornadoAPIUtils {
    public static final int ONE_GIGABYTE = 0x40000000;
    public static final int ONE_MEGABYTE = 0x100000;
    public static final int ONE_KILOBYTE = 1024;

    private TornadoAPIUtils() {
    }

    public static long parseSize(String size) {
        if (size.endsWith("B")) {
            int index = size.indexOf("B");
            String prefixes = "KMGTPE";
            if ("KMGTPE".contains(size.substring(index - 1, index))) {
                int prefix = "KMGTPE".indexOf(size.charAt(index - 1));
                long base = 1024L;
                long unit = (long)Math.pow(1024.0, prefix + 1);
                return Long.parseLong(size.substring(0, index - 1)) * unit;
            }
            return Long.parseLong(size.substring(0, index - 1));
        }
        return Long.parseLong(size);
    }

    public static String humanReadableByteCount(long bytes, boolean si) {
        int unit;
        int n = unit = si ? 1000 : 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        String pre = (si ? "kMGTPE" : "KMGTPE").charAt(exp - 1) + (si ? "" : "i");
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), pre);
    }

    public static String humanReadableFreq(int freq) {
        int unit = 1000;
        if (freq < 1000) {
            return freq + " MHz";
        }
        int exp = (int)(Math.log(freq) / Math.log(1000.0));
        char pre = "GT".charAt(exp - 1);
        return String.format("%.1f %sHz", (double)freq / Math.pow(1000.0, exp), Character.valueOf(pre));
    }

    public static String formatBytes(long bytes) {
        String out = "";
        out = bytes >= 0x40000000L ? String.format("%.2f GB", (double)bytes / 1.073741824E9) : (bytes >= 0x100000L ? String.format("%.2f MB", (double)bytes / 1048576.0) : (bytes >= 1024L ? String.format("%.2f KB", (double)bytes / 1024.0) : String.format("%d B", bytes)));
        return out;
    }

    public static String formatBytesPerSecond(double bytes) {
        String out = "";
        out = bytes >= 1.073741824E9 ? String.format("%.2f GB/s", bytes / 1.073741824E9) : (bytes >= 1048576.0 ? String.format("%.2f MB/s", bytes / 1048576.0) : (bytes >= 1024.0 ? String.format("%.2f KB/s", bytes / 1024.0) : String.format("%f B/s", bytes)));
        return out;
    }

    public static boolean isBoxedPrimitive(Object obj) {
        boolean isBox = false;
        if (obj instanceof Boolean) {
            isBox = true;
        } else if (obj instanceof Byte) {
            isBox = true;
        } else if (obj instanceof Character) {
            isBox = true;
        } else if (obj instanceof Short) {
            isBox = true;
        } else if (obj instanceof HalfFloat) {
            isBox = true;
        } else if (obj instanceof Integer) {
            isBox = true;
        } else if (obj instanceof Long) {
            isBox = true;
        } else if (obj instanceof Float) {
            isBox = true;
        } else if (obj instanceof Double) {
            isBox = true;
        }
        return isBox;
    }

    public static boolean isBoxedPrimitiveClass(Class<?> clazz) {
        boolean isBox = false;
        if (clazz == Boolean.class) {
            isBox = true;
        } else if (clazz == Byte.class) {
            isBox = true;
        } else if (clazz == Character.class) {
            isBox = true;
        } else if (clazz == Short.class) {
            isBox = true;
        } else if (clazz == HalfFloat.class) {
            isBox = true;
        } else if (clazz == Integer.class) {
            isBox = true;
        } else if (clazz == Long.class) {
            isBox = true;
        } else if (clazz == Float.class) {
            isBox = true;
        } else if (clazz == Double.class) {
            isBox = true;
        }
        return isBox;
    }

    public static Class<?> toUnboxedPrimitiveClass(Class<?> clazz) {
        Class<Comparable<Boolean>> result = null;
        if (clazz == Boolean.class) {
            result = Boolean.TYPE;
        } else if (clazz == Byte.class) {
            result = Byte.TYPE;
        } else if (clazz == Character.class) {
            result = Character.TYPE;
        } else if (clazz == Short.class) {
            result = Short.TYPE;
        } else if (clazz == Integer.class) {
            result = Integer.TYPE;
        } else if (clazz == Long.class) {
            result = Long.TYPE;
        } else if (clazz == Float.class) {
            result = Float.TYPE;
        } else if (clazz == Double.class) {
            result = Double.TYPE;
        }
        return result != null ? result : clazz;
    }

    public static boolean isPrimitiveArray(Class<?> type) {
        Class<?> componentType = type.getComponentType();
        while (componentType.isArray()) {
            componentType = componentType.getComponentType();
        }
        return componentType.isPrimitive() || TornadoAPIUtils.isBoxedPrimitive(componentType);
    }

    public static void printBuffer(ByteBuffer buffer) {
        int i;
        System.out.printf("buffer : position=%d, remaining=%d, capacity=%d, limit=%d\n", buffer.position(), buffer.remaining(), buffer.capacity(), buffer.limit());
        System.out.printf("array  : length=%d, offset=%d\n", buffer.array().length, buffer.arrayOffset());
        System.out.printf("%-8s: ", "Index");
        for (i = 0; i < 8; ++i) {
            System.out.printf("%-8d ", i * 4);
        }
        System.out.println();
        System.out.println();
        System.out.printf("", new Object[0]);
        for (i = 0; i < buffer.remaining(); i += 32) {
            System.out.printf("%-8d: ", i);
            for (int j = 0; j < 32; j += 4) {
                for (int k = 0; k < 4; ++k) {
                    if (i + j + k < buffer.remaining()) {
                        byte b = buffer.get(i + j + k);
                        System.out.printf("%02x", b);
                        continue;
                    }
                    System.out.printf("%2s", "..");
                }
                System.out.printf(" ", new Object[0]);
            }
            System.out.println();
        }
        System.out.println();
    }

    public static void printBuffer(ByteBuffer buffer, int start, int len) {
        int i;
        System.out.printf("Index : ", new Object[0]);
        for (i = 0; i < 5; ++i) {
            System.out.printf(" %8d", i);
        }
        System.out.println();
        System.out.printf("Buffer: ", new Object[0]);
        for (i = 0; i < len; ++i) {
            System.out.printf(" %2X", buffer.get(start + i));
        }
        System.out.println();
    }

    public static double elapsedTimeInSeconds(long start, long end) {
        long duration = end - start;
        return (double)duration * 1.0E-9;
    }

    public static String formatArray(Object object) {
        String result;
        if (object.getClass().isArray()) {
            int len = Array.getLength(object);
            result = String.format("%s[%d]", object.getClass().getComponentType().getName(), len);
        } else {
            result = object.toString();
        }
        return result;
    }

    public static boolean isPrimitive(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        return TornadoAPIUtils.isBoxedPrimitive(type);
    }
}

