/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.volumes;

import java.lang.foreign.MemorySegment;
import java.nio.ShortBuffer;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.api.types.vectors.Short2;
import uk.ac.manchester.tornado.api.types.volumes.TornadoVolumesInterface;

public final class VolumeShort2
implements TornadoVolumesInterface<ShortBuffer> {
    public static final Class<VolumeShort2> TYPE = VolumeShort2.class;
    private static final int ELEMENT_SIZE = 2;
    private final ShortArray storage;
    private final int Y;
    private final int X;
    private final int Z;
    private final int numElements;

    public VolumeShort2(int width, int height, int depth, ShortArray array) {
        this.storage = array;
        this.X = width;
        this.Y = height;
        this.Z = depth;
        this.numElements = this.X * this.Y * this.Z * 2;
    }

    public VolumeShort2(int width, int height, int depth) {
        this(width, height, depth, new ShortArray(width * height * depth * 2));
    }

    public ShortArray getArray() {
        return this.storage;
    }

    private int getIndex(int x, int y, int z) {
        return z * this.X * this.Y * 2 + y * 2 * this.X + x * 2;
    }

    public Short2 get(int x, int y, int z) {
        int index = this.getIndex(x, y, z);
        return this.loadFromArray(this.storage, index);
    }

    private Short2 loadFromArray(ShortArray array, int index) {
        Short2 result = new Short2();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        return result;
    }

    public void set(int x, int y, int z, Short2 value) {
        int index = this.getIndex(x, y, z);
        this.storeToArray(value, this.storage, index);
    }

    private void storeToArray(Short2 value, ShortArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
    }

    public int Y() {
        return this.Y;
    }

    public int X() {
        return this.X;
    }

    public int Z() {
        return this.Z;
    }

    public void fill(short value) {
        this.storage.init(value);
    }

    public VolumeShort2 duplicate() {
        VolumeShort2 volume = new VolumeShort2(this.X, this.Y, this.Z);
        volume.set(this);
        return volume;
    }

    public void set(VolumeShort2 other) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, other.storage.get(i));
        }
    }

    public String toString(String fmt) {
        StringBuilder str = new StringBuilder("");
        for (int z = 0; z < this.Z(); ++z) {
            str.append(String.format("z = %d%n", z));
            for (int y = 0; y < this.Y(); ++y) {
                for (int x = 0; x < this.X(); ++x) {
                    Short2 point = this.get(x, y, z);
                    str.append(String.format(fmt, point.getX(), point.getY()) + " ");
                }
                str.append("\n");
            }
        }
        return str.toString();
    }

    public String toString() {
        return String.format("VolumeShort2 <%d x %d x %d>", this.Y, this.X, this.Z);
    }

    @Override
    public void loadFromBuffer(ShortBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ShortBuffer asBuffer() {
        return ShortBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

