/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.ShortBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Short3
implements TornadoVectorsInterface<ShortBuffer> {
    public static final Class<Short3> TYPE = Short3.class;
    private static final String NUMBER_FORMAT = "{ x=%-7d, y=%-7d, z=%-7d }";
    private static final int NUM_ELEMENTS = 3;
    @Payload
    private final short[] storage;

    private Short3(short[] nativeVectorShort) {
        this.storage = nativeVectorShort;
    }

    public Short3() {
        this(new short[3]);
    }

    public Short3(short x, short y, short z) {
        this();
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    public static Short3 add(Short3 a, Short3 b) {
        return new Short3((short)(a.getX() + b.getX()), (short)(a.getY() + b.getY()), (short)(a.getZ() + b.getZ()));
    }

    public static Short3 sub(Short3 a, Short3 b) {
        return new Short3((short)(a.getX() - b.getX()), (short)(a.getY() - b.getY()), (short)(a.getZ() - b.getZ()));
    }

    public static Short3 div(Short3 a, Short3 b) {
        return new Short3((short)(a.getX() / b.getX()), (short)(a.getY() / b.getY()), (short)(a.getZ() / b.getZ()));
    }

    public static Short3 mult(Short3 a, Short3 b) {
        return new Short3((short)(a.getX() * b.getX()), (short)(a.getY() * b.getY()), (short)(a.getZ() * b.getZ()));
    }

    public static Short3 min(Short3 a, Short3 b) {
        return new Short3(TornadoMath.min(a.getX(), b.getX()), TornadoMath.min(a.getY(), b.getY()), TornadoMath.min(a.getZ(), b.getZ()));
    }

    public static Short3 max(Short3 a, Short3 b) {
        return new Short3(TornadoMath.max(a.getX(), b.getX()), TornadoMath.max(a.getY(), b.getY()), TornadoMath.max(a.getZ(), b.getZ()));
    }

    public static Short3 add(Short3 a, short b) {
        return new Short3((short)(a.getX() + b), (short)(a.getY() + b), (short)(a.getZ() + b));
    }

    public static Short3 sub(Short3 a, short b) {
        return new Short3((short)(a.getX() - b), (short)(a.getY() - b), (short)(a.getZ() - b));
    }

    public static Short3 mult(Short3 a, short b) {
        return new Short3((short)(a.getX() * b), (short)(a.getY() * b), (short)(a.getZ() * b));
    }

    public static Short3 div(Short3 a, short b) {
        return new Short3((short)(a.getX() / b), (short)(a.getY() / b), (short)(a.getZ() / b));
    }

    public static Short3 inc(Short3 a, short value) {
        return Short3.add(a, value);
    }

    public static Short3 dec(Short3 a, short value) {
        return Short3.sub(a, value);
    }

    public static Short3 scale(Short3 a, short value) {
        return Short3.mult(a, value);
    }

    public static Short3 clamp(Short3 x, short min, short max) {
        return new Short3(TornadoMath.clamp(x.getX(), min, max), TornadoMath.clamp(x.getY(), min, max), TornadoMath.clamp(x.getZ(), min, max));
    }

    public static short min(Short3 value) {
        return TornadoMath.min(value.getX(), TornadoMath.min(value.getY(), value.getZ()));
    }

    public static short max(Short3 value) {
        return TornadoMath.max(value.getX(), TornadoMath.max(value.getY(), value.getZ()));
    }

    public static boolean isEqual(Short3 a, Short3 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public void set(Short3 value) {
        this.setX(value.getX());
        this.setY(value.getY());
        this.setZ(value.getZ());
    }

    public short get(int index) {
        return this.storage[index];
    }

    public void set(int index, short value) {
        this.storage[index] = value;
    }

    public short getX() {
        return this.get(0);
    }

    public void setX(short value) {
        this.set(0, value);
    }

    public short getY() {
        return this.get(1);
    }

    public void setY(short value) {
        this.set(1, value);
    }

    public short getZ() {
        return this.get(2);
    }

    public void setZ(short value) {
        this.set(2, value);
    }

    public Short3 duplicate() {
        Short3 vector = new Short3();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, this.getX(), this.getY(), this.getZ());
    }

    public String toString() {
        return this.toString(NUMBER_FORMAT);
    }

    @Override
    public void loadFromBuffer(ShortBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ShortBuffer asBuffer() {
        return ShortBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 3;
    }

    public short[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 6L;
    }
}

