/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.IntBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Int2
implements TornadoVectorsInterface<IntBuffer> {
    public static final Class<Int2> TYPE = Int2.class;
    private static final String NUMBER_FORMAT = "{ x=%-7d, y=%-7d }";
    private static final int NUM_ELEMENTS = 2;
    @Payload
    private final int[] storage;

    private Int2(int[] storage) {
        this.storage = storage;
    }

    public Int2() {
        this(new int[2]);
    }

    public Int2(int x, int y) {
        this();
        this.setX(x);
        this.setY(y);
    }

    public static Int2 add(Int2 a, Int2 b) {
        return new Int2(a.getX() + b.getX(), a.getY() + b.getY());
    }

    public static Int2 sub(Int2 a, Int2 b) {
        return new Int2(a.getX() - b.getX(), a.getY() - b.getY());
    }

    public static Int2 div(Int2 a, Int2 b) {
        return new Int2(a.getX() / b.getX(), a.getY() / b.getY());
    }

    public static Int2 mult(Int2 a, Int2 b) {
        return new Int2(a.getX() * b.getX(), a.getY() * b.getY());
    }

    public static Int2 min(Int2 a, Int2 b) {
        return new Int2(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()));
    }

    public static Int2 max(Int2 a, Int2 b) {
        return new Int2(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()));
    }

    public static Int2 add(Int2 a, int b) {
        return new Int2(a.getX() + b, a.getY() + b);
    }

    public static Int2 sub(Int2 a, int b) {
        return new Int2(a.getX() - b, a.getY() - b);
    }

    public static Int2 mult(Int2 a, int b) {
        return new Int2(a.getX() * b, a.getY() * b);
    }

    public static Int2 div(Int2 a, int b) {
        return new Int2(a.getX() / b, a.getY() / b);
    }

    public static Int2 inc(Int2 a, int value) {
        return Int2.add(a, value);
    }

    public static Int2 dec(Int2 a, int value) {
        return Int2.sub(a, value);
    }

    public static Int2 scaleByInverse(Int2 a, int value) {
        return Int2.mult(a, 1 / value);
    }

    public static Int2 scale(Int2 a, int value) {
        return Int2.mult(a, value);
    }

    public static Int2 clamp(Int2 x, int min, int max) {
        return new Int2(TornadoMath.clamp(x.getX(), min, max), TornadoMath.clamp(x.getY(), min, max));
    }

    public static int min(Int2 value) {
        return Math.min(value.getX(), value.getY());
    }

    public static int max(Int2 value) {
        return Math.max(value.getX(), value.getY());
    }

    public static int dot(Int2 a, Int2 b) {
        Int2 m = Int2.mult(a, b);
        return m.getX() + m.getY();
    }

    public static boolean isEqual(Int2 a, Int2 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    private int[] toArray() {
        return this.storage;
    }

    public int get(int index) {
        return this.storage[index];
    }

    public void set(int index, int value) {
        this.storage[index] = value;
    }

    public void set(Int2 value) {
        this.setX(value.getX());
        this.setY(value.getY());
    }

    public int getX() {
        return this.get(0);
    }

    public void setX(int value) {
        this.set(0, value);
    }

    public int getY() {
        return this.get(1);
    }

    public void setY(int value) {
        this.set(1, value);
    }

    public int getS0() {
        return this.get(0);
    }

    public int getS1() {
        return this.get(1);
    }

    public Int2 duplicate() {
        Int2 vector = new Int2();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, this.getX(), this.getY());
    }

    public String toString() {
        return this.toString(NUMBER_FORMAT);
    }

    @Override
    public void loadFromBuffer(IntBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public IntBuffer asBuffer() {
        return IntBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public long getNumBytes() {
        return 8L;
    }
}

