/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.IntBuffer;
import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Int16
implements TornadoVectorsInterface<IntBuffer> {
    public static final Class<Int16> TYPE = Int16.class;
    private static final int NUM_ELEMENTS = 16;
    @Payload
    private final int[] storage;

    private Int16(int[] storage) {
        this.storage = storage;
    }

    public Int16() {
        this(new int[16]);
    }

    public Int16(int s0, int s1, int s2, int s3, int s4, int s5, int s6, int s7, int s8, int s9, int s10, int s11, int s12, int s13, int s14, int s15) {
        this();
        this.setS0(s0);
        this.setS1(s1);
        this.setS2(s2);
        this.setS3(s3);
        this.setS4(s4);
        this.setS5(s5);
        this.setS6(s6);
        this.setS7(s7);
        this.setS8(s8);
        this.setS9(s9);
        this.setS10(s10);
        this.setS11(s11);
        this.setS12(s12);
        this.setS13(s13);
        this.setS14(s14);
        this.setS15(s15);
    }

    public static Int16 add(Int16 a, Int16 b) {
        Int16 result = new Int16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) + b.get(i));
        }
        return result;
    }

    public static Int16 add(Int16 a, int b) {
        Int16 result = new Int16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) + b);
        }
        return result;
    }

    public static Int16 sub(Int16 a, Int16 b) {
        Int16 result = new Int16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) - b.get(i));
        }
        return result;
    }

    public static Int16 sub(Int16 a, int b) {
        Int16 result = new Int16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) - b);
        }
        return result;
    }

    public static Int16 div(Int16 a, Int16 b) {
        Int16 result = new Int16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) / b.get(i));
        }
        return result;
    }

    public static Int16 div(Int16 a, int value) {
        Int16 result = new Int16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) / value);
        }
        return result;
    }

    public static Int16 mult(Int16 a, Int16 b) {
        Int16 result = new Int16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) * b.get(i));
        }
        return result;
    }

    public static Int16 mult(Int16 a, int value) {
        Int16 result = new Int16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) * value);
        }
        return result;
    }

    public static Int16 min(Int16 a, Int16 b) {
        Int16 result = new Int16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, Math.min(a.get(i), b.get(i)));
        }
        return result;
    }

    public static int min(Int16 value) {
        int result = Integer.MAX_VALUE;
        for (int i = 0; i < 16; ++i) {
            result = Math.min(result, value.get(i));
        }
        return result;
    }

    public static Int16 max(Int16 a, Int16 b) {
        Int16 result = new Int16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, Math.max(a.get(i), b.get(i)));
        }
        return result;
    }

    public static int max(Int16 value) {
        int result = Integer.MIN_VALUE;
        for (int i = 0; i < 16; ++i) {
            result = Math.max(result, value.get(i));
        }
        return result;
    }

    public static Int16 sqrt(Int16 a) {
        Int16 result = new Int16();
        for (int i = 0; i < 16; ++i) {
            a.set(i, (int)TornadoMath.sqrt(a.get(i)));
        }
        return result;
    }

    public static int dot(Int16 a, Int16 b) {
        Int16 m = Int16.mult(a, b);
        return m.getS0() + m.getS1() + m.getS2() + m.getS3() + m.getS4() + m.getS5() + m.getS6() + m.getS7() + m.getS8() + m.getS9() + m.getS10() + m.getS11() + m.getS12() + m.getS13() + m.getS14() + m.getS15();
    }

    public static boolean isEqual(Int16 a, Int16 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public int[] toArray() {
        return this.storage;
    }

    public int get(int index) {
        return this.storage[index];
    }

    public void set(int index, int value) {
        this.storage[index] = value;
    }

    public void set(Int16 value) {
        for (int i = 0; i < 16; ++i) {
            this.set(i, value.get(i));
        }
    }

    public int getS0() {
        return this.get(0);
    }

    public void setS0(int value) {
        this.set(0, value);
    }

    public int getS1() {
        return this.get(1);
    }

    public void setS1(int value) {
        this.set(1, value);
    }

    public int getS2() {
        return this.get(2);
    }

    public void setS2(int value) {
        this.set(2, value);
    }

    public int getS3() {
        return this.get(3);
    }

    public void setS3(int value) {
        this.set(3, value);
    }

    public int getS4() {
        return this.get(4);
    }

    public void setS4(int value) {
        this.set(4, value);
    }

    public int getS5() {
        return this.get(5);
    }

    public void setS5(int value) {
        this.set(5, value);
    }

    public int getS6() {
        return this.get(6);
    }

    public void setS6(int value) {
        this.set(6, value);
    }

    public int getS7() {
        return this.get(7);
    }

    public void setS7(int value) {
        this.set(7, value);
    }

    public int getS8() {
        return this.get(8);
    }

    public void setS8(int value) {
        this.set(8, value);
    }

    public int getS9() {
        return this.get(9);
    }

    public void setS9(int value) {
        this.set(9, value);
    }

    public int getS10() {
        return this.get(10);
    }

    public void setS10(int value) {
        this.set(10, value);
    }

    public int getS11() {
        return this.get(11);
    }

    public void setS11(int value) {
        this.set(11, value);
    }

    public int getS12() {
        return this.get(12);
    }

    public void setS12(int value) {
        this.set(12, value);
    }

    public int getS13() {
        return this.get(13);
    }

    private void setS13(int value) {
        this.set(13, value);
    }

    public int getS14() {
        return this.get(14);
    }

    public void setS14(int value) {
        this.set(14, value);
    }

    public int getS15() {
        return this.get(15);
    }

    public void setS15(int value) {
        this.set(15, value);
    }

    public Int16 duplicate() {
        Int16 vector = new Int16();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, this.getS0(), this.getS1(), this.getS2(), this.getS3(), this.getS4(), this.getS5(), this.getS6(), this.getS7(), this.getS8(), this.getS9(), this.getS10(), this.getS11(), this.getS12(), this.getS13(), this.getS13(), this.getS14(), this.getS15());
    }

    public String toString() {
        return this.toString("{%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d}");
    }

    @Override
    public void loadFromBuffer(IntBuffer buffer) {
        throw new TornadoRuntimeException("Not implemented");
    }

    @Override
    public IntBuffer asBuffer() {
        return IntBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 16;
    }

    @Override
    public long getNumBytes() {
        return 64L;
    }
}

