/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.FloatBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.Float2;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.api.types.vectors.Int4;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Float4
implements TornadoVectorsInterface<FloatBuffer> {
    public static final Class<Float4> TYPE = Float4.class;
    private static final int NUM_ELEMENTS = 4;
    @Payload
    final float[] storage;

    private Float4(float[] storage) {
        this.storage = storage;
    }

    public Float4() {
        this(new float[4]);
    }

    public Float4(float x, float y, float z, float w) {
        this();
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setW(w);
    }

    public static Float4 add(Float4 a, Float4 b) {
        return new Float4(a.getX() + b.getX(), a.getY() + b.getY(), a.getZ() + b.getZ(), a.getW() + b.getW());
    }

    public static Float4 add(Int4 a, Float4 b) {
        return new Float4((float)a.getX() + b.getX(), (float)a.getY() + b.getY(), (float)a.getZ() + b.getZ(), (float)a.getW() + b.getW());
    }

    public static Float4 add(Float4 a, Int4 b) {
        return new Float4(a.getX() + (float)b.getX(), a.getY() + (float)b.getY(), a.getZ() + (float)b.getZ(), a.getW() + (float)b.getW());
    }

    public static Float4 sub(Float4 a, Float4 b) {
        return new Float4(a.getX() - b.getX(), a.getY() - b.getY(), a.getZ() - b.getZ(), a.getW() - b.getW());
    }

    public static Float4 sub(Int4 a, Float4 b) {
        return new Float4((float)a.getX() - b.getX(), (float)a.getY() - b.getY(), (float)a.getZ() - b.getZ(), (float)a.getW() - b.getW());
    }

    public static Float4 sub(Float4 a, Int4 b) {
        return new Float4(a.getX() - (float)b.getX(), a.getY() - (float)b.getY(), a.getZ() - (float)b.getZ(), a.getW() - (float)b.getW());
    }

    public static Float4 div(Float4 a, Float4 b) {
        return new Float4(a.getX() / b.getX(), a.getY() / b.getY(), a.getZ() / b.getZ(), a.getW() / b.getW());
    }

    public static Float4 div(Int4 a, Float4 b) {
        return new Float4((float)a.getX() / b.getX(), (float)a.getY() / b.getY(), (float)a.getZ() / b.getZ(), (float)a.getW() / b.getW());
    }

    public static Float4 div(Float4 a, Int4 b) {
        return new Float4(a.getX() / (float)b.getX(), a.getY() / (float)b.getY(), a.getZ() / (float)b.getZ(), a.getW() / (float)b.getW());
    }

    public static Float4 mult(Float4 a, Float4 b) {
        return new Float4(a.getX() * b.getX(), a.getY() * b.getY(), a.getZ() * b.getZ(), a.getW() * b.getW());
    }

    public static Float4 mult(Int4 a, Float4 b) {
        return new Float4((float)a.getX() * b.getX(), (float)a.getY() * b.getY(), (float)a.getZ() * b.getZ(), (float)a.getW() * b.getW());
    }

    public static Float4 mult(Float4 a, Int4 b) {
        return new Float4(a.getX() * (float)b.getX(), a.getY() * (float)b.getY(), a.getZ() * (float)b.getZ(), a.getW() * (float)b.getW());
    }

    public static Float4 min(Float4 a, Float4 b) {
        return new Float4(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()), Math.min(a.getZ(), b.getZ()), Math.min(a.getW(), b.getW()));
    }

    public static Float4 min(Int4 a, Float4 b) {
        return new Float4(Math.min((float)a.getX(), b.getX()), Math.min((float)a.getY(), b.getY()), Math.min((float)a.getZ(), b.getZ()), Math.min((float)a.getW(), b.getW()));
    }

    public static Float4 min(Float4 a, Int4 b) {
        return new Float4(Math.min(a.getX(), (float)b.getX()), Math.min(a.getY(), (float)b.getY()), Math.min(a.getZ(), (float)b.getZ()), Math.min(a.getW(), (float)b.getW()));
    }

    public static Float4 max(Float4 a, Float4 b) {
        return new Float4(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()), Math.max(a.getZ(), b.getZ()), Math.max(a.getW(), b.getW()));
    }

    public static Float4 add(Float4 a, float b) {
        return new Float4(a.getX() + b, a.getY() + b, a.getZ() + b, a.getW() + b);
    }

    public static Float4 sub(Float4 a, float b) {
        return new Float4(a.getX() - b, a.getY() - b, a.getZ() - b, a.getW() - b);
    }

    public static Float4 mult(Float4 a, float b) {
        return new Float4(a.getX() * b, a.getY() * b, a.getZ() * b, a.getW() * b);
    }

    public static Float4 div(Float4 a, float b) {
        return new Float4(a.getX() / b, a.getY() / b, a.getZ() / b, a.getW() / b);
    }

    public static Float4 inc(Float4 a, float value) {
        return Float4.add(a, value);
    }

    public static Float4 dec(Float4 a, float value) {
        return Float4.sub(a, value);
    }

    public static Float4 scaleByInverse(Float4 a, float value) {
        return Float4.mult(a, 1.0f / value);
    }

    public static Float4 scale(Float4 a, float value) {
        return Float4.mult(a, value);
    }

    public static float sum(Float4 a) {
        return a.getX() + a.getY() + a.getZ() + a.getW();
    }

    public static Float4 sqrt(Float4 a) {
        return new Float4(TornadoMath.sqrt(a.getX()), TornadoMath.sqrt(a.getY()), TornadoMath.sqrt(a.getZ()), TornadoMath.sqrt(a.getW()));
    }

    public static Float4 floor(Float4 a) {
        return new Float4(TornadoMath.floor(a.getX()), TornadoMath.floor(a.getY()), TornadoMath.floor(a.getZ()), TornadoMath.floor(a.getW()));
    }

    public static Float4 fract(Float4 a) {
        return new Float4(TornadoMath.fract(a.getX()), TornadoMath.fract(a.getY()), TornadoMath.fract(a.getZ()), TornadoMath.fract(a.getW()));
    }

    public static Float4 clamp(Float4 x, float min, float max) {
        return new Float4(TornadoMath.clamp(x.getX(), min, max), TornadoMath.clamp(x.getY(), min, max), TornadoMath.clamp(x.getZ(), min, max), TornadoMath.clamp(x.getW(), min, max));
    }

    public static Float4 normalise(Float4 value) {
        return Float4.scaleByInverse(value, Float4.length(value));
    }

    public static float min(Float4 value) {
        return Math.min(value.getX(), Math.min(value.getY(), Math.min(value.getZ(), value.getW())));
    }

    public static float max(Float4 value) {
        return Math.max(value.getX(), Math.max(value.getY(), Math.max(value.getZ(), value.getW())));
    }

    public static float dot(Float4 a, Float4 b) {
        Float4 m = Float4.mult(a, b);
        return m.getX() + m.getY() + m.getZ() + m.getW();
    }

    public static float length(Float4 value) {
        return TornadoMath.sqrt(Float4.dot(value, value));
    }

    public static boolean isEqual(Float4 a, Float4 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public static float findULPDistance(Float4 a, Float4 b) {
        return TornadoMath.findULPDistance(a.asBuffer().array(), b.asBuffer().array());
    }

    public float get(int index) {
        return this.storage[index];
    }

    public void set(int index, float value) {
        this.storage[index] = value;
    }

    public float[] getArray() {
        return this.storage;
    }

    public void set(Float4 value) {
        this.setX(value.getX());
        this.setY(value.getY());
        this.setZ(value.getZ());
        this.setW(value.getW());
    }

    public float getX() {
        return this.get(0);
    }

    public void setX(float value) {
        this.set(0, value);
    }

    public float getY() {
        return this.get(1);
    }

    public void setY(float value) {
        this.set(1, value);
    }

    public float getZ() {
        return this.get(2);
    }

    public void setZ(float value) {
        this.set(2, value);
    }

    public float getW() {
        return this.get(3);
    }

    public void setW(float value) {
        this.set(3, value);
    }

    public Float4 duplicate() {
        Float4 vector = new Float4();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, Float.valueOf(this.getX()), Float.valueOf(this.getY()), Float.valueOf(this.getZ()), Float.valueOf(this.getW()));
    }

    public String toString() {
        return this.toString("{%.3f,%.3f,%.3f,%.3f}");
    }

    public Float2 asFloat2() {
        return new Float2(this.getX(), this.getY());
    }

    public Float3 asFloat3() {
        return new Float3(this.getX(), this.getY(), this.getZ());
    }

    public Float2 getLow() {
        return this.asFloat2();
    }

    public Float2 getHigh() {
        return new Float2(this.getZ(), this.getW());
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.getArray());
    }

    @Override
    public int size() {
        return 4;
    }

    public void fill(float value) {
        Arrays.fill(this.storage, value);
    }

    public float[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 16L;
    }
}

