/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.Float2;
import uk.ac.manchester.tornado.api.types.vectors.Int3;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Float3
implements TornadoVectorsInterface<FloatBuffer> {
    public static final Class<Float3> TYPE = Float3.class;
    private static final int NUM_ELEMENTS = 3;
    @Payload
    final float[] storage;

    private Float3(float[] nativeVectorFloat) {
        this.storage = nativeVectorFloat;
    }

    public Float3() {
        this(new float[3]);
    }

    public Float3(float x, float y, float z) {
        this();
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    public static Float3 add(Float3 a, Float3 b) {
        return new Float3(a.getX() + b.getX(), a.getY() + b.getY(), a.getZ() + b.getZ());
    }

    public static Float3 add(Int3 a, Float3 b) {
        return new Float3((float)a.getX() + b.getX(), (float)a.getY() + b.getY(), (float)a.getZ() + b.getZ());
    }

    public static Float3 add(Float3 a, Int3 b) {
        return new Float3(a.getX() + (float)b.getX(), a.getY() + (float)b.getY(), a.getZ() + (float)b.getZ());
    }

    public static Float3 sub(Float3 a, Float3 b) {
        return new Float3(a.getX() - b.getX(), a.getY() - b.getY(), a.getZ() - b.getZ());
    }

    public static Float3 sub(Int3 a, Float3 b) {
        return new Float3((float)a.getX() - b.getX(), (float)a.getY() - b.getY(), (float)a.getZ() - b.getZ());
    }

    public static Float3 sub(Float3 a, Int3 b) {
        return new Float3(a.getX() - (float)b.getX(), a.getY() - (float)b.getY(), a.getZ() - (float)b.getZ());
    }

    public static Float3 div(Float3 a, Float3 b) {
        return new Float3(a.getX() / b.getX(), a.getY() / b.getY(), a.getZ() / b.getZ());
    }

    public static Float3 div(Int3 a, Float3 b) {
        return new Float3((float)a.getX() / b.getX(), (float)a.getY() / b.getY(), (float)a.getZ() / b.getZ());
    }

    public static Float3 div(Float3 a, Int3 b) {
        return new Float3(a.getX() / (float)b.getX(), a.getY() / (float)b.getY(), a.getZ() / (float)b.getZ());
    }

    public static Float3 mult(Float3 a, Float3 b) {
        return new Float3(a.getX() * b.getX(), a.getY() * b.getY(), a.getZ() * b.getZ());
    }

    public static Float3 mult(Int3 a, Float3 b) {
        return new Float3((float)a.getX() * b.getX(), (float)a.getY() * b.getY(), (float)a.getZ() * b.getZ());
    }

    public static Float3 mult(Float3 a, Int3 b) {
        return new Float3(a.getX() * (float)b.getX(), a.getY() * (float)b.getY(), a.getZ() * (float)b.getZ());
    }

    public static Float3 min(Float3 a, Float3 b) {
        return new Float3(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()), Math.min(a.getZ(), b.getZ()));
    }

    public static Float3 min(Int3 a, Float3 b) {
        return new Float3(Math.min((float)a.getX(), b.getX()), Math.min((float)a.getY(), b.getY()), Math.min((float)a.getZ(), b.getZ()));
    }

    public static Float3 min(Float3 a, Int3 b) {
        return new Float3(Math.min(a.getX(), (float)b.getX()), Math.min(a.getY(), (float)b.getY()), Math.min(a.getZ(), (float)b.getZ()));
    }

    public static Float3 max(Float3 a, Float3 b) {
        return new Float3(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()), Math.max(a.getZ(), b.getZ()));
    }

    public static Float3 max(Int3 a, Float3 b) {
        return new Float3(Math.max((float)a.getX(), b.getX()), Math.max((float)a.getY(), b.getY()), Math.max((float)a.getZ(), b.getZ()));
    }

    public static Float3 max(Float3 a, Int3 b) {
        return new Float3(Math.max(a.getX(), (float)b.getX()), Math.max(a.getY(), (float)b.getY()), Math.max(a.getZ(), (float)b.getZ()));
    }

    public static Float3 cross(Float3 a, Float3 b) {
        return new Float3(a.getY() * b.getZ() - a.getZ() * b.getY(), a.getZ() * b.getX() - a.getX() * b.getZ(), a.getX() * b.getY() - a.getY() * b.getX());
    }

    public static Float3 add(Float3 a, float b) {
        return new Float3(a.getX() + b, a.getY() + b, a.getZ() + b);
    }

    public static Float3 sub(Float3 a, float b) {
        return new Float3(a.getX() - b, a.getY() - b, a.getZ() - b);
    }

    public static Float3 mult(Float3 a, float b) {
        return new Float3(a.getX() * b, a.getY() * b, a.getZ() * b);
    }

    public static Float3 div(Float3 a, float b) {
        return new Float3(a.getX() / b, a.getY() / b, a.getZ() / b);
    }

    public static Float3 inc(Float3 a, float value) {
        return new Float3(a.getX() + value, a.getY() + value, a.getZ() + value);
    }

    public static Float3 dec(Float3 a, float value) {
        return new Float3(a.getX() - value, a.getY() - value, a.getZ() - value);
    }

    public static Float3 scaleByInverse(Float3 a, float value) {
        return Float3.mult(a, 1.0f / value);
    }

    public static Float3 scale(Float3 a, float value) {
        return Float3.mult(a, value);
    }

    public static Float3 sqrt(Float3 a) {
        return new Float3(TornadoMath.sqrt(a.getX()), TornadoMath.sqrt(a.getY()), TornadoMath.sqrt(a.getZ()));
    }

    public static Float3 floor(Float3 a) {
        return new Float3(TornadoMath.floor(a.getX()), TornadoMath.floor(a.getY()), TornadoMath.floor(a.getZ()));
    }

    public static Float3 fract(Float3 a) {
        return new Float3(TornadoMath.fract(a.getX()), TornadoMath.fract(a.getY()), TornadoMath.fract(a.getZ()));
    }

    public static Float3 clamp(Float3 x, float min, float max) {
        return new Float3(TornadoMath.clamp(x.getX(), min, max), TornadoMath.clamp(x.getY(), min, max), TornadoMath.clamp(x.getZ(), min, max));
    }

    public static Float3 normalise(Float3 value) {
        float len = 1.0f / Float3.length(value);
        return Float3.mult(value, len);
    }

    public static float min(Float3 value) {
        return Math.min(value.getX(), Math.min(value.getY(), value.getZ()));
    }

    public static float max(Float3 value) {
        return Math.max(value.getX(), Math.max(value.getY(), value.getZ()));
    }

    public static float dot(Float3 a, Float3 b) {
        Float3 m = Float3.mult(a, b);
        return m.getX() + m.getY() + m.getZ();
    }

    public static float length(Float3 value) {
        return TornadoMath.sqrt(Float3.dot(value, value));
    }

    public static boolean isEqual(Float3 a, Float3 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public static boolean isEqualULP(Float3 a, Float3 b, float numULP) {
        return TornadoMath.isEqualULP(a.asBuffer().array(), b.asBuffer().array(), numULP);
    }

    public static float findULPDistance(Float3 a, Float3 b) {
        return TornadoMath.findULPDistance(a.asBuffer().array(), b.asBuffer().array());
    }

    public float get(int index) {
        return this.storage[index];
    }

    public void set(int index, float value) {
        this.storage[index] = value;
    }

    public void set(Float3 value) {
        this.setX(value.getX());
        this.setY(value.getY());
        this.setZ(value.getZ());
    }

    public float getX() {
        return this.get(0);
    }

    public void setX(float value) {
        this.set(0, value);
    }

    public float getY() {
        return this.get(1);
    }

    public void setY(float value) {
        this.set(1, value);
    }

    public float getZ() {
        return this.get(2);
    }

    public void setZ(float value) {
        this.set(2, value);
    }

    public float getS0() {
        return this.get(0);
    }

    public void setS0(float value) {
        this.set(0, value);
    }

    public float getS1() {
        return this.get(1);
    }

    public void setS1(float value) {
        this.set(1, value);
    }

    public float getS2() {
        return this.get(2);
    }

    public void setS2(float value) {
        this.set(2, value);
    }

    public Float3 duplicate() {
        Float3 vector = new Float3();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, Float.valueOf(this.getX()), Float.valueOf(this.getY()), Float.valueOf(this.getZ()));
    }

    public String toString() {
        return this.toString("{%.3f,%.3f,%.3f}");
    }

    public Float2 asFloat2() {
        return new Float2(this.getX(), this.getY());
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 3;
    }

    public float[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 12L;
    }
}

