/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.Int2;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Float2
implements TornadoVectorsInterface<FloatBuffer> {
    public static final Class<Float2> TYPE = Float2.class;
    private static final int NUM_ELEMENTS = 2;
    @Payload
    final float[] storage;

    private Float2(float[] storage) {
        this.storage = storage;
    }

    public Float2() {
        this(new float[2]);
    }

    public Float2(float x, float y) {
        this();
        this.setX(x);
        this.setY(y);
    }

    public static Float2 add(Float2 a, Float2 b) {
        return new Float2(a.getX() + b.getX(), a.getY() + b.getY());
    }

    public static Float2 add(Float2 a, Int2 b) {
        return new Float2(a.getX() + (float)b.getX(), a.getY() + (float)b.getY());
    }

    public static Float2 add(Int2 a, Float2 b) {
        return new Float2((float)a.getX() + b.getX(), (float)a.getY() + b.getY());
    }

    public static Float2 sub(Float2 a, Float2 b) {
        return new Float2(a.getX() - b.getX(), a.getY() - b.getY());
    }

    public static Float2 sub(Int2 a, Float2 b) {
        return new Float2((float)a.getX() - b.getX(), (float)a.getY() - b.getY());
    }

    public static Float2 sub(Float2 a, Int2 b) {
        return new Float2(a.getX() - (float)b.getX(), a.getY() - (float)b.getY());
    }

    public static Float2 div(Float2 a, Float2 b) {
        return new Float2(a.getX() / b.getX(), a.getY() / b.getY());
    }

    public static Float2 div(Int2 a, Float2 b) {
        return new Float2((float)a.getX() / b.getX(), (float)a.getY() / b.getY());
    }

    public static Float2 div(Float2 a, Int2 b) {
        return new Float2(a.getX() / (float)b.getX(), a.getY() / (float)b.getY());
    }

    public static Float2 mult(Float2 a, Float2 b) {
        return new Float2(a.getX() * b.getX(), a.getY() * b.getY());
    }

    public static Float2 mult(Int2 a, Float2 b) {
        return new Float2((float)a.getX() * b.getX(), (float)a.getY() * b.getY());
    }

    public static Float2 mult(Float2 a, Int2 b) {
        return new Float2(a.getX() * (float)b.getX(), a.getY() * (float)b.getY());
    }

    public static Float2 min(Float2 a, Float2 b) {
        return new Float2(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()));
    }

    public static Float2 min(Int2 a, Float2 b) {
        return new Float2(Math.min((float)a.getX(), b.getX()), Math.min((float)a.getY(), b.getY()));
    }

    public static Float2 min(Float2 a, Int2 b) {
        return new Float2(Math.min(a.getX(), (float)b.getX()), Math.min(a.getY(), (float)b.getY()));
    }

    public static Float2 max(Float2 a, Float2 b) {
        return new Float2(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()));
    }

    public static Float2 max(Int2 a, Float2 b) {
        return new Float2(Math.max((float)a.getX(), b.getX()), Math.max((float)a.getY(), b.getY()));
    }

    public static Float2 max(Float2 a, Int2 b) {
        return new Float2(Math.max(a.getX(), (float)b.getX()), Math.max(a.getY(), (float)b.getY()));
    }

    public static Float2 add(Float2 a, float b) {
        return new Float2(a.getX() + b, a.getY() + b);
    }

    public static Float2 sub(Float2 a, float b) {
        return new Float2(a.getX() - b, a.getY() - b);
    }

    public static Float2 mult(Float2 a, float b) {
        return new Float2(a.getX() * b, a.getY() * b);
    }

    public static Float2 div(Float2 a, float b) {
        return new Float2(a.getX() / b, a.getY() / b);
    }

    public static void add(Float2 a, Float2 b, Float2 c) {
        c.setX(a.getX() + b.getX());
        c.setY(a.getY() + b.getY());
    }

    public static void sub(Float2 a, Float2 b, Float2 c) {
        c.setX(a.getX() - b.getX());
        c.setY(a.getY() - b.getY());
    }

    public static void mult(Float2 a, Float2 b, Float2 c) {
        c.setX(a.getX() * b.getX());
        c.setY(a.getY() * b.getY());
    }

    public static void div(Float2 a, Float2 b, Float2 c) {
        c.setX(a.getX() / b.getX());
        c.setY(a.getY() / b.getY());
    }

    public static void min(Float2 a, Float2 b, Float2 c) {
        c.setX(Math.min(a.getX(), b.getX()));
        c.setY(Math.min(a.getY(), b.getY()));
    }

    public static void max(Float2 a, Float2 b, Float2 c) {
        c.setX(Math.max(a.getX(), b.getX()));
        c.setY(Math.max(a.getY(), b.getY()));
    }

    public static Float2 inc(Float2 a, float value) {
        return Float2.add(a, value);
    }

    public static Float2 dec(Float2 a, float value) {
        return Float2.sub(a, value);
    }

    public static Float2 scaleByInverse(Float2 a, float value) {
        return Float2.mult(a, 1.0f / value);
    }

    public static Float2 scale(Float2 a, float value) {
        return Float2.mult(a, value);
    }

    public static Float2 sqrt(Float2 a) {
        return new Float2(TornadoMath.sqrt(a.getX()), TornadoMath.sqrt(a.getY()));
    }

    public static Float2 floor(Float2 a) {
        return new Float2(TornadoMath.floor(a.getX()), TornadoMath.floor(a.getY()));
    }

    public static Float2 fract(Float2 a) {
        return new Float2(TornadoMath.fract(a.getX()), TornadoMath.fract(a.getY()));
    }

    public static void clamp(Float2 x, float min, float max) {
        x.setX(TornadoMath.clamp(x.getX(), min, max));
        x.setY(TornadoMath.clamp(x.getY(), min, max));
    }

    public static Float2 normalise(Float2 value) {
        return Float2.scaleByInverse(value, Float2.length(value));
    }

    public static float min(Float2 value) {
        return Math.min(value.getX(), value.getY());
    }

    public static float max(Float2 value) {
        return Math.max(value.getX(), value.getY());
    }

    public static float dot(Float2 a, Float2 b) {
        Float2 m = Float2.mult(a, b);
        return m.getX() + m.getY();
    }

    public static float length(Float2 value) {
        return TornadoMath.sqrt(Float2.dot(value, value));
    }

    public static boolean isEqual(Float2 a, Float2 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public float get(int index) {
        return this.storage[index];
    }

    public void set(int index, float value) {
        this.storage[index] = value;
    }

    public void set(Float2 value) {
        this.setX(value.getX());
        this.setY(value.getY());
    }

    public float getX() {
        return this.get(0);
    }

    public void setX(float value) {
        this.set(0, value);
    }

    public float getY() {
        return this.get(1);
    }

    public void setY(float value) {
        this.set(1, value);
    }

    public Float2 duplicate() {
        Float2 vector = new Float2();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, Float.valueOf(this.getX()), Float.valueOf(this.getY()));
    }

    public String toString() {
        return this.toString("{%.3f,%.3f}");
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 2;
    }

    public float[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 8L;
    }
}

