/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.types.vectors.Int16;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Float16
implements TornadoVectorsInterface<FloatBuffer> {
    public static final Class<Float16> TYPE = Float16.class;
    private static final int NUM_ELEMENTS = 16;
    @Payload
    final float[] storage;

    private Float16(float[] storage) {
        this.storage = storage;
    }

    public Float16() {
        this(new float[16]);
    }

    public Float16(float s0, float s1, float s2, float s3, float s4, float s5, float s6, float s7, float s8, float s9, float s10, float s11, float s12, float s13, float s14, float s15) {
        this();
        this.setS0(s0);
        this.setS1(s1);
        this.setS2(s2);
        this.setS3(s3);
        this.setS4(s4);
        this.setS5(s5);
        this.setS6(s6);
        this.setS7(s7);
        this.setS8(s8);
        this.setS9(s9);
        this.setS10(s10);
        this.setS11(s11);
        this.setS12(s12);
        this.setS13(s13);
        this.setS14(s14);
        this.setS15(s15);
    }

    public static Float16 add(Float16 a, Float16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) + b.get(i));
        }
        return result;
    }

    public static Float16 add(Int16 a, Float16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, (float)a.get(i) + b.get(i));
        }
        return result;
    }

    public static Float16 add(Float16 a, Int16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) + (float)b.get(i));
        }
        return result;
    }

    public static Float16 add(Float16 a, float b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) + b);
        }
        return result;
    }

    public static Float16 sub(Float16 a, Float16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) - b.get(i));
        }
        return result;
    }

    public static Float16 sub(Int16 a, Float16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, (float)a.get(i) - b.get(i));
        }
        return result;
    }

    public static Float16 sub(Float16 a, Int16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) - (float)b.get(i));
        }
        return result;
    }

    public static Float16 sub(Float16 a, float b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) - b);
        }
        return result;
    }

    public static Float16 div(Float16 a, Float16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) / b.get(i));
        }
        return result;
    }

    public static Float16 div(Int16 a, Float16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, (float)a.get(i) / b.get(i));
        }
        return result;
    }

    public static Float16 div(Float16 a, Int16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) / (float)b.get(i));
        }
        return result;
    }

    public static Float16 div(Float16 a, float value) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) / value);
        }
        return result;
    }

    public static Float16 mult(Float16 a, Float16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) * b.get(i));
        }
        return result;
    }

    public static Float16 mult(Int16 a, Float16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, (float)a.get(i) * b.get(i));
        }
        return result;
    }

    public static Float16 mult(Float16 a, Int16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) * (float)b.get(i));
        }
        return result;
    }

    public static Float16 mult(Float16 a, float value) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, a.get(i) * value);
        }
        return result;
    }

    public static Float16 min(Float16 a, Float16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, Math.min(a.get(i), b.get(i)));
        }
        return result;
    }

    public static Float16 min(Int16 a, Float16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, Math.min((float)a.get(i), b.get(i)));
        }
        return result;
    }

    public static Float16 min(Float16 a, Int16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, Math.min(a.get(i), (float)b.get(i)));
        }
        return result;
    }

    public static float min(Float16 value) {
        float result = Float.MAX_VALUE;
        for (int i = 0; i < 16; ++i) {
            result = Math.min(result, value.get(i));
        }
        return result;
    }

    public static Float16 max(Float16 a, Float16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, Math.max(a.get(i), b.get(i)));
        }
        return result;
    }

    public static Float16 max(Int16 a, Float16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, Math.max((float)a.get(i), b.get(i)));
        }
        return result;
    }

    public static Float16 max(Float16 a, Int16 b) {
        Float16 result = new Float16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, Math.max(a.get(i), (float)b.get(i)));
        }
        return result;
    }

    public static float max(Float16 value) {
        float result = Float.MIN_VALUE;
        for (int i = 0; i < 16; ++i) {
            result = Math.max(result, value.get(i));
        }
        return result;
    }

    public static float dot(Float16 a, Float16 b) {
        Float16 m = Float16.mult(a, b);
        return m.getS0() + m.getS1() + m.getS2() + m.getS3() + m.getS4() + m.getS5() + m.getS6() + m.getS7() + m.getS8() + m.getS9() + m.getS10() + m.getS11() + m.getS12() + m.getS13() + m.getS14() + m.getS15();
    }

    public float getS0() {
        return this.get(0);
    }

    public void setS0(float value) {
        this.set(0, value);
    }

    public float getS1() {
        return this.get(1);
    }

    public void setS1(float value) {
        this.set(1, value);
    }

    public float getS2() {
        return this.get(2);
    }

    public void setS2(float value) {
        this.set(2, value);
    }

    public float getS3() {
        return this.get(3);
    }

    public void setS3(float value) {
        this.set(3, value);
    }

    public float getS4() {
        return this.get(4);
    }

    public void setS4(float value) {
        this.set(4, value);
    }

    public float getS5() {
        return this.get(5);
    }

    public void setS5(float value) {
        this.set(5, value);
    }

    public float getS6() {
        return this.get(6);
    }

    public void setS6(float value) {
        this.set(6, value);
    }

    public float getS7() {
        return this.get(7);
    }

    public void setS7(float value) {
        this.set(7, value);
    }

    public float getS8() {
        return this.get(8);
    }

    public void setS8(float value) {
        this.set(8, value);
    }

    public float getS9() {
        return this.get(9);
    }

    public void setS9(float value) {
        this.set(9, value);
    }

    public float getS10() {
        return this.get(10);
    }

    public void setS10(float value) {
        this.set(10, value);
    }

    public float getS11() {
        return this.get(11);
    }

    public void setS11(float value) {
        this.set(11, value);
    }

    public float getS12() {
        return this.get(12);
    }

    public void setS12(float value) {
        this.set(12, value);
    }

    public float getS13() {
        return this.get(13);
    }

    private void setS13(float value) {
        this.set(13, value);
    }

    public float getS14() {
        return this.get(14);
    }

    public void setS14(float value) {
        this.set(14, value);
    }

    public float getS15() {
        return this.get(15);
    }

    public void setS15(float value) {
        this.set(15, value);
    }

    public float get(int index) {
        return this.storage[index];
    }

    public void set(int index, float value) {
        this.storage[index] = value;
    }

    public void set(Float16 value) {
        for (int i = 0; i < 16; ++i) {
            this.set(i, value.get(i));
        }
    }

    public String toString(String fmt) {
        return String.format(fmt, Float.valueOf(this.getS0()), Float.valueOf(this.getS1()), Float.valueOf(this.getS2()), Float.valueOf(this.getS3()), Float.valueOf(this.getS4()), Float.valueOf(this.getS5()), Float.valueOf(this.getS6()), Float.valueOf(this.getS7()), Float.valueOf(this.getS8()), Float.valueOf(this.getS9()), Float.valueOf(this.getS10()), Float.valueOf(this.getS11()), Float.valueOf(this.getS12()), Float.valueOf(this.getS13()), Float.valueOf(this.getS13()), Float.valueOf(this.getS14()), Float.valueOf(this.getS15()));
    }

    public String toString() {
        return this.toString("{%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f}");
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 16;
    }

    public float[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 64L;
    }
}

