/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.DoubleBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.Double2;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Double3
implements TornadoVectorsInterface<DoubleBuffer> {
    public static final Class<Double3> TYPE = Double3.class;
    private static final int NUM_ELEMENTS = 3;
    @Payload
    final double[] storage;

    private Double3(double[] storage) {
        this.storage = storage;
    }

    public Double3() {
        this(new double[3]);
    }

    public Double3(double x, double y, double z) {
        this();
        this.setX(x);
        this.setY(y);
        this.setZ(z);
    }

    public static Double3 add(Double3 a, Double3 b) {
        return new Double3(a.getX() + b.getX(), a.getY() + b.getY(), a.getZ() + b.getZ());
    }

    public static Double3 sub(Double3 a, Double3 b) {
        return new Double3(a.getX() - b.getX(), a.getY() - b.getY(), a.getZ() - b.getZ());
    }

    public static Double3 div(Double3 a, Double3 b) {
        return new Double3(a.getX() / b.getX(), a.getY() / b.getY(), a.getZ() / b.getZ());
    }

    public static Double3 mult(Double3 a, Double3 b) {
        return new Double3(a.getX() * b.getX(), a.getY() * b.getY(), a.getZ() * b.getZ());
    }

    public static Double3 min(Double3 a, Double3 b) {
        return new Double3(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()), Math.min(a.getZ(), b.getZ()));
    }

    public static Double3 max(Double3 a, Double3 b) {
        return new Double3(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()), Math.max(a.getZ(), b.getZ()));
    }

    public static Double3 cross(Double3 a, Double3 b) {
        return new Double3(a.getY() * b.getZ() - a.getZ() * b.getY(), a.getZ() * b.getX() - a.getX() * b.getZ(), a.getX() * b.getY() - a.getY() * b.getX());
    }

    public static Double3 add(Double3 a, double b) {
        return new Double3(a.getX() + b, a.getY() + b, a.getZ() + b);
    }

    public static Double3 sub(Double3 a, double b) {
        return new Double3(a.getX() - b, a.getY() - b, a.getZ() - b);
    }

    public static Double3 mult(Double3 a, double b) {
        return new Double3(a.getX() * b, a.getY() * b, a.getZ() * b);
    }

    public static Double3 div(Double3 a, double b) {
        return new Double3(a.getX() / b, a.getY() / b, a.getZ() / b);
    }

    public static Double3 inc(Double3 a, double value) {
        return new Double3(a.getX() + value, a.getY() + value, a.getZ() + value);
    }

    public static Double3 dec(Double3 a, double value) {
        return new Double3(a.getX() - value, a.getY() - value, a.getZ() - value);
    }

    public static Double3 scaleByInverse(Double3 a, double value) {
        return Double3.mult(a, 1.0 / value);
    }

    public static Double3 scale(Double3 a, double value) {
        return Double3.mult(a, value);
    }

    public static Double3 sqrt(Double3 a) {
        return new Double3(TornadoMath.sqrt(a.getX()), TornadoMath.sqrt(a.getY()), TornadoMath.sqrt(a.getZ()));
    }

    public static Double3 floor(Double3 a) {
        return new Double3(TornadoMath.floor(a.getX()), TornadoMath.floor(a.getY()), TornadoMath.floor(a.getZ()));
    }

    public static Double3 fract(Double3 a) {
        return new Double3(TornadoMath.fract(a.getX()), TornadoMath.fract(a.getY()), TornadoMath.fract(a.getZ()));
    }

    public static Double3 clamp(Double3 x, double min, double max) {
        return new Double3(TornadoMath.clamp(x.getX(), min, max), TornadoMath.clamp(x.getY(), min, max), TornadoMath.clamp(x.getZ(), min, max));
    }

    public static Double3 normalise(Double3 value) {
        double len = 1.0 / Double3.length(value);
        return Double3.mult(value, len);
    }

    public static double min(Double3 value) {
        return Math.min(value.getX(), Math.min(value.getY(), value.getZ()));
    }

    public static double max(Double3 value) {
        return Math.max(value.getX(), Math.max(value.getY(), value.getZ()));
    }

    public static double dot(Double3 a, Double3 b) {
        Double3 m = Double3.mult(a, b);
        return m.getX() + m.getY() + m.getZ();
    }

    public static double length(Double3 value) {
        return TornadoMath.sqrt(Double3.dot(value, value));
    }

    public static boolean isEqual(Double3 a, Double3 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public static boolean isEqualULP(Double3 a, Double3 b, double numULP) {
        return TornadoMath.isEqualULP(a.asBuffer().array(), b.asBuffer().array(), numULP);
    }

    public static double findULPDistance(Double3 a, Double3 b) {
        return TornadoMath.findULPDistance(a.asBuffer().array(), b.asBuffer().array());
    }

    public double[] getArray() {
        return this.storage;
    }

    public double get(int index) {
        return this.storage[index];
    }

    public void set(int index, double value) {
        this.storage[index] = value;
    }

    public void set(Double3 value) {
        this.setX(value.getX());
        this.setY(value.getY());
        this.setZ(value.getZ());
    }

    public double getX() {
        return this.get(0);
    }

    public void setX(double value) {
        this.set(0, value);
    }

    public double getY() {
        return this.get(1);
    }

    public void setY(double value) {
        this.set(1, value);
    }

    public double getZ() {
        return this.get(2);
    }

    public void setZ(double value) {
        this.set(2, value);
    }

    public void setS0(double value) {
        this.set(0, value);
    }

    public void setS1(double value) {
        this.set(1, value);
    }

    public void setS2(double value) {
        this.set(2, value);
    }

    public Double3 duplicate() {
        Double3 vector = new Double3();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, this.getX(), this.getY(), this.getZ());
    }

    public String toString() {
        return this.toString("{%.3f,%.3f,%.3f}");
    }

    public Double2 asDouble2() {
        return new Double2(this.getX(), this.getY());
    }

    @Override
    public void loadFromBuffer(DoubleBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public DoubleBuffer asBuffer() {
        return DoubleBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 3;
    }

    public double[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 24L;
    }
}

