/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.vectors;

import java.nio.ByteBuffer;
import uk.ac.manchester.tornado.api.internal.annotations.Payload;
import uk.ac.manchester.tornado.api.internal.annotations.Vector;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.vectors.TornadoVectorsInterface;

@Vector
public final class Byte4
implements TornadoVectorsInterface<ByteBuffer> {
    public static final Class<Byte4> TYPE = Byte4.class;
    private static final String NUMBER_FORMAT = "{ x=%-7d, y=%-7d, z=%-7d, w=%-7d }";
    private static final int NUM_ELEMENTS = 4;
    @Payload
    final byte[] storage;

    private Byte4(byte[] nativeVectorByte) {
        this.storage = nativeVectorByte;
    }

    public Byte4() {
        this(new byte[4]);
    }

    public Byte4(byte x, byte y, byte z, byte w) {
        this();
        this.setX(x);
        this.setY(y);
        this.setZ(z);
        this.setW(w);
    }

    public static Byte4 add(Byte4 a, Byte4 b) {
        return new Byte4((byte)(a.getX() + b.getX()), (byte)(a.getY() + b.getY()), (byte)(a.getZ() + b.getZ()), (byte)(a.getW() + b.getW()));
    }

    public static Byte4 sub(Byte4 a, Byte4 b) {
        return new Byte4((byte)(a.getX() - b.getX()), (byte)(a.getY() - b.getY()), (byte)(a.getZ() - b.getZ()), (byte)(a.getW() - b.getW()));
    }

    public static Byte4 div(Byte4 a, Byte4 b) {
        return new Byte4((byte)(a.getX() / b.getX()), (byte)(a.getY() / b.getY()), (byte)(a.getZ() / b.getZ()), (byte)(a.getW() / b.getW()));
    }

    public static Byte4 mult(Byte4 a, Byte4 b) {
        return new Byte4((byte)(a.getX() * b.getX()), (byte)(a.getY() * b.getY()), (byte)(a.getZ() * b.getZ()), (byte)(a.getW() * b.getW()));
    }

    public static Byte4 min(Byte4 a, Byte4 b) {
        return new Byte4(TornadoMath.min(a.getX(), b.getX()), TornadoMath.min(a.getY(), b.getY()), TornadoMath.min(a.getZ(), b.getZ()), TornadoMath.min(a.getW(), b.getW()));
    }

    public static Byte4 max(Byte4 a, Byte4 b) {
        return new Byte4(TornadoMath.max(a.getX(), b.getX()), TornadoMath.max(a.getY(), b.getY()), TornadoMath.max(a.getZ(), b.getZ()), TornadoMath.max(a.getW(), b.getW()));
    }

    public static Byte4 add(Byte4 a, byte b) {
        return new Byte4((byte)(a.getX() + b), (byte)(a.getY() + b), (byte)(a.getZ() + b), (byte)(a.getW() + b));
    }

    public static Byte4 sub(Byte4 a, byte b) {
        return new Byte4((byte)(a.getX() - b), (byte)(a.getY() - b), (byte)(a.getZ() - b), (byte)(a.getW() - b));
    }

    public static Byte4 mult(Byte4 a, byte b) {
        return new Byte4((byte)(a.getX() * b), (byte)(a.getY() * b), (byte)(a.getZ() * b), (byte)(a.getW() * b));
    }

    public static Byte4 div(Byte4 a, byte b) {
        return new Byte4((byte)(a.getX() / b), (byte)(a.getY() / b), (byte)(a.getZ() / b), (byte)(a.getW() / b));
    }

    public static Byte4 inc(Byte4 a, byte value) {
        return Byte4.add(a, value);
    }

    public static Byte4 dec(Byte4 a, byte value) {
        return Byte4.sub(a, value);
    }

    public static Byte4 scale(Byte4 a, byte value) {
        return Byte4.mult(a, value);
    }

    public static Byte4 clamp(Byte4 x, byte min, byte max) {
        return new Byte4(TornadoMath.clamp(x.getX(), min, max), TornadoMath.clamp(x.getY(), min, max), TornadoMath.clamp(x.getZ(), min, max), TornadoMath.clamp(x.getW(), min, max));
    }

    public static byte min(Byte4 value) {
        return TornadoMath.min(TornadoMath.min(value.getX(), value.getY()), TornadoMath.min(value.getZ(), value.getW()));
    }

    public static byte max(Byte4 value) {
        return TornadoMath.max(TornadoMath.max(value.getX(), value.getY()), TornadoMath.max(value.getZ(), value.getW()));
    }

    public static boolean isEqual(Byte4 a, Byte4 b) {
        return TornadoMath.isEqual(a.toArray(), b.toArray());
    }

    public void set(Byte4 value) {
        this.setX(value.getX());
        this.setY(value.getY());
        this.setZ(value.getZ());
        this.setW(value.getW());
    }

    public byte get(int index) {
        return this.storage[index];
    }

    public void set(int index, byte value) {
        this.storage[index] = value;
    }

    public byte getX() {
        return this.get(0);
    }

    public void setX(byte value) {
        this.set(0, value);
    }

    public byte getY() {
        return this.get(1);
    }

    public void setY(byte value) {
        this.set(1, value);
    }

    public byte getZ() {
        return this.get(2);
    }

    public void setZ(byte value) {
        this.set(2, value);
    }

    public byte getW() {
        return this.get(3);
    }

    public void setW(byte value) {
        this.set(3, value);
    }

    public Byte4 duplicate() {
        Byte4 vector = new Byte4();
        vector.set(this);
        return vector;
    }

    public String toString(String fmt) {
        return String.format(fmt, this.getX(), this.getY(), this.getZ(), this.getW());
    }

    public String toString() {
        return this.toString(NUMBER_FORMAT);
    }

    @Override
    public void loadFromBuffer(ByteBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ByteBuffer asBuffer() {
        return ByteBuffer.wrap(this.storage);
    }

    @Override
    public int size() {
        return 4;
    }

    public byte[] toArray() {
        return this.storage;
    }

    @Override
    public long getNumBytes() {
        return 16L;
    }
}

