/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.utils;

import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.vectors.Float2;
import uk.ac.manchester.tornado.api.types.vectors.Float3;
import uk.ac.manchester.tornado.api.types.vectors.Float4;
import uk.ac.manchester.tornado.api.types.vectors.Float8;

public class FloatOps {
    public static final float EPSILON = 1.0E-7f;
    public static final String FMT = "%.3f";
    public static final String FMT_2 = "{%.3f,%.3f}";
    public static final String FMT_3 = "{%.3f,%.3f,%.3f}";
    public static final String FMT_3_E = "{%.4e,%.4e,%.4e}";
    public static final String FMT_4 = "{%.3f,%.3f,%.3f,%.3f}";
    public static final String FMT_4_M = "%.3f,%.3f,%.3f,%.3f";
    public static final String FMT_4_EM = "%.3e,%.3e,%.3e,%.3e";
    public static final String FMT_6 = "{%.3f,%.3f,%.3f,%.3f,%.3f,%.3f}";
    public static final String FMT_8 = "{%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f}";
    public static final String FMT_16 = "{%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f}";
    public static final String FMT_6_E = "{%e,%e,%e,%e,%e,%e}";

    public static boolean compareBits(float a, float b) {
        long bi;
        long ai = Float.floatToRawIntBits(a);
        long diff = ai ^ (bi = (long)Float.floatToRawIntBits(b));
        return diff == 0L;
    }

    public static boolean compareULP(float value, float expected, float ulps) {
        float tol = ulps * Math.ulp(expected);
        if (value == expected) {
            return true;
        }
        return Math.abs(value - expected) < tol;
    }

    public static float findMaxULP(Float2 value, Float2 expected) {
        return TornadoMath.findULPDistance(value.toArray(), expected.toArray());
    }

    public static float findMaxULP(Float3 value, Float3 expected) {
        return TornadoMath.findULPDistance(value.toArray(), expected.toArray());
    }

    public static float findMaxULP(Float4 value, Float4 expected) {
        return TornadoMath.findULPDistance(value.toArray(), expected.toArray());
    }

    public static float findMaxULP(FloatArray value, FloatArray expected) {
        return TornadoMath.findULPDistance(value, expected);
    }

    public static float findMaxULP(Float8 value, Float8 expected) {
        return TornadoMath.findULPDistance(value.toArray(), expected.toArray());
    }

    public static float findMaxULP(float value, float expected) {
        float ulp = Math.ulp(expected);
        if (value == expected) {
            return 0.0f;
        }
        float absValue = Math.abs(value - expected);
        return absValue / ulp;
    }

    public static boolean compare(float a, float b) {
        return Math.abs(a - b) <= 1.0E-7f;
    }

    public static boolean compare(float a, float b, float tol) {
        return Math.abs(a - b) <= tol;
    }

    public static float sq(float value) {
        return value * value;
    }

    public static void atomicAdd(float[] array, int index, float value) {
        int n = index;
        array[n] = array[n] + value;
    }
}

