/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.tensors;

import java.util.Arrays;

public record Shape(long[] dimensions) {
    public int getRank() {
        return this.dimensions.length;
    }

    public long[] getDimensions() {
        return this.dimensions;
    }

    public int getSize() {
        return (int)Arrays.stream(this.dimensions).reduce(1L, (a, b) -> a * b);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shape shape = (Shape)o;
        return Arrays.equals(this.dimensions, shape.dimensions);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.dimensions);
    }

    @Override
    public String toString() {
        return "Shape{dimensions=" + Arrays.toString(this.dimensions) + "}";
    }

    public String toTensorFlowShapeString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < this.dimensions.length; ++i) {
            sb.append(this.dimensions[i]);
            if (i >= this.dimensions.length - 1) continue;
            sb.append(",");
        }
        sb.append("]");
        return sb.toString();
    }

    public String toONNXShapeString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (int i = 0; i < this.dimensions.length; ++i) {
            sb.append("dim_").append(i).append(": ").append(this.dimensions[i]);
            if (i >= this.dimensions.length - 1) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }
}

