/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.matrix;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.matrix.Matrix3DType;
import uk.ac.manchester.tornado.api.types.matrix.TornadoMatrixInterface;
import uk.ac.manchester.tornado.api.types.utils.StorageFormats;

public final class Matrix3DFloat
extends Matrix3DType
implements TornadoMatrixInterface<FloatBuffer> {
    private final FloatArray storage;
    private final int numElements;

    public Matrix3DFloat(int rows, int columns, int depth, FloatArray array) {
        super(rows, columns, depth);
        this.storage = array;
        this.numElements = rows * columns * depth;
    }

    public Matrix3DFloat(int rows, int columns, int depth) {
        this(rows, columns, depth, new FloatArray(rows * columns * depth));
    }

    public Matrix3DFloat(float[][][] matrix) {
        this(matrix.length, matrix[0].length, matrix[0][0].length, StorageFormats.toRowMajor3D(matrix));
    }

    public static void scale(Matrix3DFloat matrix, float value) {
        for (int i = 0; i < matrix.storage.getSize(); ++i) {
            matrix.storage.set(i, matrix.storage.get(i) * value);
        }
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    public float get(int i, int j, int k) {
        return this.storage.get(StorageFormats.toRowMajor3D(i, j, k, this.DEPTH, this.COLUMNS));
    }

    public void set(int i, int j, int k, float value) {
        this.storage.set(StorageFormats.toRowMajor3D(i, j, k, this.DEPTH, this.COLUMNS), value);
    }

    public void fill(float value) {
        this.storage.init(value);
    }

    public Matrix3DFloat duplicate() {
        Matrix3DFloat matrix = new Matrix3DFloat(this.ROWS, this.COLUMNS, this.DEPTH);
        matrix.set(this);
        return matrix;
    }

    public void set(Matrix3DFloat m) {
        for (int i = 0; i < m.storage.getSize(); ++i) {
            this.storage.set(i, m.storage.get(i));
        }
    }

    public String toString(String fmt) {
        StringBuilder str = new StringBuilder("");
        for (int i = 0; i < this.ROWS; ++i) {
            for (int j = 0; j < this.COLUMNS; ++j) {
                for (int k = 0; k < this.DEPTH; ++k) {
                    str.append(String.format(fmt, Float.valueOf(this.get(i, j, k))) + " ");
                }
            }
            str.append("\n");
        }
        return str.toString().trim();
    }

    public String toString() {
        Object result = String.format("Matrix3DFloat <%d x %d x %d>", this.ROWS, this.COLUMNS, this.DEPTH);
        if (this.ROWS < 16 && this.COLUMNS < 16 && this.DEPTH < 16) {
            result = (String)result + "\n" + this.toString("%.3f");
        }
        return result;
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public MemorySegment getSegment() {
        return this.storage.getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.storage.getSegmentWithHeader();
    }
}

