/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.matrix;

import java.lang.foreign.MemorySegment;
import java.nio.IntBuffer;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.collections.VectorInt;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DType;
import uk.ac.manchester.tornado.api.types.matrix.TornadoMatrixInterface;
import uk.ac.manchester.tornado.api.types.utils.StorageFormats;

public final class Matrix2DInt
extends Matrix2DType
implements TornadoMatrixInterface<IntBuffer> {
    private final IntArray storage;
    private final int numElements;

    public Matrix2DInt(int rows, int columns, IntArray array) {
        super(rows, columns);
        this.storage = array;
        this.numElements = columns * rows;
    }

    public Matrix2DInt(int rows, int columns) {
        this(rows, columns, new IntArray(rows * columns));
    }

    public Matrix2DInt(int[][] matrix) {
        this(matrix.length, matrix[0].length, StorageFormats.toRowMajor(matrix));
    }

    public static void transpose(Matrix2DInt matrix) {
        if (matrix.COLUMNS == matrix.ROWS) {
            for (int i = 0; i < matrix.ROWS; ++i) {
                for (int j = 0; j < i; ++j) {
                    int tmp = matrix.get(i, j);
                    matrix.set(i, j, matrix.get(j, i));
                    matrix.set(j, i, tmp);
                }
            }
        }
    }

    public static void scale(Matrix2DInt matrix, int value) {
        for (int i = 0; i < matrix.storage.getSize(); ++i) {
            matrix.storage.set(i, matrix.storage.get(i) * value);
        }
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    public int get(int i, int j) {
        return this.storage.get(StorageFormats.toRowMajor(i, j, this.COLUMNS));
    }

    public void set(int i, int j, int value) {
        this.storage.set(StorageFormats.toRowMajor(i, j, this.COLUMNS), value);
    }

    public VectorInt row(int row) {
        int baseIndex = StorageFormats.toRowMajor(row, 0, this.COLUMNS);
        int to = this.getFinalIndexOfRange(baseIndex);
        int size = to - baseIndex;
        IntArray f = new IntArray(size);
        int j = 0;
        for (int i = baseIndex; i < to; ++i) {
            f.set(j, this.storage.get(i));
            ++j;
        }
        return new VectorInt(this.COLUMNS, f);
    }

    public VectorInt column(int col) {
        int index = StorageFormats.toRowMajor(0, col, this.COLUMNS);
        VectorInt v = new VectorInt(this.ROWS);
        for (int i = 0; i < this.ROWS; ++i) {
            v.set(i, this.storage.get(index + i * this.COLUMNS));
        }
        return v;
    }

    public VectorInt diag() {
        VectorInt v = new VectorInt(Math.min(this.ROWS, this.COLUMNS));
        for (int i = 0; i < this.ROWS; ++i) {
        }
        return v;
    }

    public void fill(int value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public void multiply(Matrix2DInt a, Matrix2DInt b) {
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumColumns(); ++col) {
                int sum = 0;
                for (int k = 0; k < b.getNumRows(); ++k) {
                    sum += a.get(row, k) * b.get(k, col);
                }
                this.set(row, col, sum);
            }
        }
    }

    public Matrix2DInt duplicate() {
        Matrix2DInt matrix = new Matrix2DInt(this.ROWS, this.COLUMNS);
        matrix.set(this);
        return matrix;
    }

    public void set(Matrix2DInt m) {
        for (int i = 0; i < m.storage.getSize(); ++i) {
            this.storage.set(i, m.storage.get(i));
        }
    }

    public String toString(String fmt) {
        Object str = "";
        for (int i = 0; i < this.ROWS; ++i) {
            for (int j = 0; j < this.COLUMNS; ++j) {
                str = (String)str + String.format(fmt, this.get(i, j)) + " ";
            }
            str = (String)str + "\n";
        }
        return ((String)str).trim();
    }

    public String toString() {
        Object result = String.format("MatrixInt <%d x %d>", this.ROWS, this.COLUMNS);
        if (this.ROWS < 16 && this.COLUMNS < 16) {
            result = (String)result + "\n" + this.toString("%d");
        }
        return result;
    }

    @Override
    public void loadFromBuffer(IntBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public IntBuffer asBuffer() {
        return IntBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public MemorySegment getSegment() {
        return this.storage.getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.storage.getSegmentWithHeader();
    }
}

