/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.matrix;

import java.lang.foreign.MemorySegment;
import java.nio.DoubleBuffer;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.collections.VectorDouble;
import uk.ac.manchester.tornado.api.types.matrix.Matrix2DType;
import uk.ac.manchester.tornado.api.types.matrix.TornadoMatrixInterface;
import uk.ac.manchester.tornado.api.types.utils.StorageFormats;

public final class Matrix2DDouble
extends Matrix2DType
implements TornadoMatrixInterface<DoubleBuffer> {
    private final DoubleArray storage;
    private final int numElements;

    public Matrix2DDouble(int rows, int columns, DoubleArray array) {
        super(rows, columns);
        this.storage = array;
        this.numElements = columns * rows;
    }

    public Matrix2DDouble(int rows, int columns) {
        this(rows, columns, new DoubleArray(rows * columns));
    }

    public Matrix2DDouble(double[][] matrix) {
        this(matrix.length, matrix[0].length, StorageFormats.toRowMajor(matrix));
    }

    public static void transpose(Matrix2DDouble matrix) {
        if (matrix.COLUMNS == matrix.ROWS) {
            for (int i = 0; i < matrix.ROWS; ++i) {
                for (int j = 0; j < i; ++j) {
                    double tmp = matrix.get(i, j);
                    matrix.set(i, j, matrix.get(j, i));
                    matrix.set(j, i, tmp);
                }
            }
        }
    }

    @Override
    public void clear() {
        this.storage.clear();
    }

    public double get(int i, int j) {
        return this.storage.get(StorageFormats.toRowMajor(i, j, this.COLUMNS));
    }

    public void set(int i, int j, double value) {
        this.storage.set(StorageFormats.toRowMajor(i, j, this.COLUMNS), value);
    }

    public VectorDouble row(int row) {
        int baseIndex = StorageFormats.toRowMajor(row, 0, this.COLUMNS);
        int to = this.getFinalIndexOfRange(baseIndex);
        int size = to - baseIndex;
        DoubleArray f = new DoubleArray(size);
        int j = 0;
        int i = baseIndex;
        while (i < to) {
            f.set(j, this.storage.get(i));
            ++i;
            ++j;
        }
        return new VectorDouble(this.COLUMNS, f);
    }

    public VectorDouble column(int col) {
        int baseIndex = StorageFormats.toRowMajor(0, col, this.COLUMNS);
        VectorDouble v = new VectorDouble(this.ROWS);
        for (int i = 0; i < this.ROWS; ++i) {
            v.set(i, this.storage.get(baseIndex + i * this.COLUMNS));
        }
        return v;
    }

    public VectorDouble diag() {
        VectorDouble v = new VectorDouble(Math.min(this.ROWS, this.COLUMNS));
        for (int i = 0; i < this.ROWS; ++i) {
            v.set(i, this.storage.get(i * (this.COLUMNS + 1)));
        }
        return v;
    }

    public void fill(double value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public void multiply(Matrix2DDouble a, Matrix2DDouble b) {
        for (int row = 0; row < this.getNumRows(); ++row) {
            for (int col = 0; col < this.getNumColumns(); ++col) {
                double sum = 0.0;
                for (int k = 0; k < b.getNumRows(); ++k) {
                    sum += a.get(row, k) * b.get(k, col);
                }
                this.set(row, col, sum);
            }
        }
    }

    public Matrix2DDouble duplicate() {
        Matrix2DDouble matrix = new Matrix2DDouble(this.ROWS, this.COLUMNS);
        matrix.set(this);
        return matrix;
    }

    public void set(Matrix2DDouble m) {
        for (int i = 0; i < m.storage.getSize(); ++i) {
            this.storage.set(i, m.storage.get(i));
        }
    }

    public String toString(String fmt) {
        StringBuilder str = new StringBuilder("");
        for (int i = 0; i < this.ROWS; ++i) {
            for (int j = 0; j < this.COLUMNS; ++j) {
                str.append(String.format(fmt, this.get(i, j)) + " ");
            }
            str.append("\n");
        }
        return str.toString().trim();
    }

    public String toString() {
        Object result = String.format("MatrixDouble <%d x %d>", this.ROWS, this.COLUMNS);
        if (this.ROWS < 16 && this.COLUMNS < 16) {
            result = (String)result + "\n" + this.toString("%.3f");
        }
        return result;
    }

    @Override
    public void loadFromBuffer(DoubleBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public DoubleBuffer asBuffer() {
        return DoubleBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.storage.getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.storage.getSegmentWithHeader();
    }
}

