/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.images;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.images.TornadoImagesInterface;
import uk.ac.manchester.tornado.api.types.utils.FloatingPointError;
import uk.ac.manchester.tornado.api.types.vectors.Float8;

public final class ImageFloat8
implements TornadoImagesInterface<FloatBuffer> {
    public static final Class<ImageFloat8> TYPE = ImageFloat8.class;
    private static final int ELEMENT_SIZE = 8;
    private final FloatArray storage;
    private final int Y;
    private final int X;
    private final int numElements;

    public ImageFloat8(int width, int height, FloatArray array) {
        this.storage = array;
        this.X = width;
        this.Y = height;
        this.numElements = this.X * this.Y * 8;
    }

    public ImageFloat8(int width, int height) {
        this(width, height, new FloatArray(width * height * 8));
    }

    public FloatArray getArray() {
        return this.storage;
    }

    private int getIndex(int x, int y) {
        return x * 8 + y * 8 * this.X;
    }

    public int numElements() {
        return this.numElements;
    }

    public Float8 get(int x) {
        return this.get(x, 0);
    }

    private void storeToArray(Float8 value, FloatArray array, int index) {
        for (int i = 0; i < 8; ++i) {
            array.set(index + i, value.get(i));
        }
    }

    public void set(int x, Float8 value) {
        int offset = this.getIndex(x, 0);
        this.storeToArray(value, this.storage, offset);
    }

    public Float8 get(int x, int y) {
        int offset = this.getIndex(x, y);
        return this.loadFromArray(this.storage, offset);
    }

    private Float8 loadFromArray(FloatArray array, int index) {
        Float8 result = new Float8();
        result.setS0(array.get(index));
        result.setS1(array.get(index + 1));
        result.setS2(array.get(index + 2));
        result.setS3(array.get(index + 3));
        result.setS4(array.get(index + 4));
        result.setS5(array.get(index + 5));
        result.setS6(array.get(index + 6));
        result.setS7(array.get(index + 7));
        return result;
    }

    public void set(int x, int y, Float8 value) {
        int offset = this.getIndex(x, y);
        this.storeToArray(value, this.storage, offset);
    }

    public int X() {
        return this.X;
    }

    public int Y() {
        return this.Y;
    }

    public void fill(float value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public ImageFloat8 duplicate() {
        ImageFloat8 image = new ImageFloat8(this.X, this.Y);
        image.set(this);
        return image;
    }

    public void set(ImageFloat8 m) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, m.storage.get(i));
        }
    }

    public String toString(String fmt) {
        StringBuilder str = new StringBuilder("");
        for (int i = 0; i < this.Y; ++i) {
            for (int j = 0; j < this.X; ++j) {
                str.append(this.get(j, i).toString(fmt) + "\n");
            }
        }
        return str.toString();
    }

    public String toString() {
        Object result = String.format("ImageFloat8 <%d x %d>", this.X, this.Y);
        if (this.X <= 4 && this.Y <= 4) {
            result = (String)result + "\n" + this.toString("{%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f}");
        }
        return result;
    }

    public Float8 mean() {
        Float8 result = new Float8();
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                result = Float8.add(result, this.get(col, row));
            }
        }
        result = Float8.div(result, this.X * this.Y);
        return result;
    }

    public Float8 min() {
        Float8 result = new Float8(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                result = Float8.min(result, this.get(col, row));
            }
        }
        return result;
    }

    public Float8 max() {
        Float8 result = new Float8(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                result = Float8.max(result, this.get(col, row));
            }
        }
        return result;
    }

    public Float8 stdDev() {
        Float8 mean = this.mean();
        Float8 varience = new Float8();
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                Float8 v = Float8.sub(mean, this.get(col, row));
                v = Float8.mult(v, v);
                v = Float8.div(v, this.X);
                varience = Float8.add(v, varience);
            }
        }
        return Float8.sqrt(varience);
    }

    public String summarise() {
        return String.format("ImageFloat8<%dx%d>: min=%s, max=%s, mean=%s, sd=%s", this.X, this.Y, this.min(), this.max(), this.mean(), this.stdDev());
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    public FloatingPointError calculateULP(ImageFloat8 ref) {
        float maxULP = Float.MIN_VALUE;
        float minULP = Float.MAX_VALUE;
        float averageULP = 0.0f;
        if (ref.X != this.X && ref.Y != this.Y) {
            return new FloatingPointError(-1.0f, 0.0f, 0.0f, 0.0f);
        }
        for (int j = 0; j < this.Y; ++j) {
            for (int i = 0; i < this.X; ++i) {
                Float8 v = this.get(i, j);
                Float8 r = ref.get(i, j);
                float ulpFactor = Float8.findULPDistance(v, r);
                averageULP += ulpFactor;
                minULP = Math.min(ulpFactor, minULP);
                maxULP = Math.max(ulpFactor, maxULP);
            }
        }
        return new FloatingPointError(averageULP /= (float)this.X * (float)this.Y, minULP, maxULP, -1.0f);
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

