/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.images;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.images.TornadoImagesInterface;
import uk.ac.manchester.tornado.api.types.utils.StorageFormats;
import uk.ac.manchester.tornado.api.types.vectors.Float4;

public final class ImageFloat4
implements TornadoImagesInterface<FloatBuffer> {
    public static final Class<ImageFloat4> TYPE = ImageFloat4.class;
    private static final int ELEMENT_SIZE = 4;
    private final FloatArray storage;
    private final int Y;
    private final int X;
    private final int numElements;

    public ImageFloat4(int width, int height, FloatArray array) {
        this.storage = array;
        this.X = width;
        this.Y = height;
        this.numElements = this.X * this.Y * 4;
    }

    public ImageFloat4(int width, int height) {
        this(width, height, new FloatArray(width * height * 4));
    }

    public ImageFloat4(float[][] matrix) {
        this(matrix.length / 4, matrix[0].length / 4, StorageFormats.toRowMajor(matrix));
    }

    public FloatArray getArray() {
        return this.storage;
    }

    private int toIndex(int x, int y) {
        return 4 * (x + y * this.X);
    }

    public Float4 get(int x) {
        return this.get(x, 0);
    }

    public void set(int x, Float4 value) {
        this.set(x, 0, value);
    }

    public Float4 get(int x, int y) {
        int offset = this.toIndex(x, y);
        return this.loadFromArray(this.storage, offset);
    }

    private Float4 loadFromArray(FloatArray array, int index) {
        Float4 result = new Float4();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        result.setZ(array.get(index + 2));
        result.setW(array.get(index + 3));
        return result;
    }

    public void set(int x, int y, Float4 value) {
        int offset = this.toIndex(x, y);
        this.storeToArray(value, this.storage, offset);
    }

    private void storeToArray(Float4 value, FloatArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
        array.set(index + 2, value.getZ());
        array.set(index + 3, value.getW());
    }

    public int X() {
        return this.X;
    }

    public int Y() {
        return this.Y;
    }

    public void fill(float value) {
        this.storage.init(value);
    }

    public ImageFloat4 duplicate() {
        ImageFloat4 matrix = new ImageFloat4(this.X, this.Y);
        matrix.set(this);
        return matrix;
    }

    public void set(ImageFloat4 m) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, m.storage.get(i));
        }
    }

    public String toString(String fmt) {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.Y; ++i) {
            for (int j = 0; j < this.X; ++j) {
                str.append(this.get(j, i).toString(fmt)).append("\n");
            }
        }
        return str.toString();
    }

    public String toString() {
        Object result = String.format("ImageFloat4 <%d x %d>", this.X, this.Y);
        if (this.X <= 8 && this.Y <= 8) {
            result = (String)result + "\n" + this.toString("{%.3f,%.3f,%.3f,%.3f}");
        }
        return result;
    }

    public Float4 mean() {
        Float4 result = new Float4();
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                result = Float4.add(result, this.get(col, row));
            }
        }
        return Float4.div(result, this.X * this.Y);
    }

    public Float4 min() {
        Float4 result = new Float4(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                result = Float4.min(result, this.get(col, row));
            }
        }
        return result;
    }

    public Float4 max() {
        Float4 result = new Float4(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                result = Float4.max(result, this.get(col, row));
            }
        }
        return result;
    }

    public Float4 stdDev() {
        Float4 mean = this.mean();
        Float4 varience = new Float4();
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                Float4 v = Float4.sub(mean, this.get(col, row));
                v = Float4.mult(v, v);
                v = Float4.div(v, this.X);
                varience = Float4.add(v, varience);
            }
        }
        return Float4.sqrt(varience);
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

