/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.images;

import java.lang.foreign.MemorySegment;
import java.nio.ByteBuffer;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.images.TornadoImagesInterface;
import uk.ac.manchester.tornado.api.types.utils.StorageFormats;
import uk.ac.manchester.tornado.api.types.vectors.Byte4;
import uk.ac.manchester.tornado.api.types.vectors.Float4;

public final class ImageByte4
implements TornadoImagesInterface<ByteBuffer> {
    public static final Class<ImageByte4> TYPE = ImageByte4.class;
    private static final int elementSize = 4;
    private final ByteArray storage;
    private final int Y;
    private final int X;
    private final int numElements;

    public ImageByte4(int width, int height, ByteArray array) {
        this.storage = array;
        this.X = width;
        this.Y = height;
        this.numElements = this.X * this.Y * 4;
    }

    public ImageByte4(int width, int height) {
        this(width, height, new ByteArray(width * height * 4));
    }

    public ImageByte4(byte[][] matrix) {
        this(matrix.length / 4, matrix[0].length / 4, StorageFormats.toRowMajor(matrix));
    }

    public ByteArray getArray() {
        return this.storage;
    }

    private int toIndex(int x, int y) {
        return x * 4 + y * 4 * this.X;
    }

    public Byte4 get(int x) {
        return this.get(x, 0);
    }

    public void set(int x, Byte4 value) {
        this.set(x, 0, value);
    }

    public Byte4 get(int x, int y) {
        int offset = this.toIndex(x, y);
        return this.loadFromArray(this.storage, offset);
    }

    private Byte4 loadFromArray(ByteArray array, int index) {
        Byte4 result = new Byte4();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        result.setZ(array.get(index + 2));
        result.setW(array.get(index + 3));
        return result;
    }

    public void set(int x, int y, Byte4 value) {
        int offset = this.toIndex(x, y);
        this.storeToArray(value, this.storage, offset);
    }

    private void storeToArray(Byte4 value, ByteArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
        array.set(index + 2, value.getZ());
        array.set(index + 3, value.getW());
    }

    public int X() {
        return this.X;
    }

    public int Y() {
        return this.Y;
    }

    public void fill(byte value) {
        this.storage.init(value);
    }

    public ImageByte4 duplicate() {
        ImageByte4 matrix = new ImageByte4(this.X, this.Y);
        matrix.set(this);
        return matrix;
    }

    public void set(ImageByte4 m) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, m.storage.get(i));
        }
    }

    public Float4 mean() {
        Float4 result = new Float4();
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                Byte4 value = this.get(col, row);
                Float4 cast = new Float4(value.getX(), value.getY(), value.getZ(), value.getW());
                result = Float4.add(cast, result);
            }
        }
        return Float4.div(result, this.X * this.Y);
    }

    public Float4 min() {
        Float4 result = new Float4(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                Byte4 value = this.get(col, row);
                Float4 cast = new Float4(value.getX(), value.getY(), value.getZ(), value.getW());
                result = Float4.min(cast, result);
            }
        }
        return result;
    }

    public Float4 max() {
        Float4 result = new Float4(Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                Byte4 value = this.get(col, row);
                Float4 cast = new Float4(value.getX(), value.getY(), value.getZ(), value.getW());
                result = Float4.max(cast, result);
            }
        }
        return result;
    }

    public Float4 stdDev() {
        Float4 mean = this.mean();
        Float4 varience = new Float4();
        for (int row = 0; row < this.Y; ++row) {
            for (int col = 0; col < this.X; ++col) {
                Byte4 value = this.get(col, row);
                Float4 cast = new Float4(value.getX(), value.getY(), value.getZ(), value.getW());
                Float4 v = Float4.sub(mean, cast);
                v = Float4.mult(v, v);
                v = Float4.div(v, this.X * this.Y);
                varience = Float4.add(v, varience);
            }
        }
        return Float4.sqrt(varience);
    }

    public String summarise() {
        return String.format("ImageByte4<%dx%d>: min=%s, max=%s, mean=%s, sd=%s", this.X, this.Y, this.min(), this.max(), this.mean(), this.stdDev());
    }

    public String toString(String fmt) {
        Object str = "";
        for (int i = 0; i < this.Y; ++i) {
            for (int j = 0; j < this.X; ++j) {
                str = (String)str + this.get(j, i).toString(fmt) + " ";
            }
            str = (String)str + "\n";
        }
        return str;
    }

    public String toString(String fmt, int width, int height) {
        Object str = "";
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < height; ++j) {
                str = (String)str + this.get(j, i).toString(fmt) + " ";
            }
            str = (String)str + "\n";
        }
        return str;
    }

    public String toString() {
        Object result = String.format("ImageByte4 <%d x %d>", this.X, this.Y);
        if (this.X <= 8 && this.Y <= 8) {
            result = (String)result + "\n" + this.toString("{%3d,%3d,%3d,%3d}");
        }
        return result;
    }

    @Override
    public void loadFromBuffer(ByteBuffer src) {
        this.asBuffer().put(src);
    }

    @Override
    public ByteBuffer asBuffer() {
        return ByteBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

