/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.IntBuffer;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Int4;

public final class VectorInt4
implements TornadoCollectionInterface<IntBuffer> {
    public static final Class<VectorInt4> TYPE = VectorInt4.class;
    private static final int ELEMENT_SIZE = 4;
    private final IntArray storage;
    private final int numElements;

    VectorInt4(int numElements, IntArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorInt4(IntArray array) {
        this(array.getSize() / 4, array);
    }

    public VectorInt4(int numElements) {
        this(numElements, new IntArray(numElements * 4));
    }

    public int vectorWidth() {
        return 4;
    }

    private int toIndex(int index) {
        return index * 4;
    }

    public Int4 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Int4 loadFromArray(IntArray array, int index) {
        Int4 result = new Int4();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        result.setZ(array.get(index + 2));
        result.setW(array.get(index + 3));
        return result;
    }

    public void set(int index, Int4 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Int4 value, IntArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
        array.set(index + 2, value.getZ());
        array.set(index + 3, value.getW());
    }

    public void set(VectorInt4 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(IntArray values) {
        VectorInt4 vector = new VectorInt4(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(int value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorInt4 duplicate() {
        VectorInt4 vector = new VectorInt4(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 4) {
            return String.format("VectorInt4 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Int4 sum() {
        Int4 result = new Int4();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int4.add(result, this.get(i));
        }
        return result;
    }

    public Int4 min() {
        Int4 result = new Int4();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int4.min(result, this.get(i));
        }
        return result;
    }

    public Int4 max() {
        Int4 result = new Int4();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int4.max(result, this.get(i));
        }
        return result;
    }

    public IntBuffer asBuffer(IntArray buffer) {
        return IntBuffer.wrap(buffer.toHeapArray());
    }

    @Override
    public void loadFromBuffer(IntBuffer buffer) {
    }

    @Override
    public IntBuffer asBuffer() {
        return IntBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public IntArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

