/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.IntBuffer;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Int2;

public final class VectorInt2
implements TornadoCollectionInterface<IntBuffer> {
    public static final Class<VectorInt2> TYPE = VectorInt2.class;
    private static final int ELEMENT_SIZE = 2;
    private final IntArray storage;
    private final int numElements;

    VectorInt2(int numElements, IntArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorInt2(IntArray array) {
        this(array.getSize() / 2, array);
    }

    public VectorInt2(int numElements) {
        this(numElements, new IntArray(numElements * 2));
    }

    public int vectorWidth() {
        return 2;
    }

    private int toIndex(int index) {
        return index * 2;
    }

    public Int2 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Int2 loadFromArray(IntArray array, int index) {
        Int2 result = new Int2();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        return result;
    }

    public void set(int index, Int2 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Int2 value, IntArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
    }

    public void set(VectorInt2 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(IntArray values) {
        VectorInt2 vector = new VectorInt2(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(int value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorInt2 duplicate() {
        VectorInt2 vector = new VectorInt2(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 2) {
            return String.format("VectorInt2 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Int2 sum() {
        Int2 result = new Int2();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int2.add(result, this.get(i));
        }
        return result;
    }

    public Int2 min() {
        Int2 result = new Int2();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int2.min(result, this.get(i));
        }
        return result;
    }

    public Int2 max() {
        Int2 result = new Int2();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int2.max(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(IntBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public IntBuffer asBuffer() {
        return IntBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public IntArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

