/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.IntBuffer;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Int16;

public final class VectorInt16
implements TornadoCollectionInterface<IntBuffer> {
    public static final Class<VectorInt16> TYPE = VectorInt16.class;
    private static final int ELEMENT_SIZE = 16;
    private final IntArray storage;
    private final int numElements;

    VectorInt16(int numElements, IntArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorInt16(IntArray array) {
        this(array.getSize() / 16, array);
    }

    public VectorInt16(int numElements) {
        this(numElements, new IntArray(numElements * 16));
    }

    public int vectorWidth() {
        return 16;
    }

    private int toIndex(int index) {
        return index * 16;
    }

    public Int16 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Int16 loadFromArray(IntArray array, int index) {
        Int16 result = new Int16();
        for (int i = 0; i < 16; ++i) {
            result.set(i, array.get(index + i));
        }
        return result;
    }

    public void set(int index, Int16 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Int16 value, IntArray array, int index) {
        for (int i = 0; i < 16; ++i) {
            array.set(index + i, value.get(i));
        }
    }

    public void set(VectorInt16 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(IntArray values) {
        VectorInt16 vector = new VectorInt16(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(int value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorInt16 duplicate() {
        VectorInt16 vector = new VectorInt16(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 16) {
            return String.format("VectorInt16 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Int16 sum() {
        Int16 result = new Int16();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int16.add(result, this.get(i));
        }
        return result;
    }

    public Int16 min() {
        Int16 result = new Int16();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int16.min(result, this.get(i));
        }
        return result;
    }

    public Int16 max() {
        Int16 result = new Int16();
        for (int i = 0; i < this.numElements; ++i) {
            result = Int16.max(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(IntBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public IntBuffer asBuffer() {
        return IntBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public IntArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

