/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.IntBuffer;
import uk.ac.manchester.tornado.api.math.TornadoMath;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;

public final class VectorInt
implements TornadoCollectionInterface<IntBuffer> {
    private static final int ELEMENT_SIZE = 1;
    private final int numElements;
    private final IntArray storage;

    public VectorInt(int numElements, IntArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorInt(int numElements) {
        this(numElements, new IntArray(numElements));
    }

    public VectorInt(IntArray storage) {
        this(storage.getSize() / 1, storage);
    }

    public static int min(VectorInt v) {
        int result = Integer.MAX_VALUE;
        for (int i = 0; i < v.storage.getSize(); ++i) {
            result = Math.min(v.storage.get(i), result);
        }
        return result;
    }

    public static int max(VectorInt v) {
        int result = Integer.MIN_VALUE;
        for (int i = 0; i < v.storage.getSize(); ++i) {
            result = Math.max(v.storage.get(i), result);
        }
        return result;
    }

    public static int dot(VectorInt a, VectorInt b) {
        int sum = 0;
        for (int i = 0; i < a.size(); ++i) {
            sum += a.get(i) * b.get(i);
        }
        return sum;
    }

    public IntArray getArray() {
        return this.storage;
    }

    public int get(int index) {
        return this.storage.get(index);
    }

    public void set(int index, int value) {
        this.storage.set(index, value);
    }

    public void set(VectorInt values) {
        for (int i = 0; i < values.storage.getSize(); ++i) {
            this.storage.set(i, values.storage.get(i));
        }
    }

    public void set(int[] values) {
        for (int i = 0; i < values.length; ++i) {
            this.storage.set(i, values[i]);
        }
    }

    public void fill(int value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorInt subVector(int start, int length) {
        VectorInt v = new VectorInt(length);
        for (int i = 0; i < length; ++i) {
            v.storage.set(i, this.storage.get(i + start));
        }
        return v;
    }

    public VectorInt duplicate() {
        IntArray cp = new IntArray(this.storage.getSize());
        for (int i = 0; i < cp.getSize(); ++i) {
            cp.set(i, this.storage.get(i));
        }
        return new VectorInt(cp);
    }

    public boolean isEqual(VectorInt vector) {
        return TornadoMath.isEqual(this.storage, vector.storage);
    }

    public String toString(String fmt) {
        StringBuilder sb = new StringBuilder("[");
        sb.append("[ ");
        for (int i = 0; i < this.numElements; ++i) {
            sb.append(String.format(fmt, this.get(i)) + " ");
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        Object str = String.format("VectorInt <%d>", this.numElements);
        if (this.numElements < 32) {
            str = (String)str + this.toString("%d");
        }
        return str;
    }

    @Override
    public void loadFromBuffer(IntBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public IntBuffer asBuffer() {
        return IntBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.numElements;
    }

    public int getLength() {
        return this.numElements;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

