/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.ShortBuffer;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Half8;

public final class VectorHalf8
implements TornadoCollectionInterface<ShortBuffer> {
    public static final Class<VectorHalf8> TYPE = VectorHalf8.class;
    private static final int ELEMENT_SIZE = 8;
    private final int numElements;
    private final HalfFloatArray storage;

    protected VectorHalf8(int numElements, HalfFloatArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorHalf8(int numElements) {
        this(numElements, new HalfFloatArray(numElements * 8));
    }

    private VectorHalf8(HalfFloatArray array) {
        this(array.getSize() / 8, array);
    }

    public int vectorWidth() {
        return 8;
    }

    private int toIndex(int index) {
        return index * 8;
    }

    public Half8 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Half8 loadFromArray(HalfFloatArray array, int index) {
        Half8 result = new Half8();
        result.setS0(array.get(index));
        result.setS1(array.get(index + 1));
        result.setS2(array.get(index + 2));
        result.setS3(array.get(index + 3));
        result.setS4(array.get(index + 4));
        result.setS5(array.get(index + 5));
        result.setS6(array.get(index + 6));
        result.setS7(array.get(index + 7));
        return result;
    }

    public void set(int index, Half8 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Half8 value, HalfFloatArray array, int index) {
        for (int i = 0; i < 8; ++i) {
            array.set(index + i, value.get(i));
        }
    }

    public void set(VectorHalf8 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(HalfFloatArray values) {
        VectorHalf8 vector = new VectorHalf8(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(HalfFloat value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorHalf8 duplicate() {
        VectorHalf8 vector = new VectorHalf8(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 8) {
            return String.format("VectorHalf8 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Half8 sum() {
        Half8 result = new Half8();
        for (int i = 0; i < this.numElements; ++i) {
            result = Half8.add(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(ShortBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ShortBuffer asBuffer() {
        return ShortBuffer.wrap(this.storage.toShortArray());
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public HalfFloatArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

