/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.ShortBuffer;
import uk.ac.manchester.tornado.api.types.HalfFloat;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Half2;

public final class VectorHalf2
implements TornadoCollectionInterface<ShortBuffer> {
    public static final Class<VectorHalf2> TYPE = VectorHalf2.class;
    private static final int ELEMENT_SIZE = 2;
    private final int numElements;
    private final HalfFloatArray storage;

    protected VectorHalf2(int numElements, HalfFloatArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorHalf2(int numElements) {
        this(numElements, new HalfFloatArray(numElements * 2));
    }

    private VectorHalf2(HalfFloatArray array) {
        this(array.getSize() / 2, array);
    }

    public int vectorWidth() {
        return 2;
    }

    private int toIndex(int index) {
        return index * 2;
    }

    public Half2 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Half2 loadFromArray(HalfFloatArray array, int index) {
        Half2 result = new Half2();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        return result;
    }

    public void set(int index, Half2 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Half2 value, HalfFloatArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
    }

    public void set(VectorHalf2 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(HalfFloatArray values) {
        VectorHalf2 vector = new VectorHalf2(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(HalfFloat value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorHalf2 duplicate() {
        VectorHalf2 vector = new VectorHalf2(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 2) {
            return String.format("VectorHalf2 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Half2 sum() {
        Half2 result = new Half2();
        for (int i = 0; i < this.numElements; ++i) {
            result = Half2.add(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(ShortBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public ShortBuffer asBuffer() {
        return ShortBuffer.wrap(this.storage.toShortArray());
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public HalfFloatArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

