/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Float8;

public final class VectorFloat8
implements TornadoCollectionInterface<FloatBuffer> {
    public static final Class<VectorFloat8> TYPE = VectorFloat8.class;
    private static final int ELEMENT_SIZE = 8;
    private final FloatArray storage;
    private final int numElements;

    VectorFloat8(int numElements, FloatArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorFloat8(FloatArray array) {
        this(array.getSize() / 8, array);
    }

    public VectorFloat8(int numElements) {
        this(numElements, new FloatArray(numElements * 8));
    }

    public int vectorWidth() {
        return 8;
    }

    private int toIndex(int index) {
        return index * 8;
    }

    public Float8 get(int index) {
        return this.loadFromArray(this.storage, this.toIndex(index));
    }

    private Float8 loadFromArray(FloatArray array, int index) {
        Float8 result = new Float8();
        result.setS0(array.get(index));
        result.setS1(array.get(index + 1));
        result.setS2(array.get(index + 2));
        result.setS3(array.get(index + 3));
        result.setS4(array.get(index + 4));
        result.setS5(array.get(index + 5));
        result.setS6(array.get(index + 6));
        result.setS7(array.get(index + 7));
        return result;
    }

    public void set(int index, Float8 value) {
        this.storeToArray(value, this.storage, this.toIndex(index));
    }

    private void storeToArray(Float8 value, FloatArray array, int index) {
        for (int i = 0; i < 8; ++i) {
            array.set(index + i, value.get(i));
        }
    }

    public void set(VectorFloat8 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(FloatArray values) {
        VectorFloat8 vector = new VectorFloat8(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(float value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorFloat8 duplicate() {
        VectorFloat8 vector = new VectorFloat8(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 8) {
            return String.format("VectorFloat8 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Float8 sum() {
        Float8 result = new Float8();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float8.add(result, this.get(i));
        }
        return result;
    }

    public Float8 min() {
        Float8 result = new Float8();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float8.min(result, this.get(i));
        }
        return result;
    }

    public Float8 max() {
        Float8 result = new Float8();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float8.max(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public FloatArray getArray() {
        return this.storage;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

