/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Float4;

public final class VectorFloat4
implements TornadoCollectionInterface<FloatBuffer> {
    public static final Class<VectorFloat4> TYPE = VectorFloat4.class;
    private static final int ELEMENT_SIZE = 4;
    private final FloatArray storage;
    private final int numElements;

    private VectorFloat4(int numElements, FloatArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorFloat4(FloatArray array) {
        this(array.getSize() / 4, array);
    }

    public VectorFloat4(int numElements) {
        this(numElements, new FloatArray(numElements * 4));
    }

    public int vectorWidth() {
        return 4;
    }

    public FloatArray getArray() {
        return this.storage;
    }

    private int getIndex(int index) {
        return index * 4;
    }

    public Float4 get(int index) {
        return this.loadFromArray(this.storage, this.getIndex(index));
    }

    private Float4 loadFromArray(FloatArray array, int index) {
        Float4 result = new Float4();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        result.setZ(array.get(index + 2));
        result.setW(array.get(index + 3));
        return result;
    }

    public void set(int index, Float4 value) {
        this.storeToArray(value, this.storage, this.getIndex(index));
    }

    private void storeToArray(Float4 value, FloatArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
        array.set(index + 2, value.getZ());
        array.set(index + 3, value.getW());
    }

    public void set(VectorFloat4 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(FloatArray values) {
        VectorFloat4 vector = new VectorFloat4(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(float value) {
        this.storage.init(value);
    }

    public VectorFloat4 duplicate() {
        VectorFloat4 vector = new VectorFloat4(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 4) {
            return String.format("VectorFloat4 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Float4 sum() {
        Float4 result = new Float4();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float4.add(result, this.get(i));
        }
        return result;
    }

    public Float4 min() {
        Float4 result = new Float4();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float4.min(result, this.get(i));
        }
        return result;
    }

    public Float4 max() {
        Float4 result = new Float4();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float4.max(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

