/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.collections;

import java.lang.foreign.MemorySegment;
import java.nio.FloatBuffer;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.collections.TornadoCollectionInterface;
import uk.ac.manchester.tornado.api.types.vectors.Float3;

public final class VectorFloat3
implements TornadoCollectionInterface<FloatBuffer> {
    public static final Class<VectorFloat3> TYPE = VectorFloat3.class;
    private static final int ELEMENT_SIZE = 3;
    private final FloatArray storage;
    private final int numElements;

    VectorFloat3(int numElements, FloatArray array) {
        this.numElements = numElements;
        this.storage = array;
    }

    public VectorFloat3(FloatArray array) {
        this(array.getSize() / 3, array);
    }

    public VectorFloat3(int numElements) {
        this(numElements, new FloatArray(numElements * 3));
    }

    public int vectorWidth() {
        return 3;
    }

    public FloatArray getArray() {
        return this.storage;
    }

    private int getIndex(int index) {
        return index * 3;
    }

    public Float3 get(int index) {
        return this.loadFromArray(this.storage, this.getIndex(index));
    }

    private Float3 loadFromArray(FloatArray array, int index) {
        Float3 result = new Float3();
        result.setX(array.get(index));
        result.setY(array.get(index + 1));
        result.setZ(array.get(index + 2));
        return result;
    }

    public void set(int index, Float3 value) {
        this.storeToArray(value, this.storage, this.getIndex(index));
    }

    private void storeToArray(Float3 value, FloatArray array, int index) {
        array.set(index, value.getX());
        array.set(index + 1, value.getY());
        array.set(index + 2, value.getZ());
    }

    public void set(VectorFloat3 values) {
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, values.get(i));
        }
    }

    public void set(FloatArray values) {
        VectorFloat3 vector = new VectorFloat3(values);
        for (int i = 0; i < this.numElements; ++i) {
            this.set(i, vector.get(i));
        }
    }

    public void fill(float value) {
        for (int i = 0; i < this.storage.getSize(); ++i) {
            this.storage.set(i, value);
        }
    }

    public VectorFloat3 duplicate() {
        VectorFloat3 vector = new VectorFloat3(this.numElements);
        vector.set(this);
        return vector;
    }

    public String toString() {
        if (this.numElements > 3) {
            return String.format("VectorFloat3 <%d>", this.numElements);
        }
        StringBuilder tempString = new StringBuilder();
        for (int i = 0; i < this.numElements; ++i) {
            tempString.append(" ").append(this.get(i).toString());
        }
        return tempString.toString();
    }

    public Float3 sum() {
        Float3 result = new Float3();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float3.add(result, this.get(i));
        }
        return result;
    }

    public Float3 min() {
        Float3 result = new Float3();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float3.min(result, this.get(i));
        }
        return result;
    }

    public Float3 max() {
        Float3 result = new Float3();
        for (int i = 0; i < this.numElements; ++i) {
            result = Float3.max(result, this.get(i));
        }
        return result;
    }

    @Override
    public void loadFromBuffer(FloatBuffer buffer) {
        this.asBuffer().put(buffer);
    }

    @Override
    public FloatBuffer asBuffer() {
        return FloatBuffer.wrap(this.storage.toHeapArray());
    }

    @Override
    public int size() {
        return this.storage.getSize();
    }

    public int getLength() {
        return this.numElements;
    }

    public void clear() {
        this.storage.clear();
    }

    @Override
    public long getNumBytes() {
        return this.storage.getNumBytesOfSegment();
    }

    @Override
    public long getNumBytesWithHeader() {
        return this.storage.getNumBytesOfSegmentWithHeader();
    }

    @Override
    public MemorySegment getSegment() {
        return this.getArray().getSegment();
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.getArray().getSegmentWithHeader();
    }
}

