/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.arrays;

import java.lang.foreign.MemorySegment;
import uk.ac.manchester.tornado.api.types.arrays.ByteArray;
import uk.ac.manchester.tornado.api.types.arrays.CharArray;
import uk.ac.manchester.tornado.api.types.arrays.DoubleArray;
import uk.ac.manchester.tornado.api.types.arrays.FloatArray;
import uk.ac.manchester.tornado.api.types.arrays.HalfFloatArray;
import uk.ac.manchester.tornado.api.types.arrays.IntArray;
import uk.ac.manchester.tornado.api.types.arrays.LongArray;
import uk.ac.manchester.tornado.api.types.arrays.ShortArray;
import uk.ac.manchester.tornado.api.types.tensors.Tensor;

public abstract sealed class TornadoNativeArray
permits ByteArray, CharArray, DoubleArray, FloatArray, HalfFloatArray, IntArray, LongArray, ShortArray, Tensor {
    public static final long ARRAY_HEADER = Long.parseLong(System.getProperty("tornado.panama.objectHeader", "24"));

    public abstract int getSize();

    public abstract MemorySegment getSegment();

    public abstract MemorySegment getSegmentWithHeader();

    public abstract long getNumBytesOfSegmentWithHeader();

    public abstract long getNumBytesOfSegment();

    protected abstract void clear();

    public abstract int getElementSize();

    static void ensureMultipleOfElementSize(long byteSize, long elementSize) {
        if (byteSize % elementSize != 0L) {
            throw new IllegalArgumentException(String.format("The byte size (%d) is not a multiple of the element size (%d)", byteSize, elementSize));
        }
    }
}

