/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.arrays;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.FloatBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;

@SegmentElementSize(size=4)
public final class FloatArray
extends TornadoNativeArray {
    private static final int FLOAT_BYTES = 4;
    private MemorySegment segment;
    private int numberOfElements;
    private int arrayHeaderSize;
    private int baseIndex;
    private long segmentByteSize;

    public FloatArray(int numberOfElements) {
        this.numberOfElements = numberOfElements;
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 4;
        this.segmentByteSize = numberOfElements * 4 + this.arrayHeaderSize;
        this.segment = Arena.ofAuto().allocate(this.segmentByteSize, 1L);
        this.segment.setAtIndex(ValueLayout.JAVA_INT, 0L, numberOfElements);
    }

    public FloatArray(FloatArray ... arrays) {
        FloatArray.concat(arrays);
    }

    private static FloatArray createSegment(float[] values) {
        FloatArray array = new FloatArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            array.set(i, values[i]);
        }
        return array;
    }

    public static FloatArray fromArray(float[] values) {
        return FloatArray.createSegment(values);
    }

    public static FloatArray fromElements(float ... values) {
        return FloatArray.createSegment(values);
    }

    public static FloatArray fromSegment(MemorySegment segment) {
        long byteSize = segment.byteSize();
        int numElements = (int)(byteSize / 4L);
        FloatArray.ensureMultipleOfElementSize(byteSize, 4L);
        FloatArray floatArray = new FloatArray(numElements);
        MemorySegment.copy(segment, 0L, floatArray.segment, floatArray.baseIndex * 4, byteSize);
        return floatArray;
    }

    public static FloatArray fromFloatBuffer(FloatBuffer buffer) {
        int numElements = buffer.remaining();
        FloatArray floatArray = new FloatArray(numElements);
        floatArray.getSegment().copyFrom(MemorySegment.ofBuffer(buffer));
        return floatArray;
    }

    public float[] toHeapArray() {
        float[] outputArray = new float[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            outputArray[i] = this.get(i);
        }
        return outputArray;
    }

    public void set(int index, float value) {
        this.segment.setAtIndex(ValueLayout.JAVA_FLOAT, (long)(this.baseIndex + index), value);
    }

    public float get(int index) {
        return this.segment.getAtIndex(ValueLayout.JAVA_FLOAT, (long)(this.baseIndex + index));
    }

    @Override
    public void clear() {
        this.init(0.0f);
    }

    @Override
    public int getElementSize() {
        return 4;
    }

    public void init(float value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.segment.setAtIndex(ValueLayout.JAVA_FLOAT, (long)(this.baseIndex + i), value);
        }
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.segment.asSlice(TornadoNativeArray.ARRAY_HEADER);
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.segment;
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.segmentByteSize;
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.segmentByteSize - TornadoNativeArray.ARRAY_HEADER;
    }

    public static void initialize(FloatArray array, float value) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, value);
        }
    }

    public static FloatArray concat(FloatArray ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(FloatArray::getSize).sum();
        FloatArray concatArray = new FloatArray(newSize);
        long currentPositionBytes = 0L;
        for (FloatArray array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }

    public FloatArray slice(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.getSize()) {
            throw new IllegalArgumentException("Slice out of bounds");
        }
        long sliceOffsetInBytes = TornadoNativeArray.ARRAY_HEADER + (long)(offset * 4);
        long sliceByteLength = length * 4;
        MemorySegment sliceSegment = this.segment.asSlice(sliceOffsetInBytes, sliceByteLength);
        FloatArray slice = FloatArray.fromSegment(sliceSegment);
        return slice;
    }
}

