/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.arrays;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.CharBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;

@SegmentElementSize(size=2)
public final class CharArray
extends TornadoNativeArray {
    private static final int CHAR_BYTES = 2;
    private MemorySegment segment;
    private int numberOfElements;
    private int arrayHeaderSize;
    private int baseIndex;
    private long segmentByteSize;

    public CharArray(int numberOfElements) {
        this.numberOfElements = numberOfElements;
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 2;
        this.segmentByteSize = numberOfElements * 2 + this.arrayHeaderSize;
        this.segment = Arena.ofAuto().allocate(this.segmentByteSize, 1L);
        this.segment.setAtIndex(ValueLayout.JAVA_INT, 0L, numberOfElements);
    }

    public CharArray(CharArray ... arrays) {
        CharArray.concat(arrays);
    }

    private static CharArray createSegment(char[] values) {
        CharArray array = new CharArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            array.set(i, values[i]);
        }
        return array;
    }

    public static CharArray fromArray(char[] values) {
        return CharArray.createSegment(values);
    }

    public static CharArray fromElements(char ... values) {
        return CharArray.createSegment(values);
    }

    public static CharArray fromSegment(MemorySegment segment) {
        long byteSize = segment.byteSize();
        int numElements = (int)(byteSize / 2L);
        CharArray.ensureMultipleOfElementSize(byteSize, 2L);
        CharArray charArray = new CharArray(numElements);
        MemorySegment.copy(segment, 0L, charArray.segment, charArray.baseIndex * 2, byteSize);
        return charArray;
    }

    public static CharArray fromCharBuffer(CharBuffer buffer) {
        int numElements = buffer.remaining();
        CharArray charArray = new CharArray(numElements);
        charArray.getSegment().copyFrom(MemorySegment.ofBuffer(buffer));
        return charArray;
    }

    @Override
    public void clear() {
        this.init('\u0000');
    }

    @Override
    public int getElementSize() {
        return 2;
    }

    public char[] toHeapArray() {
        char[] outputArray = new char[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            outputArray[i] = this.get(i);
        }
        return outputArray;
    }

    public void set(int index, char value) {
        this.segment.setAtIndex(ValueLayout.JAVA_CHAR, (long)(this.baseIndex + index), value);
    }

    public char get(int index) {
        return this.segment.getAtIndex(ValueLayout.JAVA_CHAR, (long)(this.baseIndex + index));
    }

    public void init(char value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.segment.setAtIndex(ValueLayout.JAVA_CHAR, (long)(this.baseIndex + i), value);
        }
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.segment.asSlice(TornadoNativeArray.ARRAY_HEADER);
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.segment;
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.segmentByteSize;
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.segmentByteSize - TornadoNativeArray.ARRAY_HEADER;
    }

    public static void initialize(CharArray array, char value) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, value);
        }
    }

    public static CharArray concat(CharArray ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(CharArray::getSize).sum();
        CharArray concatArray = new CharArray(newSize);
        long currentPositionBytes = 0L;
        for (CharArray array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }

    public CharArray slice(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.getSize()) {
            throw new IllegalArgumentException("Slice out of bounds");
        }
        long sliceOffsetInBytes = TornadoNativeArray.ARRAY_HEADER + (long)(offset * 2);
        long sliceByteLength = length * 2;
        MemorySegment sliceSegment = this.segment.asSlice(sliceOffsetInBytes, sliceByteLength);
        CharArray slice = CharArray.fromSegment(sliceSegment);
        return slice;
    }
}

