/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.types.arrays;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteBuffer;
import java.util.Arrays;
import uk.ac.manchester.tornado.api.internal.annotations.SegmentElementSize;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;

@SegmentElementSize(size=1)
public final class ByteArray
extends TornadoNativeArray {
    private static final int BYTE_BYTES = 1;
    private MemorySegment segment;
    private int numberOfElements;
    private int arrayHeaderSize;
    private int baseIndex;
    private long segmentByteSize;

    public ByteArray(int numberOfElements) {
        this.numberOfElements = numberOfElements;
        this.arrayHeaderSize = (int)TornadoNativeArray.ARRAY_HEADER;
        this.baseIndex = this.arrayHeaderSize / 1;
        this.segmentByteSize = numberOfElements * 1 + this.arrayHeaderSize;
        this.segment = Arena.ofAuto().allocate(this.segmentByteSize, 1L);
        this.segment.setAtIndex(ValueLayout.JAVA_INT, 0L, numberOfElements);
    }

    public ByteArray(ByteArray ... arrays) {
        ByteArray.concat(arrays);
    }

    private static ByteArray createSegment(byte[] values) {
        ByteArray array = new ByteArray(values.length);
        for (int i = 0; i < values.length; ++i) {
            array.set(i, values[i]);
        }
        return array;
    }

    public static ByteArray fromArray(byte[] values) {
        return ByteArray.createSegment(values);
    }

    public static ByteArray fromElements(byte ... values) {
        return ByteArray.createSegment(values);
    }

    public static ByteArray fromSegment(MemorySegment segment) {
        long byteSize = segment.byteSize();
        int numElements = (int)(byteSize / 1L);
        ByteArray.ensureMultipleOfElementSize(byteSize, 1L);
        ByteArray byteArray = new ByteArray(numElements);
        MemorySegment.copy(segment, 0L, byteArray.segment, byteArray.baseIndex * 1, byteSize);
        return byteArray;
    }

    public static ByteArray fromByteBuffer(ByteBuffer buffer) {
        int numElements = buffer.remaining();
        ByteArray byteArray = new ByteArray(numElements);
        byteArray.getSegment().copyFrom(MemorySegment.ofBuffer(buffer));
        return byteArray;
    }

    public byte[] toHeapArray() {
        byte[] outputArray = new byte[this.getSize()];
        for (int i = 0; i < this.getSize(); ++i) {
            outputArray[i] = this.get(i);
        }
        return outputArray;
    }

    public void set(int index, byte value) {
        this.segment.setAtIndex(ValueLayout.JAVA_BYTE, (long)(this.baseIndex + index), value);
    }

    public byte get(int index) {
        return this.segment.getAtIndex(ValueLayout.JAVA_BYTE, (long)(this.baseIndex + index));
    }

    @Override
    public void clear() {
        this.init((byte)0);
    }

    @Override
    public int getElementSize() {
        return 1;
    }

    public void init(byte value) {
        for (int i = 0; i < this.getSize(); ++i) {
            this.segment.setAtIndex(ValueLayout.JAVA_BYTE, (long)(this.baseIndex + i), value);
        }
    }

    @Override
    public int getSize() {
        return this.numberOfElements;
    }

    @Override
    public MemorySegment getSegment() {
        return this.segment.asSlice(TornadoNativeArray.ARRAY_HEADER);
    }

    @Override
    public MemorySegment getSegmentWithHeader() {
        return this.segment;
    }

    @Override
    public long getNumBytesOfSegmentWithHeader() {
        return this.segmentByteSize;
    }

    @Override
    public long getNumBytesOfSegment() {
        return this.segmentByteSize - TornadoNativeArray.ARRAY_HEADER;
    }

    public static void initialize(ByteArray array, byte value) {
        for (int i = 0; i < array.getSize(); ++i) {
            array.set(i, value);
        }
    }

    public static ByteArray concat(ByteArray ... arrays) {
        int newSize = Arrays.stream(arrays).mapToInt(ByteArray::getSize).sum();
        ByteArray concatArray = new ByteArray(newSize);
        long currentPositionBytes = 0L;
        for (ByteArray array : arrays) {
            MemorySegment.copy(array.getSegment(), 0L, concatArray.getSegment(), currentPositionBytes, array.getNumBytesOfSegment());
            currentPositionBytes += array.getNumBytesOfSegment();
        }
        return concatArray;
    }

    public ByteArray slice(int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > this.getSize()) {
            throw new IllegalArgumentException("Slice out of bounds");
        }
        long sliceOffsetInBytes = TornadoNativeArray.ARRAY_HEADER + (long)(offset * 1);
        long sliceByteLength = length * 1;
        MemorySegment sliceSegment = this.segment.asSlice(sliceOffsetInBytes, sliceByteLength);
        ByteArray slice = ByteArray.fromSegment(sliceSegment);
        return slice;
    }
}

