/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.profiler;

import java.io.File;
import java.util.Map;
import uk.ac.manchester.tornado.api.profiler.ChromeEventJSonWriter;

public class ChromeEventTracer {
    public static final String CHROME_EVENT_TRACER_FILENAME_KEY = "tornado.chrome.event.tracer.filename";
    public static final String CHROME_EVENT_TRACER_FILENAME = System.getProperties().getProperty("tornado.chrome.event.tracer.filename", "chrome.json");
    public static final String CHROME_EVENT_TRACER_ENABLED_KEY = "tornado.chrome.event.tracer.enabled";
    public static final ChromeEventJSonWriter json = new ChromeEventJSonWriter();

    public static String getChromeEventTracerFileName() {
        return System.getProperties().getProperty(CHROME_EVENT_TRACER_FILENAME_KEY, "chrome.json");
    }

    public static boolean isChromeEventTracerEnabled() {
        return Boolean.getBoolean(CHROME_EVENT_TRACER_ENABLED_KEY);
    }

    public static ChromeEventTracer create() {
        return new ChromeEventTracer();
    }

    public static boolean isEnabled() {
        return ChromeEventTracer.isChromeEventTracerEnabled();
    }

    public static void enqueueWriteIfEnabled(String tag, long bytes, long startNs, long endNs) {
        if (ChromeEventTracer.isEnabled()) {
            json.x(tag, "write", startNs, endNs, () -> json.kv("bytes", bytes));
        }
    }

    public static void enqueueReadIfEnabled(String tag, long bytes, long startNs, long endNs) {
        if (ChromeEventTracer.isEnabled()) {
            json.x(tag, "read", startNs, endNs, () -> json.kv("bytes", bytes));
        }
    }

    public static void enqueueNDRangeKernelIfEnabled(String tag, long startNs, long endNs) {
        if (ChromeEventTracer.isEnabled()) {
            json.x(tag, "NDRangeKernel", startNs, endNs, null);
        }
    }

    public static void enqueueTaskIfEnabled(String tag, long startNs, long endNs) {
        if (ChromeEventTracer.isEnabled()) {
            json.x(tag, "exec", startNs, endNs, null);
        }
    }

    public static void trace(String tag, Runnable r) {
        long startNs = System.nanoTime();
        r.run();
        if (ChromeEventTracer.isEnabled()) {
            json.x(tag, "trace", startNs, System.nanoTime(), null);
        }
    }

    public static <T> T trace(String tag, Builder<T> b) {
        long startNs = System.nanoTime();
        T value = b.build();
        if (ChromeEventTracer.isEnabled()) {
            json.x(tag, "trace", startNs, System.nanoTime(), null);
        }
        return value;
    }

    public static void opencltimes(int localId, long queuedNs, long submitNs, long startNs, long endNs, Map<String, ?> meta) {
        json.x("queued", null, queuedNs, endNs, meta == null ? null : () -> {
            for (String k : meta.keySet()) {
                json.kv(k, (String)meta.get(k));
            }
        });
        json.x("submit", null, submitNs, endNs, null);
        json.x("start", null, startNs, endNs, null);
    }

    static {
        if (ChromeEventTracer.isEnabled()) {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> json.write(new File(ChromeEventTracer.getChromeEventTracerFileName()))));
        }
    }

    public static interface Builder<T> {
        public T build();
    }
}

