/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api.common;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import uk.ac.manchester.tornado.api.TornadoDeviceContext;
import uk.ac.manchester.tornado.api.TornadoTargetDevice;
import uk.ac.manchester.tornado.api.common.Access;
import uk.ac.manchester.tornado.api.common.Event;
import uk.ac.manchester.tornado.api.enums.TornadoDeviceType;
import uk.ac.manchester.tornado.api.enums.TornadoVMBackendType;
import uk.ac.manchester.tornado.api.memory.DeviceBufferState;
import uk.ac.manchester.tornado.api.memory.TornadoMemoryProvider;

public interface TornadoDevice {
    public long allocate(Object var1, long var2, DeviceBufferState var4, Access var5);

    public long allocateObjects(Object[] var1, long var2, DeviceBufferState[] var4, Access[] var5);

    public long deallocate(DeviceBufferState var1);

    public List<Integer> ensurePresent(long var1, Object var3, DeviceBufferState var4, int[] var5, long var6, long var8);

    public List<Integer> streamIn(long var1, Object var3, long var4, long var6, DeviceBufferState var8, int[] var9);

    public int streamOut(long var1, Object var3, long var4, DeviceBufferState var6, int[] var7);

    public int streamOutBlocking(long var1, Object var3, long var4, DeviceBufferState var6, int[] var7);

    public Event resolveEvent(long var1, int var3);

    public void ensureLoaded(long var1);

    public void flushEvents(long var1);

    public int enqueueBarrier(long var1);

    public int enqueueBarrier(long var1, int[] var3);

    public int enqueueMarker(long var1);

    public int enqueueMarker(long var1, int[] var3);

    public void sync(long var1);

    public void flush(long var1);

    public void clean();

    public void dumpEvents(long var1);

    public String getDeviceName();

    public String getDescription();

    public String getPlatformName();

    public TornadoDeviceContext getDeviceContext();

    public TornadoTargetDevice getPhysicalDevice();

    public TornadoMemoryProvider getMemoryProvider();

    public TornadoDeviceType getDeviceType();

    public long getMaxAllocMemory();

    public long getMaxGlobalMemory();

    public long getDeviceLocalMemorySize();

    public long[] getDeviceMaxWorkgroupDimensions();

    public String getDeviceOpenCLCVersion();

    public Object getDeviceInfo();

    public int getBackendIndex();

    default public int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public Object getAtomic();

    @Deprecated
    public void setAtomicsMapping(ConcurrentHashMap<Object, Integer> var1);

    public TornadoVMBackendType getTornadoVMBackend();

    public boolean isSPIRVSupported();

    public void mapDeviceRegion(long var1, Object var3, Object var4, DeviceBufferState var5, DeviceBufferState var6, long var7);
}

