/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import uk.ac.manchester.tornado.api.TornadoBackend;
import uk.ac.manchester.tornado.api.TornadoExecutionPlan;
import uk.ac.manchester.tornado.api.TornadoRuntime;
import uk.ac.manchester.tornado.api.common.TornadoDevice;
import uk.ac.manchester.tornado.api.enums.TornadoDeviceType;
import uk.ac.manchester.tornado.api.runtime.TornadoRuntimeProvider;

public class TornadoDeviceMap {
    private final TornadoRuntime coreRuntime = TornadoRuntimeProvider.getTornadoRuntime();
    private final int numBackends = this.coreRuntime.getNumBackends();
    private final List<TornadoBackend> backends = new ArrayList<TornadoBackend>();

    public TornadoDeviceMap() {
        for (int i = 0; i < this.numBackends; ++i) {
            this.backends.add(this.coreRuntime.getBackend(i));
        }
    }

    public int getNumBackends() {
        return this.numBackends;
    }

    public List<TornadoBackend> getAllBackends() {
        return this.backends;
    }

    public List<TornadoBackend> getBackendsWithPredicate(Predicate<? super TornadoBackend> predicate) {
        return this.getAllBackends().stream().filter(predicate).toList();
    }

    public List<TornadoBackend> getBackendsWithDevicePredicate(Predicate<? super TornadoDevice> predicate) {
        return this.getAllBackends().stream().filter(backend -> backend.getAllDevices().stream().anyMatch(predicate)).toList();
    }

    public Stream<TornadoDevice> getDevicesByName(String deviceName) {
        TornadoDeviceMap deviceMap = TornadoExecutionPlan.getTornadoDeviceMap();
        List<TornadoBackend> backendFilter = deviceMap.getBackendsWithPredicate(backend -> backend.getAllDevices().stream().anyMatch(device -> device.getPhysicalDevice().getDeviceName().toLowerCase().contains(deviceName.toLowerCase())));
        if (!backendFilter.isEmpty()) {
            Stream<TornadoDevice> deviceStream = null;
            for (TornadoBackend backend2 : backendFilter) {
                Stream<TornadoDevice> deviceStreamI = backend2.getAllDevices().stream().filter(device -> device.getPhysicalDevice().getDeviceName().toLowerCase().contains(deviceName.toLowerCase()));
                if (deviceStream == null) {
                    deviceStream = deviceStreamI;
                    continue;
                }
                deviceStream = Stream.concat(deviceStream, deviceStreamI);
            }
            return deviceStream;
        }
        return Arrays.stream(new TornadoDevice[0]);
    }

    public Stream<TornadoDevice> getDevicesByType(TornadoDeviceType deviceType) {
        TornadoDeviceMap deviceMap = TornadoExecutionPlan.getTornadoDeviceMap();
        List<TornadoBackend> backendFilter = deviceMap.getBackendsWithPredicate(backend -> backend.getAllDevices().stream().anyMatch(device -> device.getDeviceType() == deviceType));
        if (!backendFilter.isEmpty()) {
            Stream<TornadoDevice> deviceStream = null;
            for (TornadoBackend backend2 : backendFilter) {
                Stream<TornadoDevice> deviceStreamI = backend2.getAllDevices().stream().filter(device -> device.getDeviceType() == deviceType);
                if (deviceStream == null) {
                    deviceStream = deviceStreamI;
                    continue;
                }
                deviceStream = Stream.concat(deviceStream, deviceStreamI);
            }
            return deviceStream;
        }
        return Arrays.stream(new TornadoDevice[0]);
    }
}

