/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.tornado.api;

import uk.ac.manchester.tornado.api.exceptions.TornadoRuntimeException;
import uk.ac.manchester.tornado.api.types.arrays.TornadoNativeArray;

public class DataRange {
    private final TornadoNativeArray tornadoNativeArray;
    private final long totalSizeInBytes;
    private final int elementSize;
    private long offset;
    private long offsetMaterialized;
    private long partialSize;
    private long partialSizeMaterialized;
    private boolean isMaterialized;

    public DataRange(TornadoNativeArray tornadoNativeArray) {
        this.tornadoNativeArray = tornadoNativeArray;
        this.elementSize = tornadoNativeArray.getElementSize();
        this.totalSizeInBytes = tornadoNativeArray.getNumBytesOfSegment();
    }

    public DataRange withOffset(long offset) {
        this.offset = offset;
        return this;
    }

    public DataRange withSize(long size) {
        this.partialSize = size;
        return this;
    }

    public long getOffset() {
        if (this.isMaterialized) {
            return this.offsetMaterialized;
        }
        throw new TornadoRuntimeException("[error] Invoke materialize() before any getter");
    }

    public long getPartialSize() {
        if (this.isMaterialized) {
            return this.partialSizeMaterialized;
        }
        throw new TornadoRuntimeException("[error] Invoke materialize() before any getter");
    }

    public void materialize() {
        long arrayHeader = TornadoNativeArray.ARRAY_HEADER;
        this.partialSizeMaterialized = this.partialSize == 0L ? this.totalSizeInBytes : this.partialSize * (long)this.elementSize;
        this.offsetMaterialized = this.offset == 0L ? arrayHeader : arrayHeader + this.offset * (long)this.elementSize;
        if (this.partialSizeMaterialized + this.offsetMaterialized > this.totalSizeInBytes + arrayHeader) {
            throw new TornadoRuntimeException("[Error] Partial Copy size is larger than the array size. Check the value passed to the `withSize` method");
        }
        this.isMaterialized = true;
    }

    public TornadoNativeArray getArray() {
        return this.tornadoNativeArray;
    }
}

