/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.utils;

import edu.rit.mp.Buf;
import edu.rit.mp.DoubleBuf;
import edu.rit.pj.Comm;
import ffx.crystal.Crystal;
import ffx.crystal.ReplicatesCrystal;
import ffx.crystal.SymOp;
import ffx.numerics.math.DoubleMath;
import ffx.numerics.math.MatrixMath;
import ffx.numerics.math.RunningStatistics;
import ffx.numerics.math.ScalarMath;
import ffx.potential.MolecularAssembly;
import ffx.potential.Utilities;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Bond;
import ffx.potential.bonded.MSNode;
import ffx.potential.parameters.ForceField;
import ffx.potential.parsers.DistanceMatrixFilter;
import ffx.potential.parsers.PDBFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.potential.utils.StructureMetrics;
import ffx.potential.utils.Superpose;
import ffx.utilities.DoubleIndexPair;
import ffx.utilities.IndexIndexPair;
import ffx.utilities.Resources;
import ffx.utilities.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.math3.util.FastMath;

public class ProgressiveAlignmentOfCrystals {
    private static final Logger logger = Logger.getLogger(ProgressiveAlignmentOfCrystals.class.getName());
    private final SystemFilter baseFilter;
    private final int baseSize;
    private final String baseLabel;
    private final SystemFilter targetFilter;
    private final int targetSize;
    private final String targetLabel;
    private final int numWorkItems;
    private final boolean isSymmetric;
    private String rmsdLabel;
    public final double[] distRow;
    private int restartRow = 0;
    private int restartColumn = 0;
    private final Comm world;
    private final boolean useMPI;
    private final int numProc;
    private final int rank;
    private final double[][] distances;
    private final DoubleBuf[] buffers;
    private final double[] myDistances;
    private final DoubleBuf myBuffer;
    private double[] massN;
    private double massSum = 0.0;
    private int[] comparisonAtoms;
    private DoubleIndexPair[] baseAUDist;
    private DoubleIndexPair[] baseAUDist_2;
    private DoubleIndexPair[] targetAUDist;
    private DoubleIndexPair[] targetAUDist_2;
    private final List<Integer> tempListIndices = new ArrayList<Integer>();
    private Integer[] uniqueBase;
    private Integer[] uniqueTarget;
    private double[] baseXYZoriginal;
    private double[] baseXYZ;
    private double[] targetXYZoriginal;
    private double[] targetXYZ;
    private double[][][] baseCoM;
    private double[][] baseAUoriginal;
    private double[] baseAU;
    private double[] base3AUs;
    private double[][] baseNAUs;
    private double[][][] bestBaseNAUs;
    private double[][] targetCoM;
    private double[][] targetAUoriginal;
    private double[] targetAU;
    private double[] target3AUs;
    private double[] targetNAUs;
    private double[][][] bestTargetNAUs;
    private DoubleIndexPair[] pairedAUs;
    private int numberOfHits = 0;
    private File[] fileCache;
    private String[] nameCache;
    private ArrayList<ArrayList<Bond>> bondCache;
    private Atom[][] atomCache;
    private ForceField[] forceFieldCache;
    private Crystal[] crystalCache;
    private final double[] gyrations = new double[2];
    private double[][] bestBaseMandV = new double[3][4];
    private double[][] bestTargetMandV = new double[3][4];
    private double[] bestBaseRg = new double[3];
    private double[] bestTargetRg = new double[3];
    private SymOp baseSymOp;
    private SymOp[][] bestBaseSymOp;
    private SymOp targetSymOp;
    private SymOp[][] bestTargetSymOp;
    private ArrayList<SymOp> baseSymOps = new ArrayList();
    private ArrayList<Integer> baseDistMap = new ArrayList();
    private ArrayList<SymOp> targetSymOps = new ArrayList();
    private ArrayList<Integer> targetDistMap = new ArrayList();
    private double printSym;
    private final StringBuilder stringBuilder = new StringBuilder();
    private SymOp baseTransformSymOp;
    private SymOp targetTransformSymOp;
    private SymOp[][] bestBaseTransformSymOp;
    private SymOp[][] bestTargetTransformSymOp;
    private static final double MATCH_TOLERANCE = 1.0E-12;
    private static final double SYM_TOLERANCE = 2.0E-8;

    public ProgressiveAlignmentOfCrystals(SystemFilter baseFilter, SystemFilter targetFilter, boolean isSymmetric) {
        int i;
        this.baseFilter = baseFilter;
        this.targetFilter = targetFilter;
        this.isSymmetric = isSymmetric;
        this.baseSize = baseFilter.countNumModels();
        this.baseLabel = FilenameUtils.getName((String)baseFilter.getFile().getAbsolutePath());
        this.targetSize = targetFilter.countNumModels();
        this.targetLabel = FilenameUtils.getName((String)targetFilter.getFile().getAbsolutePath());
        assert (!isSymmetric || this.baseSize == this.targetSize);
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format("\n Conformations for %s: %d", this.baseLabel, this.baseSize));
            logger.finer(String.format(" Conformations for %s: %d", this.targetLabel, this.targetSize));
        }
        this.distRow = new double[this.targetSize];
        CompositeConfiguration properties = baseFilter.getActiveMolecularSystem().getProperties();
        this.useMPI = properties.getBoolean("pj.use.mpi", true);
        if (this.useMPI) {
            this.world = Comm.world();
            this.numProc = this.world.size();
            this.rank = this.world.rank();
        } else {
            this.world = null;
            this.numProc = 1;
            this.rank = 0;
        }
        int extra = this.targetSize % this.numProc;
        int paddedTargetSize = this.targetSize;
        if (extra != 0) {
            paddedTargetSize = this.targetSize - extra + this.numProc;
        }
        this.numWorkItems = paddedTargetSize / this.numProc;
        if (this.numProc > 1) {
            logger.info(String.format(" Number of MPI Processes:  %d", this.numProc));
            logger.info(String.format(" Rank of this MPI Process: %d", this.rank));
            logger.info(String.format(" Work per process per row: %d", this.numWorkItems));
        }
        Arrays.fill(this.distRow, -1.0);
        this.distances = new double[this.numProc][this.numWorkItems];
        for (i = 0; i < this.numProc; ++i) {
            Arrays.fill(this.distances[i], -2.0);
        }
        this.buffers = new DoubleBuf[this.numProc];
        for (i = 0; i < this.numProc; ++i) {
            this.buffers[i] = DoubleBuf.buffer((double[])this.distances[i]);
        }
        this.myDistances = this.distances[this.rank];
        this.myBuffer = this.buffers[this.rank];
    }

    /*
     * WARNING - void declaration
     */
    private double compare(File file1, String name1, List<Bond> bondList1, Atom[] atoms1, ForceField forceField1, File file2, String name2, List<Bond> bondList2, Atom[] atoms2, ForceField forceField2, int z1, int z2, int compareAtomsSize, int nAU, int baseSearchValue, int targetSearchValue, double matchTol, int compNum, boolean strict, int saveClusters, boolean machineLearning, int linkage, boolean inertia, boolean gyrationComponents) {
        double finalRMSD;
        int n;
        int i;
        double[][] minDiffs;
        void var46_48;
        double[][] minZdiffs;
        IndexIndexPair[][] minZinds;
        boolean reverse;
        boolean useSave = saveClusters > 0;
        boolean useSym = this.printSym >= 0.0;
        int nCoords = compareAtomsSize * 3;
        int nBaseMols = this.baseXYZ.length / nCoords;
        int nTargetMols = this.targetXYZ.length / nCoords;
        if (logger.isLoggable(Level.FINER)) {
            this.stringBuilder.append(String.format("\n Base: %s Target: %s", name1, name2));
            this.stringBuilder.append(String.format("\n Comparing %3d of %5d in base sphere.\n Comparing %3d of %5d in target sphere.\n", nAU, nBaseMols, nAU, nTargetMols));
        }
        if (useSym) {
            if (this.bestBaseSymOp == null || this.bestBaseSymOp.length != z1 || this.bestBaseSymOp[0].length != z2) {
                this.bestBaseSymOp = new SymOp[z1][z2];
            }
            if (this.bestTargetSymOp == null || this.bestTargetSymOp.length != z1 || this.bestTargetSymOp[0].length != z2) {
                this.bestTargetSymOp = new SymOp[z1][z2];
            }
            if (this.bestBaseTransformSymOp == null || this.bestBaseTransformSymOp.length != z1 || this.bestBaseTransformSymOp[0].length != z2) {
                this.bestBaseTransformSymOp = new SymOp[z1][z2];
            }
            if (this.bestTargetTransformSymOp == null || this.bestTargetTransformSymOp.length != z1 || this.bestTargetTransformSymOp[0].length != z2) {
                this.bestTargetTransformSymOp = new SymOp[z1][z2];
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            this.stringBuilder.append(" Prioritize target system.\n");
            this.stringBuilder.append(" Search conformations of each crystal:\n");
        }
        System.arraycopy(this.baseXYZ, this.baseAUDist[0].index() * nCoords, this.baseAU, 0, nCoords);
        this.tempListIndices.clear();
        this.numberUniqueAUs(this.baseXYZ, this.baseAUDist, (double[])this.baseAU.clone(), nCoords, baseSearchValue, strict, nBaseMols, this.massN, matchTol);
        int baseLength = this.tempListIndices.size();
        if (this.uniqueBase == null || this.uniqueBase.length != baseLength) {
            this.uniqueBase = new Integer[baseLength];
        }
        this.tempListIndices.toArray(this.uniqueBase);
        System.arraycopy(this.targetXYZ, this.targetAUDist[0].index() * nCoords, this.targetAU, 0, nCoords);
        this.tempListIndices.clear();
        this.numberUniqueAUs(this.targetXYZ, this.targetAUDist, (double[])this.targetAU.clone(), nCoords, targetSearchValue, strict, nTargetMols, this.massN, matchTol);
        int targetLength = this.tempListIndices.size();
        if (this.uniqueTarget == null || this.uniqueTarget.length != targetLength) {
            this.uniqueTarget = new Integer[targetLength];
        }
        this.tempListIndices.toArray(this.uniqueTarget);
        boolean bl = reverse = baseLength > targetLength;
        if (logger.isLoggable(Level.FINE)) {
            this.stringBuilder.append(String.format("\n  %d conformations detected out of %d in base crystal.\n  %d conformations detected out of %d in target crystal.\n", baseLength, baseSearchValue, targetLength, targetSearchValue));
        }
        if (useSym && (z1 > 1 || z2 > 1)) {
            this.stringBuilder.append("\n Utilizing Sym Ops with Z''>1. Attempting to map all unique structures.\n");
        }
        double min1 = Double.MAX_VALUE;
        double max1 = Double.MIN_VALUE;
        int minBIndex = -1;
        int minTIndex = -1;
        int maxBIndex = -1;
        int maxTIndex = -1;
        for (Object[] objectArray : minZinds = new IndexIndexPair[z1][z2]) {
            Arrays.fill(objectArray, new IndexIndexPair(-1, -1));
        }
        double[][] dArray = minZdiffs = new double[z1][z2];
        int n2 = dArray.length;
        boolean bl2 = false;
        while (var46_48 < n2) {
            double[] row = dArray[var46_48];
            Arrays.fill(row, Double.MAX_VALUE);
            ++var46_48;
        }
        for (double[] row : minDiffs = new double[baseLength][targetLength]) {
            Arrays.fill(row, Double.MAX_VALUE);
        }
        for (int i2 = 0; i2 < baseLength; ++i2) {
            int n3 = this.uniqueBase[i2];
            int baseInd = this.baseAUDist[n3].index();
            int currZ1 = this.baseDistMap.get(baseInd) % z1;
            double[] baseXYZ = new double[nCoords];
            for (int j = 0; j < targetLength; ++j) {
                System.arraycopy(this.baseXYZ, baseInd * nCoords, baseXYZ, 0, nCoords);
                int tIndex = this.uniqueTarget[j];
                int targetInd = this.targetAUDist[tIndex].index();
                int currZ2 = this.targetDistMap.get(targetInd) % z2;
                double[] targetXYZ = new double[nCoords];
                System.arraycopy(this.targetXYZ, targetInd * nCoords, targetXYZ, 0, nCoords);
                double[] tempTranB = Superpose.calculateTranslation(baseXYZ, this.massN);
                Superpose.applyTranslation(baseXYZ, tempTranB);
                double[] tempTranT = Superpose.calculateTranslation(targetXYZ, this.massN);
                Superpose.applyTranslation(targetXYZ, tempTranT);
                double[][] tempRotT = Superpose.calculateRotation(baseXYZ, targetXYZ, this.massN);
                Superpose.applyRotation(targetXYZ, tempRotT);
                double value = Superpose.rmsd(baseXYZ, targetXYZ, this.massN);
                if (logger.isLoggable(Level.FINEST)) {
                    this.stringBuilder.append(String.format("\n Comp %3d: Base %2d IND %3d (Z''=%2d) \t Target %2d IND %3d (Z''=%2d) Diff: %8.4f\n", j + i2 * targetLength, n3, baseInd, currZ1, tIndex, targetInd, currZ2, value));
                    if (useSym) {
                        this.stringBuilder.append(" Base Temp Translation: ").append(Arrays.toString(tempTranB)).append("\n");
                        this.stringBuilder.append(" Target Temp Translation: ").append(Arrays.toString(tempTranT));
                        this.stringBuilder.append(ProgressiveAlignmentOfCrystals.matrixToString(tempRotT, j + i2 * targetLength, "Temp Rot")).append("\n");
                    }
                }
                minDiffs[i2][j] = value;
                if (nAU == 1 && !strict) {
                    System.arraycopy(baseXYZ, 0, this.baseNAUs[0], 0, nAU * nCoords);
                    System.arraycopy(targetXYZ, 0, this.targetNAUs, 0, nAU * nCoords);
                    System.arraycopy(baseXYZ, 0, this.bestBaseNAUs[currZ1][currZ2], 0, nAU * nCoords);
                    System.arraycopy(targetXYZ, 0, this.bestTargetNAUs[currZ1][currZ2], 0, nAU * nCoords);
                }
                if (useSym && value < minZdiffs[currZ1][currZ2]) {
                    minZdiffs[currZ1][currZ2] = value;
                    minZinds[currZ1][currZ2] = new IndexIndexPair(baseInd, targetInd);
                    System.arraycopy(baseXYZ, 0, this.baseAU, 0, nCoords);
                    System.arraycopy(targetXYZ, 0, this.targetAU, 0, nCoords);
                    if (logger.isLoggable(Level.FINER)) {
                        this.stringBuilder.append(String.format("\n Base AU: %2d of %2d\t\tvs\t\t Target AU: %2d of %2d \t (%9.4f)", currZ1 + 1, z1, currZ2 + 1, z2, minZdiffs[currZ1][currZ2]));
                        if (logger.isLoggable(Level.FINER)) {
                            this.stringBuilder.append("\n Base Translation: ").append(Arrays.toString(tempTranB)).append("\n");
                            this.stringBuilder.append(" Target Translation: ").append(Arrays.toString(tempTranT));
                            this.stringBuilder.append(ProgressiveAlignmentOfCrystals.matrixToString(tempRotT, currZ1, "Target Rotation"));
                        }
                    }
                    this.bestBaseTransformSymOp[currZ1][currZ2] = this.baseTransformSymOp = new SymOp(SymOp.ZERO_ROTATION, tempTranB);
                    this.targetTransformSymOp = new SymOp(SymOp.ZERO_ROTATION, tempTranT);
                    this.bestTargetTransformSymOp[currZ1][currZ2] = this.targetTransformSymOp = this.targetTransformSymOp.append(new SymOp(tempRotT, SymOp.Tr_0_0_0));
                    SymOp base = this.baseSymOps.get(this.baseDistMap.get(minZinds[currZ1][currZ2].sortedIndex()));
                    this.baseSymOp = new SymOp(base.rot, base.tr);
                    SymOp target = this.targetSymOps.get(this.targetDistMap.get(minZinds[currZ1][currZ2].referenceIndex()));
                    this.targetSymOp = new SymOp(target.rot, target.tr);
                    this.bestBaseSymOp[currZ1][currZ2] = this.baseSymOp;
                    this.bestTargetSymOp[currZ1][currZ2] = this.targetSymOp;
                    if (logger.isLoggable(Level.FINEST)) {
                        this.stringBuilder.append("\n Base Sym Op Translation: ").append(Arrays.toString(this.bestBaseSymOp[currZ1][currZ2].tr));
                        this.stringBuilder.append(ProgressiveAlignmentOfCrystals.matrixToString(this.bestBaseSymOp[currZ1][currZ2].rot, currZ2 + currZ1 * z2, "Base Sym Op Rot")).append("\n");
                        this.stringBuilder.append(" Base Transform Translation: ").append(Arrays.toString(this.bestBaseTransformSymOp[currZ1][currZ2].tr));
                        this.stringBuilder.append(ProgressiveAlignmentOfCrystals.matrixToString(this.bestBaseTransformSymOp[currZ1][currZ2].rot, currZ2 + currZ1 * z2, "Base Transform Rot")).append("\n");
                        this.stringBuilder.append(" Target Sym Op Translation: ").append(Arrays.toString(this.bestTargetSymOp[currZ1][currZ2].tr));
                        this.stringBuilder.append(ProgressiveAlignmentOfCrystals.matrixToString(this.bestTargetSymOp[currZ1][currZ2].rot, currZ2 + currZ1 * z2, "Target Sym Op Rot")).append("\n");
                        this.stringBuilder.append(" Target Transform Translation: ").append(Arrays.toString(this.bestTargetTransformSymOp[currZ1][currZ2].tr));
                        this.stringBuilder.append(ProgressiveAlignmentOfCrystals.matrixToString(this.bestTargetTransformSymOp[currZ1][currZ2].rot, currZ2 + currZ1 * z2, "Target Transform Rot")).append("\n");
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        this.stringBuilder.append(String.format(" \n Saved %3d: Base %2d IND %3d (Z''=%2d) \t Target %2d IND %3d (Z''=%2d) Diff: %8.4f\n", j + i2 * targetLength, n3, baseInd, currZ1, tIndex, targetInd, currZ2, value));
                    }
                }
                if (minDiffs[i2][j] < min1) {
                    min1 = minDiffs[i2][j];
                    minBIndex = n3;
                    minTIndex = tIndex;
                }
                if (!(minDiffs[i2][j] > max1)) continue;
                max1 = minDiffs[i2][j];
                maxBIndex = n3;
                maxTIndex = tIndex;
            }
        }
        int baseBestZ = this.baseDistMap.get(this.baseAUDist[minBIndex].index()) % z1;
        int n4 = this.targetDistMap.get(this.targetAUDist[minTIndex].index()) % z2;
        if (logger.isLoggable(Level.FINER)) {
            this.stringBuilder.append(String.format("\n Base min index: %d (Z''=%d) Target min Index %d (Z''=%d)", minBIndex, baseBestZ, minTIndex, n4));
        }
        int maxLength = FastMath.max((int)baseLength, (int)targetLength);
        int[] baseTargetMap = new int[maxLength];
        if (reverse) {
            for (i = 0; i < baseLength; ++i) {
                double minValue = Double.MAX_VALUE;
                for (j = 0; j < targetLength; ++j) {
                    if (!(minValue > minDiffs[i][j])) continue;
                    minValue = minDiffs[i][j];
                    baseTargetMap[i] = this.uniqueTarget[j];
                }
            }
        } else {
            for (i = 0; i < targetLength; ++i) {
                double minValue = Double.MAX_VALUE;
                for (j = 0; j < baseLength; ++j) {
                    if (!(minValue > minDiffs[j][i])) continue;
                    minValue = minDiffs[j][i];
                    baseTargetMap[i] = this.uniqueBase[j];
                }
            }
        }
        if (nAU == 1 && !strict) {
            double targetGyration;
            double baseGyration;
            this.gyrations[0] = baseGyration = StructureMetrics.radiusOfGyration((double[])this.bestBaseNAUs[baseBestZ][n4].clone(), this.massN);
            this.gyrations[1] = targetGyration = StructureMetrics.radiusOfGyration((double[])this.bestTargetNAUs[baseBestZ][n4].clone(), this.massN);
            if (useSym) {
                int numAtomsPerMol1 = atoms1.length / z1;
                int numAtomsPerMol2 = atoms2.length / z2;
                boolean multisym = z1 > 1 || z2 > 1;
                StringBuilder alchemicalAtoms = null;
                StringBuilder alchemicalAtoms2 = null;
                StringBuilder separation = new StringBuilder();
                for (int i3 = 0; i3 < z1; ++i3) {
                    for (int j = 0; j < z2; ++j) {
                        separation.append("\n Atom Separation (A)  Description");
                        if (multisym) {
                            separation.append(String.format(" (Z1'' =%2d Z2'' =%2d)\n  Base: Target:  Distance:\n", i3 + 1, j + 1));
                        } else {
                            separation.append(" \n");
                        }
                        for (int k = 0; k < compareAtomsSize; ++k) {
                            int index = k * 3;
                            double value = Superpose.rmsd(new double[]{this.bestBaseNAUs[i3][j][index], this.bestBaseNAUs[i3][j][index + 1], this.bestBaseNAUs[i3][j][index + 2]}, new double[]{this.bestTargetNAUs[i3][j][index], this.bestTargetNAUs[i3][j][index + 1], this.bestTargetNAUs[i3][j][index + 2]}, this.massN);
                            if (!logger.isLoggable(Level.INFO) || !(this.printSym < value)) continue;
                            separation.append(String.format(" %4d %4d  %14.6f\n", i3 * numAtomsPerMol1 + this.comparisonAtoms[k] + 1, j * numAtomsPerMol2 + this.comparisonAtoms[k] + 1, value));
                            if (alchemicalAtoms == null) {
                                alchemicalAtoms = new StringBuilder();
                                if (multisym) {
                                    alchemicalAtoms.append(String.format(" %3d %3d  ", i3, j));
                                }
                                alchemicalAtoms.append(i3 * numAtomsPerMol1 + this.comparisonAtoms[k] + 1);
                                alchemicalAtoms2 = new StringBuilder();
                                if (multisym) {
                                    alchemicalAtoms2.append(String.format(" %3d %3d  ", i3, j));
                                }
                                alchemicalAtoms2.append(j * numAtomsPerMol2 + this.comparisonAtoms[k] + 1);
                                continue;
                            }
                            if (alchemicalAtoms.charAt(alchemicalAtoms.length() - 1) == '\n') {
                                alchemicalAtoms.append(String.format(" %3d %3d  ", i3, j)).append(i3 * numAtomsPerMol1 + this.comparisonAtoms[k] + 1);
                                alchemicalAtoms2.append(String.format(" %3d %3d  ", i3, j)).append(j * numAtomsPerMol2 + this.comparisonAtoms[k] + 1);
                                continue;
                            }
                            alchemicalAtoms.append(",").append(i3 * numAtomsPerMol1 + this.comparisonAtoms[k] + 1);
                            alchemicalAtoms2.append(",").append(j * numAtomsPerMol2 + this.comparisonAtoms[k] + 1);
                        }
                        if (useSave) {
                            if (machineLearning) {
                                this.saveAssembly(file1, name1, bondList1, atoms1, forceField1, this.bestBaseNAUs[i3][j], this.comparisonAtoms, nAU, "_c1", 0.0, compNum, saveClusters);
                                this.saveAssembly(file2, name2, bondList2, atoms2, forceField2, this.bestTargetNAUs[i3][j], this.comparisonAtoms, nAU, "_c2", min1, compNum, saveClusters);
                            } else {
                                this.saveAssembly(file1, name1, bondList1, atoms1, forceField1, this.bestBaseNAUs[i3][j], this.comparisonAtoms, nAU, "_c1", compNum, saveClusters);
                                this.saveAssembly(file2, name2, bondList2, atoms2, forceField2, this.bestTargetNAUs[i3][j], this.comparisonAtoms, nAU, "_c2", compNum, saveClusters);
                            }
                        }
                        if (alchemicalAtoms == null) continue;
                        alchemicalAtoms.append("\n");
                        alchemicalAtoms2.append("\n");
                    }
                }
                if (alchemicalAtoms != null) {
                    this.stringBuilder.append((CharSequence)separation);
                    this.stringBuilder.append("\n Suggested Alchemical Atoms:\n");
                    if (multisym) {
                        this.stringBuilder.append(" Base: (").append(this.baseLabel).append(")\n");
                    }
                    this.stringBuilder.append((CharSequence)alchemicalAtoms).append("\n");
                    if (multisym) {
                        this.stringBuilder.append(" Target: (").append(this.targetLabel).append(")\n").append((CharSequence)alchemicalAtoms2).append("\n");
                    }
                }
                if (logger.isLoggable(Level.FINE)) {
                    this.stringBuilder.append(String.format("\n Max RMSD: %9.4f B Index: %d T Index: %d\n", max1, maxBIndex, maxTIndex));
                }
            }
            if (useSave && !useSym) {
                if (machineLearning) {
                    this.saveAssembly(file1, name1, bondList1, atoms1, forceField1, this.bestBaseNAUs[baseBestZ][n4], this.comparisonAtoms, nAU, "_c1", 0.0, compNum, saveClusters);
                    this.saveAssembly(file2, name2, bondList2, atoms2, forceField2, this.bestTargetNAUs[baseBestZ][n4], this.comparisonAtoms, nAU, "_c2", min1, compNum, saveClusters);
                } else {
                    this.saveAssembly(file1, name1, bondList1, atoms1, forceField1, this.bestBaseNAUs[baseBestZ][n4], this.comparisonAtoms, nAU, "_c1", compNum, saveClusters);
                    this.saveAssembly(file2, name2, bondList2, atoms2, forceField2, this.bestTargetNAUs[baseBestZ][n4], this.comparisonAtoms, nAU, "_c2", compNum, saveClusters);
                }
            }
            if (logger.isLoggable(Level.FINER) && useSym) {
                for (int i4 = 0; i4 < z1; ++i4) {
                    for (int j = 0; j < z2; ++j) {
                        this.printSym(compareAtomsSize, file2, name2, bondList2, atoms2, forceField2, saveClusters, j);
                    }
                }
            }
            return min1;
        }
        if (logger.isLoggable(Level.FINER)) {
            this.stringBuilder.append(" Minimum RMSD_1 Between Unique Base and Target AUs:\n i  j (bInd tInd) RMSD_1\n");
            for (i = 0; i < baseLength; ++i) {
                for (int j = 0; j < targetLength; ++j) {
                    this.stringBuilder.append(String.format(" %d %d (%4d %4d) %4.4f\n", i, j, this.baseAUDist[this.uniqueBase[i]].index(), this.targetAUDist[this.uniqueTarget[j]].index(), minDiffs[i][j]));
                }
            }
        }
        double bestRMSD = Double.MAX_VALUE;
        for (double[] row : minZdiffs) {
            Arrays.fill(row, Double.MAX_VALUE);
        }
        if (logger.isLoggable(Level.FINE)) {
            this.stringBuilder.append(String.format("\n  Trial     RMSD_1 (%8s)  RMSD_3 (%8s)  %8s  G(r1)    G(r2)\n", this.rmsdLabel, this.rmsdLabel, this.rmsdLabel));
        }
        this.baseAUDist_2 = new DoubleIndexPair[nBaseMols];
        this.targetAUDist_2 = new DoubleIndexPair[nTargetMols];
        int currentComparison = 1;
        for (int l = 0; l < baseLength; ++l) {
            int bIndex = this.uniqueBase[l];
            int baseInd = this.baseAUDist[bIndex].index();
            int currZ1 = this.baseDistMap.get(baseInd) % z1;
            if (l > 0) {
                System.arraycopy(this.baseXYZoriginal, 0, this.baseXYZ, 0, this.baseXYZoriginal.length);
            }
            ProgressiveAlignmentOfCrystals.prioritizeReplicates(this.baseXYZ, this.baseCoM[0], compareAtomsSize, this.baseAUDist_2, baseInd, linkage);
            int baseAUIndex = this.baseAUDist_2[0].index() * nCoords;
            System.arraycopy(this.baseXYZ, baseAUIndex, this.baseAU, 0, nCoords);
            for (int i5 = 0; i5 < 4; ++i5) {
                for (int j = 0; j < nAU; ++j) {
                    int molIndex = this.baseAUDist_2[j].index() * nCoords;
                    System.arraycopy(this.baseXYZ, molIndex, this.baseNAUs[i5], j * nCoords, nCoords);
                }
            }
            double[] translation = Superpose.calculateTranslation(this.baseAU, this.massN);
            Superpose.applyTranslation(this.baseAU, translation);
            Superpose.applyTranslation(this.baseNAUs[1], translation);
            Superpose.applyTranslation(this.baseNAUs[2], translation);
            Superpose.applyTranslation(this.baseNAUs[3], translation);
            Superpose.applyTranslation(this.baseXYZ, translation);
            ProgressiveAlignmentOfCrystals.centerOfMass(this.baseCoM[1], this.baseXYZ, this.massN, this.massSum, compareAtomsSize);
            if (useSym) {
                this.baseTransformSymOp = new SymOp(SymOp.ZERO_ROTATION, SymOp.Tr_0_0_0);
                SymOp base = this.baseSymOps.get(baseInd);
                this.baseSymOp = new SymOp(base.rot, base.tr);
                this.baseTransformSymOp = this.baseTransformSymOp.append(new SymOp(SymOp.ZERO_ROTATION, translation));
                if (logger.isLoggable(Level.FINEST)) {
                    this.stringBuilder.append(String.format("\n Base %d (%2d) to Origin Translation: ", l, bIndex)).append(Arrays.toString(translation)).append("\n");
                }
            }
            if (logger.isLoggable(Level.FINEST)) {
                this.stringBuilder.append("\n Base 3 Conformations:\n");
            }
            for (int i6 = 0; i6 < 3; ++i6) {
                int baseIndex = this.baseAUDist_2[i6].index() * nCoords;
                System.arraycopy(this.baseXYZ, baseIndex, this.base3AUs, i6 * nCoords, nCoords);
            }
            translation = Superpose.calculateTranslation(this.base3AUs, this.massN);
            Superpose.applyTranslation(this.base3AUs, translation);
            Superpose.applyTranslation(this.baseNAUs[2], translation);
            Superpose.applyTranslation(this.baseNAUs[3], translation);
            Superpose.applyTranslation(this.baseXYZ, translation);
            ProgressiveAlignmentOfCrystals.centerOfMass(this.baseCoM[2], this.baseXYZ, this.massN, this.massSum, compareAtomsSize);
            if (useSym) {
                this.baseTransformSymOp = this.baseTransformSymOp.append(new SymOp(SymOp.ZERO_ROTATION, translation));
                if (logger.isLoggable(Level.FINEST)) {
                    this.stringBuilder.append(String.format("\n Base %d (%2d) 2nd Translation: ", l, bIndex)).append(Arrays.toString(translation)).append("\n");
                }
            }
            double maxDist = this.baseAUDist[this.baseAUDist.length - 1].doubleValue();
            if (logger.isLoggable(Level.FINEST)) {
                this.stringBuilder.append(String.format("\n System 1 farthest distance: %4.8f", FastMath.sqrt((double)maxDist)));
            }
            for (int i7 = 0; i7 < nAU; ++i7) {
                int molIndex = this.baseAUDist_2[i7].index() * nCoords;
                System.arraycopy(this.baseXYZ, molIndex, this.baseNAUs[3], i7 * nCoords, nCoords);
            }
            translation = Superpose.calculateTranslation(this.baseNAUs[3], this.massN);
            Superpose.applyTranslation(this.baseNAUs[3], translation);
            Superpose.applyTranslation(this.baseXYZ, translation);
            if (useSym) {
                this.baseTransformSymOp = this.baseTransformSymOp.append(new SymOp(SymOp.ZERO_ROTATION, translation));
                if (logger.isLoggable(Level.FINEST)) {
                    this.stringBuilder.append(String.format("\n Base %d (%2d) Final Translation: ", l, bIndex)).append(Arrays.toString(translation)).append("\n");
                }
            }
            for (int m = 0; m < targetLength; ++m) {
                int tIndex = this.uniqueTarget[m];
                int targetInd = this.targetAUDist[tIndex].index();
                int currZ2 = this.targetDistMap.get(targetInd) % z2;
                if (!strict && (reverse || baseTargetMap[m] != bIndex) && (!reverse || baseTargetMap[l] != tIndex)) continue;
                System.arraycopy(this.targetXYZoriginal, 0, this.targetXYZ, 0, this.targetXYZoriginal.length);
                ProgressiveAlignmentOfCrystals.prioritizeReplicates(this.targetXYZ, this.targetCoM, compareAtomsSize, this.targetAUDist_2, targetInd, linkage);
                System.arraycopy(this.targetXYZ, this.targetAUDist_2[0].index() * nCoords, this.targetAU, 0, nCoords);
                translation = Superpose.calculateTranslation(this.targetAU, this.massN);
                Superpose.applyTranslation(this.targetAU, translation);
                Superpose.applyTranslation(this.targetXYZ, translation);
                double[][] rotation = Superpose.calculateRotation(this.baseAU, this.targetAU, this.massN);
                Superpose.applyRotation(this.targetAU, rotation);
                Superpose.applyRotation(this.targetXYZ, rotation);
                ProgressiveAlignmentOfCrystals.centerOfMass(this.targetCoM, this.targetXYZ, this.massN, this.massSum, compareAtomsSize);
                if (useSym) {
                    this.targetTransformSymOp = new SymOp(SymOp.ZERO_ROTATION, SymOp.Tr_0_0_0);
                    SymOp target = this.targetSymOps.get(targetInd);
                    this.targetSymOp = new SymOp(target.rot, target.tr);
                    this.targetTransformSymOp = this.targetTransformSymOp.append(new SymOp(SymOp.ZERO_ROTATION, translation)).append(new SymOp(rotation, SymOp.Tr_0_0_0));
                    if (logger.isLoggable(Level.FINEST)) {
                        this.stringBuilder.append(ProgressiveAlignmentOfCrystals.matrixToString(this.baseSymOp.rot, bIndex, "Base Sym Rot"));
                        this.stringBuilder.append(String.format("\n Base %d Sym Op Translation: ", bIndex)).append(Arrays.toString(this.baseSymOp.tr)).append("\n");
                        this.stringBuilder.append(ProgressiveAlignmentOfCrystals.matrixToString(this.targetSymOp.rot, tIndex, "Target Sym Rot"));
                        this.stringBuilder.append(String.format("\n Target %d Sym Op Translation: ", tIndex)).append(Arrays.toString(this.targetSymOp.tr)).append("\n");
                        this.stringBuilder.append(String.format("\n Trans target %d (%2d) sys to origin: \n\t", m, tIndex)).append(Arrays.toString(translation)).append("\n");
                        this.stringBuilder.append(ProgressiveAlignmentOfCrystals.matrixToString(rotation, tIndex, "1st Rot"));
                    }
                }
                this.pairEntities(FastMath.max((int)3, (int)nAU), 1);
                double checkRMSD1 = -3.0;
                double n1RMSD = -4.0;
                if (logger.isLoggable(Level.FINE)) {
                    checkRMSD1 = Superpose.rmsd(this.baseAU, this.targetAU, this.massN);
                    for (int i2 = 0; i2 < nAU; ++i2) {
                        int offset = i2 * nCoords;
                        int molIndex = this.pairedAUs[i2].index() * nCoords;
                        System.arraycopy(this.targetXYZ, molIndex, this.targetNAUs, offset, nCoords);
                    }
                    n1RMSD = Superpose.rmsd(this.baseNAUs[1], this.targetNAUs, this.massN);
                    if (logger.isLoggable(Level.FINEST) && useSave) {
                        this.saveAssembly(file1, name1, bondList1, atoms1, forceField1, this.baseAU, this.comparisonAtoms, 1, "_c1_1", compNum, saveClusters);
                        this.saveAssembly(file1, name1, bondList1, atoms1, forceField1, this.baseNAUs[1], this.comparisonAtoms, nAU, "_c1_1N", compNum, saveClusters);
                        this.saveAssembly(file2, name2, bondList2, atoms2, forceField2, this.targetAU, this.comparisonAtoms, 1, "_c2_1", compNum, saveClusters);
                        this.saveAssembly(file2, name2, bondList2, atoms2, forceField2, this.targetNAUs, this.comparisonAtoms, nAU, "_c2_1N", compNum, saveClusters);
                    }
                }
                for (int i8 = 0; i8 < 3; ++i8) {
                    int targetIndex = this.pairedAUs[i8].index() * nCoords;
                    int coordIndex = i8 * nCoords;
                    System.arraycopy(this.targetXYZ, targetIndex, this.target3AUs, coordIndex, nCoords);
                }
                translation = Superpose.calculateTranslation(this.target3AUs, this.massN);
                Superpose.applyTranslation(this.target3AUs, translation);
                Superpose.applyTranslation(this.targetNAUs, translation);
                Superpose.applyTranslation(this.targetXYZ, translation);
                rotation = Superpose.calculateRotation(this.base3AUs, this.target3AUs, this.massN);
                Superpose.applyRotation(this.target3AUs, rotation);
                Superpose.applyRotation(this.targetNAUs, rotation);
                Superpose.applyRotation(this.targetXYZ, rotation);
                ProgressiveAlignmentOfCrystals.centerOfMass(this.targetCoM, this.targetXYZ, this.massN, this.massSum, compareAtomsSize);
                if (useSym) {
                    Superpose.applyTranslation(this.targetAU, translation);
                    Superpose.applyRotation(this.targetAU, rotation);
                    this.targetTransformSymOp = this.targetTransformSymOp.append(new SymOp(SymOp.ZERO_ROTATION, translation)).append(new SymOp(rotation, SymOp.Tr_0_0_0));
                    if (logger.isLoggable(Level.FINEST)) {
                        this.stringBuilder.append(String.format("\n Target %d (%2d) 2nd Translation/Rotation: ", m, tIndex)).append(Arrays.toString(translation)).append("\n");
                        this.printSym(compareAtomsSize, file2, name2, bondList2, atoms2, forceField2, saveClusters, currZ2);
                    }
                }
                double checkRMSD2 = -5.0;
                double n3RMSD = -6.0;
                if (logger.isLoggable(Level.FINE)) {
                    checkRMSD2 = Superpose.rmsd(this.base3AUs, this.target3AUs, this.massN);
                    n3RMSD = Superpose.rmsd(this.baseNAUs[2], this.targetNAUs, this.massN);
                    if (logger.isLoggable(Level.FINEST) && useSave) {
                        this.saveAssembly(file1, name1, bondList1, atoms1, forceField1, this.base3AUs, this.comparisonAtoms, 3, "_c1_3", compNum, saveClusters);
                        this.saveAssembly(file1, name1, bondList1, atoms1, forceField1, this.baseNAUs[2], this.comparisonAtoms, nAU, "_c1_3N", compNum, saveClusters);
                        this.saveAssembly(file2, name2, bondList2, atoms2, forceField2, this.target3AUs, this.comparisonAtoms, 3, "_c2_3", compNum, saveClusters);
                        this.saveAssembly(file2, name2, bondList2, atoms2, forceField2, this.targetNAUs, this.comparisonAtoms, nAU, "_c2_3N", compNum, saveClusters);
                    }
                }
                this.pairEntities(nAU, 2);
                for (int i9 = 0; i9 < nAU; ++i9) {
                    int offset = i9 * nCoords;
                    int molIndex = this.pairedAUs[i9].index() * nCoords;
                    System.arraycopy(this.targetXYZ, molIndex, this.targetNAUs, offset, nCoords);
                }
                translation = Superpose.calculateTranslation(this.targetNAUs, this.massN);
                Superpose.applyTranslation(this.targetNAUs, translation);
                Superpose.applyTranslation(this.targetXYZ, translation);
                rotation = Superpose.calculateRotation(this.baseNAUs[3], this.targetNAUs, this.massN);
                if (useSym) {
                    Superpose.applyTranslation(this.targetAU, translation);
                    Superpose.applyRotation(this.targetAU, rotation);
                    this.targetTransformSymOp = this.targetTransformSymOp.append(new SymOp(SymOp.ZERO_ROTATION, translation)).append(new SymOp(rotation, SymOp.Tr_0_0_0));
                    if (logger.isLoggable(Level.FINEST)) {
                        this.stringBuilder.append(ProgressiveAlignmentOfCrystals.matrixToString(rotation, bIndex, "Target System Final Rotation"));
                        this.stringBuilder.append(String.format("\n Target %d Final Translation: ", bIndex)).append(Arrays.toString(translation)).append("\n");
                        this.printSym(compareAtomsSize, file2, name2, bondList2, atoms2, forceField2, saveClusters, currZ2);
                    }
                }
                if (logger.isLoggable(Level.FINEST) && useSave) {
                    this.saveAssembly(file1, name1, bondList1, atoms1, forceField1, this.baseNAUs[3], this.comparisonAtoms, nAU, "_c1_N", compNum, saveClusters);
                    this.saveAssembly(file2, name2, bondList2, atoms2, forceField2, this.targetNAUs, this.comparisonAtoms, nAU, "_c2_N", compNum, saveClusters);
                }
                Superpose.applyRotation(this.targetNAUs, rotation);
                Superpose.applyRotation(this.targetXYZ, rotation);
                double rmsdSymOp = Superpose.rmsd(this.baseNAUs[3], this.targetNAUs, this.massN);
                if (logger.isLoggable(Level.FINEST) && useSave) {
                    this.saveAssembly(file1, name1, bondList1, atoms1, forceField1, this.baseNAUs[3], this.comparisonAtoms, nAU, "_c1_N2", compNum, saveClusters);
                    this.saveAssembly(file2, name2, bondList2, atoms2, forceField2, this.targetNAUs, this.comparisonAtoms, nAU, "_c2_N2", compNum, saveClusters);
                }
                double baseGyration = StructureMetrics.radiusOfGyration(this.baseNAUs[3], this.massN);
                double targetGyration = StructureMetrics.radiusOfGyration(this.targetNAUs, this.massN);
                if (logger.isLoggable(Level.FINE)) {
                    int totalComparisons = strict ? baseLength * targetLength : maxLength;
                    Object output = String.format(" %2d of %2d: %7.4f (%8.4f) %7.4f (%8.4f) %8.4f %8.4f %8.4f", currentComparison, totalComparisons, checkRMSD1, n1RMSD, checkRMSD2, n3RMSD, rmsdSymOp, baseGyration, targetGyration);
                    if (logger.isLoggable(Level.FINER)) {
                        output = reverse ? (String)output + String.format(" b: %2d t: %2d bt: %2d", this.baseAUDist[bIndex].index(), this.targetAUDist[this.uniqueTarget[m]].index(), this.targetAUDist[baseTargetMap[m]].index()) : (String)output + String.format(" b: %2d t: %2d tb: %2d", this.baseAUDist[bIndex].index(), this.targetAUDist[this.uniqueTarget[m]].index(), this.baseAUDist[baseTargetMap[m]].index());
                    }
                    this.stringBuilder.append((String)output).append("\n");
                }
                if (useSym && rmsdSymOp < minZdiffs[currZ1][currZ2]) {
                    minZdiffs[currZ1][currZ2] = rmsdSymOp;
                    this.bestTargetTransformSymOp[currZ1][currZ2] = new SymOp(this.targetTransformSymOp.rot, this.targetTransformSymOp.tr);
                    this.bestTargetSymOp[currZ1][currZ2] = new SymOp(this.targetSymOp.rot, this.targetSymOp.tr);
                    this.bestBaseSymOp[currZ1][currZ2] = new SymOp(this.baseSymOp.rot, this.baseSymOp.tr);
                    this.bestBaseTransformSymOp[currZ1][currZ2] = new SymOp(this.baseTransformSymOp.rot, this.baseTransformSymOp.tr);
                }
                if (rmsdSymOp < bestRMSD) {
                    this.gyrations[0] = baseGyration;
                    this.gyrations[1] = targetGyration;
                    bestRMSD = rmsdSymOp;
                    baseBestZ = currZ1;
                    n = currZ2;
                    System.arraycopy(this.baseNAUs[3], 0, this.bestBaseNAUs[currZ1][currZ2], 0, nAU * nCoords);
                    System.arraycopy(this.targetNAUs, 0, this.bestTargetNAUs[currZ1][currZ2], 0, nAU * nCoords);
                }
                ++currentComparison;
            }
        }
        if (bestRMSD < Double.MAX_VALUE) {
            finalRMSD = bestRMSD;
        } else {
            this.stringBuilder.append(" This RMSD was filtered out! Try the --st flag or increasing --if.\n");
            finalRMSD = -7.0;
        }
        if (nAU == 1 && FastMath.abs((double)(min1 - finalRMSD)) > 1.0E-12) {
            this.stringBuilder.append(String.format(" WARNING: Single molecule overlay (%8.4f) does not match PAC RMSD_1 (%8.4f)", min1, finalRMSD));
        }
        if (useSave) {
            if (machineLearning) {
                this.saveAssembly(file1, name1, bondList1, atoms1, forceField1, this.bestBaseNAUs[baseBestZ][n], this.comparisonAtoms, nAU, "_c1", 0.0, compNum, saveClusters);
                this.saveAssembly(file2, name2, bondList2, atoms2, forceField2, this.bestTargetNAUs[baseBestZ][n], this.comparisonAtoms, nAU, "_c2", finalRMSD, compNum, saveClusters);
            } else {
                this.saveAssembly(file1, name1, bondList1, atoms1, forceField1, this.bestBaseNAUs[baseBestZ][n], this.comparisonAtoms, nAU, "_c1", compNum, saveClusters);
                this.saveAssembly(file2, name2, bondList2, atoms2, forceField2, this.bestTargetNAUs[baseBestZ][n], this.comparisonAtoms, nAU, "_c2", compNum, saveClusters);
            }
        }
        if (inertia) {
            this.bestBaseMandV = StructureMetrics.momentsOfInertia(this.bestBaseNAUs[baseBestZ][n], this.massN, false, false, true);
            this.bestTargetMandV = StructureMetrics.momentsOfInertia(this.bestTargetNAUs[baseBestZ][n], this.massN, false, false, true);
        }
        if (gyrationComponents) {
            this.bestBaseRg = StructureMetrics.radiusOfGyrationComponents(this.bestBaseNAUs[baseBestZ][n], this.massN, true);
            this.bestTargetRg = StructureMetrics.radiusOfGyrationComponents(this.bestTargetNAUs[baseBestZ][n], this.massN, true);
        }
        return finalRMSD;
    }

    public RunningStatistics comparisons(int nAU, double inflationFactor, double matchTol, double hitTol, int zPrime, int zPrime2, String excludeAtomsA, String excludeAtomsB, boolean alphaCarbons, boolean includeHydrogen, boolean massWeighted, int crystalPriority, boolean strict, int saveClusters, double save, boolean restart, boolean write, boolean machineLearning, boolean inertia, boolean gyrationComponents, int linkage, double printSym, boolean lowMemory, boolean createFE, boolean writeSym, String pacFileName, StringBuilder symOpsA, StringBuilder symOpsB) {
        int n;
        boolean useSym;
        RunningStatistics runningStatistics;
        this.printSym = printSym;
        if (restart) {
            runningStatistics = this.readMatrix(pacFileName);
            if (runningStatistics == null) {
                runningStatistics = new RunningStatistics();
            }
        } else {
            runningStatistics = new RunningStatistics();
            File file = new File(pacFileName);
            if (file.exists() && file.delete()) {
                logger.info(String.format(" PAC RMSD file (%s) was deleted.", pacFileName));
                logger.info(" To restart from a previous run, use the '-r' flag.");
            }
        }
        for (int row = 0; row < this.restartRow; ++row) {
            this.baseFilter.readNext(false, false, row + 1 >= this.restartRow);
        }
        MolecularAssembly baseAssembly = this.baseFilter.getActiveMolecularSystem();
        Atom[] atoms1 = baseAssembly.getAtomArray();
        int nAtoms = atoms1.length;
        MolecularAssembly targetAssembly = this.targetFilter.getActiveMolecularSystem();
        Atom[] atoms2 = targetAssembly.getAtomArray();
        int nAtoms2 = atoms2.length;
        ArrayList<Integer> unique = new ArrayList<Integer>(StringUtils.parseAtomRanges((String)"Base Assembly", (String)excludeAtomsA, (int)nAtoms));
        if (ProgressiveAlignmentOfCrystals.invalidAtomSelection(unique, atoms1, alphaCarbons, includeHydrogen)) {
            logger.warning("\n No atoms were selected for the PAC RMSD in first crystal.");
            return runningStatistics;
        }
        int[] comparisonAtoms = unique.stream().mapToInt(i -> i).toArray();
        List<MSNode> bondedEntities = baseAssembly.getNodeList();
        int z1 = zPrime > 0 ? zPrime : ProgressiveAlignmentOfCrystals.guessZPrime(unique, baseAssembly.getMoleculeNumbers(), bondedEntities.size());
        unique = new ArrayList(StringUtils.parseAtomRanges((String)"target", (String)excludeAtomsB, (int)nAtoms2));
        if (ProgressiveAlignmentOfCrystals.invalidAtomSelection(unique, atoms2, alphaCarbons, includeHydrogen)) {
            logger.warning("\n No atoms were selected for the PAC RMSD in second crystal.");
            return runningStatistics;
        }
        int[] comparisonAtoms2 = unique.stream().mapToInt(i -> i).toArray();
        List<MSNode> bondedEntities2 = targetAssembly.getAllBondedEntities();
        int z2 = zPrime2 > 0 ? zPrime2 : ProgressiveAlignmentOfCrystals.guessZPrime(unique, targetAssembly.getMoleculeNumbers(), bondedEntities2.size());
        int compareAtomsSize = comparisonAtoms.length;
        int compareAtomsSize2 = comparisonAtoms2.length;
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format(" Z'1: %2d Z'2: %2d\nBase Compare Size: %2d Target Compare Size: %2d", z1, z2, compareAtomsSize, compareAtomsSize2));
        }
        if (z1 > 1) {
            compareAtomsSize /= z1;
        }
        if (z2 > 1) {
            compareAtomsSize2 /= z2;
        }
        if (z1 != z2) {
            logger.warning(String.format(" Z1 (%2d) does not equal Z2 (%2d).", z1, z2));
        }
        boolean bl = useSym = printSym >= 0.0;
        if (useSym && (z1 > 1 || z2 > 1)) {
            matchTol = 2.0E-8;
        }
        if (useSym && z1 != z2) {
            logger.warning(" Comparisons to determine symmetry should have the same number of molecules in the asymmetric unit.");
        }
        Crystal baseCrystal = baseAssembly.getCrystal().getUnitCell();
        Crystal targetCrystal = this.targetFilter.getActiveMolecularSystem().getCrystal().getUnitCell();
        int baseSearchValue = baseCrystal.spaceGroup.respectsChirality() ? z1 : 2 * z1;
        int targetSearchValue = targetCrystal.spaceGroup.respectsChirality() ? z2 : 2 * z2;
        int nCoords = compareAtomsSize * 3;
        if (this.comparisonAtoms == null || this.comparisonAtoms.length != compareAtomsSize) {
            this.comparisonAtoms = new int[compareAtomsSize];
            System.arraycopy(comparisonAtoms, 0, this.comparisonAtoms, 0, compareAtomsSize);
        }
        int massIndex = 0;
        double[] mass = new double[compareAtomsSize];
        int[] nArray = this.comparisonAtoms;
        int n2 = nArray.length;
        for (n = 0; n < n2; ++n) {
            Integer value = nArray[n];
            Atom atom = atoms1[value];
            double m = atom.getMass();
            mass[massIndex++] = massWeighted ? m : 1.0;
        }
        massIndex = 0;
        double[] mass2 = new double[compareAtomsSize2];
        int[] nArray2 = comparisonAtoms2;
        n = nArray2.length;
        for (int value = 0; value < n; ++value) {
            Integer value2 = nArray2[value];
            if (massIndex == compareAtomsSize2) break;
            Atom atom = atoms2[value2];
            double m = atom.getMass();
            mass2[massIndex++] = massWeighted ? m : 1.0;
        }
        if (!Arrays.equals(mass, mass2)) {
            logger.warning(" Mass arrays do not match. Check atom ordering or size.");
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format(" Number Base Masses: %2d Number Target Masses: %2d\n Checking %2d masses from both systems.", mass.length, mass2.length, compareAtomsSize));
                for (int i2 = 0; i2 < compareAtomsSize; ++i2) {
                    if (mass[i2] == mass2[i2]) continue;
                    logger.fine(String.format(" Index: %d Mass 1: %4.4f Mass 2: %4.4f", i2 + 1, mass[i2], mass2[i2]));
                }
            }
        }
        if (this.massN == null) {
            this.massN = nAU > 3 ? new double[compareAtomsSize * nAU] : new double[compareAtomsSize * 3];
            for (int i3 = 0; i3 < nAU; ++i3) {
                System.arraycopy(mass, 0, this.massN, i3 * compareAtomsSize, compareAtomsSize);
            }
        }
        if (this.massSum == 0.0) {
            for (int i4 = 0; i4 < compareAtomsSize; ++i4) {
                this.massSum += this.massN[i4];
            }
        }
        if (machineLearning) {
            saveClusters = 1;
        }
        if (saveClusters > 2) {
            saveClusters = 0;
            logger.info(" Save flag specified incorrectly (1:PDB; 2:XYZ). Not saving files.");
        }
        if (logger.isLoggable(Level.FINER)) {
            if (linkage == 0) {
                logger.finer(" Single linkage will be used.");
            } else if (linkage == 2) {
                logger.finer(" Complete linkage will be used.");
            } else if (linkage == 1) {
                logger.finer(" Average linkage will be used.");
            }
        }
        if (linkage != 1 && linkage != 0 && linkage != 2) {
            logger.warning("Prioritization method specified incorrectly (--pm {0, 1, 2}). Using default of average linkage.");
            linkage = 1;
        }
        if (compareAtomsSize == 0 || compareAtomsSize2 == 0) {
            logger.severe(" No atoms were selected for comparison.");
            return runningStatistics;
        }
        logger.info(String.format("\n %d atoms will be used for the PAC RMSD out of %d in first crystal.", compareAtomsSize * z1, nAtoms));
        logger.info(String.format(" %d atoms will be used for the PAC RMSD out of %d in second crystal.\n", compareAtomsSize2 * z2, nAtoms2));
        this.rmsdLabel = String.format("RMSD_%d", nAU);
        double minTime = Double.MAX_VALUE;
        double maxTime = -4.9E-324;
        if (!lowMemory) {
            int size = (int)FastMath.ceil((double)((double)this.targetSize / (double)this.numProc));
            this.atomCache = new Atom[size][nAtoms2];
            this.fileCache = new File[size];
            this.nameCache = new String[size];
            this.bondCache = new ArrayList();
            for (int i5 = 0; i5 < size; ++i5) {
                this.bondCache.add(new ArrayList());
            }
            this.forceFieldCache = new ForceField[size];
            this.crystalCache = new Crystal[size];
            for (int column = this.restartColumn; column < this.targetSize; ++column) {
                int targetRank = column % this.numProc;
                if (targetRank == this.rank) {
                    int assemblyNum = column / this.numProc;
                    MolecularAssembly currentAssembly = this.targetFilter.getActiveMolecularSystem();
                    Atom[] arrayAtom = currentAssembly.getAtomArray();
                    int atomSize = arrayAtom.length;
                    for (int i6 = 0; i6 < atomSize; ++i6) {
                        double[] xyz = new double[3];
                        arrayAtom[i6].getXYZ(xyz);
                        this.atomCache[assemblyNum][i6] = new Atom(i6, arrayAtom[i6].getName(), arrayAtom[i6].getAtomType(), xyz);
                    }
                    List<Bond> currentBonds = currentAssembly.getBondList();
                    List currentBondCache = this.bondCache.get(assemblyNum);
                    for (Bond b : currentBonds) {
                        if (currentBondCache.contains(b)) continue;
                        currentBondCache.add(b);
                    }
                    ForceField currentForcefield = currentAssembly.getForceField();
                    this.fileCache[assemblyNum] = new File(currentAssembly.getFile().getName());
                    this.forceFieldCache[assemblyNum] = new ForceField(currentForcefield.getProperties());
                    this.nameCache[assemblyNum] = currentAssembly.getName();
                    Crystal cXtal = currentAssembly.getCrystal().getUnitCell();
                    this.crystalCache[assemblyNum] = new Crystal(cXtal.a, cXtal.b, cXtal.c, cXtal.alpha, cXtal.beta, cXtal.gamma, cXtal.spaceGroup.pdbName);
                }
                this.targetFilter.readNext(false, false, (column + 1) % this.numProc == this.rank);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            Resources.logResources();
        }
        File saveLocation1 = new File(FilenameUtils.removeExtension((String)baseAssembly.getFile().getAbsoluteFile().getAbsolutePath()) + "_lt1_" + save + ".arc");
        File saveLocation2 = new File(FilenameUtils.removeExtension((String)targetAssembly.getFile().getAbsoluteFile().getAbsolutePath()) + "_lt2_" + save + ".arc");
        if (save >= 0.0) {
            logger.info(String.format(" Saving trajectories less than %7.4f to :\n %s\n %s", save, saveLocation1.getName(), saveLocation2.getName()));
        }
        File feDirectory = null;
        if (createFE && !(feDirectory = new File(FilenameUtils.removeExtension((String)baseAssembly.getFile().getAbsoluteFile().getParent()) + File.separator + "FE" + File.separator)).exists()) {
            try {
                if (feDirectory.mkdir()) {
                    logger.info(String.format(" Base directory: %s", baseAssembly.getFile().getAbsoluteFile().getParent()));
                    logger.info(String.format(" Free energy path: %s", feDirectory.getAbsolutePath()));
                }
            }
            catch (Exception ex) {
                logger.warning(String.valueOf(ex) + Utilities.stackTraceToString(ex));
            }
        }
        for (int row = this.restartRow; row < this.baseSize; ++row) {
            Arrays.fill(this.myDistances, -8.0);
            int myIndex = 0;
            baseAssembly = this.baseFilter.getActiveMolecularSystem();
            baseCrystal = baseAssembly.getCrystal().getUnitCell();
            atoms1 = baseAssembly.getAtomArray();
            int baseFormat = 1;
            while (this.baseSize / (10 * baseFormat) >= 10) {
                ++baseFormat;
            }
            if (this.baseSize > 10) {
                ++baseFormat;
            }
            File baseFE = null;
            if (createFE && !(baseFE = new File(feDirectory.getAbsolutePath() + File.separator + String.format("%0" + baseFormat + "d", row) + File.separator)).exists()) {
                try {
                    if (baseFE.mkdir()) {
                        logger.info(String.format(" Base free energy path: %s", baseFE.getAbsolutePath()));
                    }
                }
                catch (Exception ex) {
                    logger.warning(String.valueOf(ex) + Utilities.stackTraceToString(ex));
                }
            }
            double[] reducedBaseCoords = ProgressiveAlignmentOfCrystals.reduceSystem(atoms1, comparisonAtoms);
            double baseDensity = baseCrystal.getUnitCell().getDensity(baseAssembly.getMass());
            if (baseCrystal == null || baseCrystal.aperiodic()) {
                logger.warning(" File " + baseAssembly.getFile().getName() + ": (" + baseAssembly.getName() + ") does not have a crystal. Consider using Superpose command.\n");
                continue;
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.finer(String.format(" Unit Cell Volume:  (Base) %4.2f (Target) %4.2f", baseCrystal.volume, targetCrystal.volume));
                logger.finer(String.format(" Unit Cell Symm Ops: (Base) %d (Target) %d", baseCrystal.getNumSymOps(), targetCrystal.getNumSymOps()));
                logger.finer(String.format(" Z'': (Base) %d (Target) %d", z1, z2));
            }
            int[] baseLMN = new int[3];
            double inflationFactorOrig = inflationFactor;
            this.baseXYZoriginal = ProgressiveAlignmentOfCrystals.generateInflatedSphere(baseCrystal.getUnitCell(), reducedBaseCoords, z1, nAU, linkage, mass, baseLMN, strict, this.baseSymOps, this.baseDistMap, inflationFactor);
            if (inflationFactorOrig != inflationFactor) {
                logger.warning(String.format(" Default replicates crystal was too small for comparison. Increasing inflation factor from %9.3f to %9.3f", inflationFactor, inflationFactorOrig));
            }
            int nBaseCoords = this.baseXYZoriginal.length;
            this.baseXYZ = new double[nBaseCoords];
            System.arraycopy(this.baseXYZoriginal, 0, this.baseXYZ, 0, nBaseCoords);
            int nBaseMols = nBaseCoords / (compareAtomsSize * 3);
            if (this.baseAUDist == null || this.baseAUDist.length != nBaseMols) {
                this.baseAUDist = new DoubleIndexPair[nBaseMols];
            }
            if (this.baseCoM == null || this.baseCoM.length != nBaseMols) {
                this.baseCoM = new double[3][nBaseMols][3];
            }
            ProgressiveAlignmentOfCrystals.centerOfMass(this.baseCoM[0], this.baseXYZ, this.massN, this.massSum, compareAtomsSize);
            ProgressiveAlignmentOfCrystals.prioritizeReplicates(this.baseXYZ, this.baseCoM[0], compareAtomsSize, this.baseAUDist, 0, linkage);
            for (int column = this.restartColumn; column < this.targetSize; ++column) {
                int targetRank = column % this.numProc;
                if (targetRank == this.rank) {
                    double rmsd;
                    this.stringBuilder.setLength(0);
                    long time = -System.nanoTime();
                    int assemblyNum = column / this.numProc;
                    if (!lowMemory) {
                        targetCrystal = this.crystalCache[assemblyNum];
                        atoms2 = this.atomCache[assemblyNum];
                    } else {
                        targetAssembly = this.targetFilter.getActiveMolecularSystem();
                        targetCrystal = targetAssembly.getCrystal().getUnitCell();
                        atoms2 = targetAssembly.getAtomArray();
                    }
                    if (targetCrystal == null || targetCrystal.aperiodic()) {
                        if (!lowMemory) {
                            logger.warning(" File " + this.fileCache[assemblyNum].getName() + ": (" + this.nameCache[assemblyNum] + ") does not have a crystal. Consider using Superpose command.\n");
                            continue;
                        }
                        logger.warning(" File " + baseAssembly.getFile().getName() + ": (" + targetAssembly.getName() + ") does not have a crystal. Consider using Superpose command.\n");
                        continue;
                    }
                    int targetFormat = 1;
                    while (this.targetSize / (10 * targetFormat) >= 10) {
                        ++targetFormat;
                    }
                    if (this.baseSize > 10) {
                        ++targetFormat;
                    }
                    if (this.isSymmetric && row == column) {
                        this.stringBuilder.append(String.format("\n Comparing Model %4d (%s) of %s\n with      Model %4d (%s) of %s\n", row + 1, baseCrystal.toShortString(), this.baseLabel, column + 1, targetCrystal.toShortString(), this.targetLabel));
                        rmsd = 0.0;
                        this.stringBuilder.append(String.format("\n PAC %s: %12s %7.4f A\n", this.rmsdLabel, "", rmsd));
                    } else if (this.isSymmetric && row > column) {
                        rmsd = -10.0;
                    } else {
                        ForceField forceField2;
                        List<Bond> bondList2;
                        String name2;
                        File file2;
                        ForceField forceField1;
                        List bondList1;
                        String name1;
                        File file1;
                        File targetFE = null;
                        if (createFE && !(targetFE = new File(baseFE.getAbsolutePath() + File.separator + String.format("%0" + targetFormat + "d", column) + File.separator)).exists()) {
                            try {
                                if (targetFE.mkdir()) {
                                    logger.info(String.format(" Target free energy path: %s", targetFE.getAbsolutePath()));
                                }
                            }
                            catch (Exception ex) {
                                logger.warning(ex.toString() + Utilities.stackTraceToString(ex));
                            }
                        }
                        this.stringBuilder.append(String.format("\n Comparing Model %4d (%s) of %s\n with      Model %4d (%s) of %s\n", row + 1, baseCrystal.toShortString(), this.baseLabel, column + 1, targetCrystal.toShortString(), this.targetLabel));
                        double[] reducedTargetCoords = ProgressiveAlignmentOfCrystals.reduceSystem(atoms2, comparisonAtoms2);
                        int[] targetLMN = new int[3];
                        inflationFactorOrig = inflationFactor;
                        this.targetXYZoriginal = ProgressiveAlignmentOfCrystals.generateInflatedSphere(targetCrystal.getUnitCell(), reducedTargetCoords, z2, nAU, linkage, mass2, targetLMN, strict, this.targetSymOps, this.targetDistMap, inflationFactor);
                        if (inflationFactorOrig != inflationFactor) {
                            logger.warning(String.format(" Default replicates crystal was too small for comparison. Increasing inflation factor from %9.3f to %9.3f", inflationFactor, inflationFactorOrig));
                        }
                        int nTargetCoords = this.targetXYZoriginal.length;
                        this.targetXYZ = new double[nTargetCoords];
                        System.arraycopy(this.targetXYZoriginal, 0, this.targetXYZ, 0, nTargetCoords);
                        double densityMass = 0.0;
                        if (!lowMemory) {
                            for (Atom atom : this.atomCache[assemblyNum]) {
                                densityMass += atom.getMass();
                            }
                        } else {
                            densityMass = this.targetFilter.getActiveMolecularSystem().getMass();
                        }
                        double targetDensity = targetCrystal.getUnitCell().getDensity(densityMass);
                        if (logger.isLoggable(Level.FINER)) {
                            this.stringBuilder.append(String.format("\n Base Density: %4.4f Target Density: %4.4f\n", baseDensity, targetDensity));
                        }
                        boolean densityCheck = crystalPriority == 1 ? baseDensity < targetDensity : baseDensity > targetDensity;
                        int nTargetMols = this.targetXYZ.length / (compareAtomsSize2 * 3);
                        if (this.targetAUDist == null || this.targetAUDist.length != nTargetMols) {
                            this.targetAUDist = new DoubleIndexPair[nTargetMols];
                        }
                        if (this.targetCoM == null || this.targetCoM.length != nTargetMols) {
                            this.targetCoM = new double[nTargetMols][3];
                        }
                        ProgressiveAlignmentOfCrystals.centerOfMass(this.targetCoM, this.targetXYZ, this.massN, this.massSum, compareAtomsSize);
                        ProgressiveAlignmentOfCrystals.prioritizeReplicates(this.targetXYZ, this.targetCoM, compareAtomsSize, this.targetAUDist, 0, linkage);
                        System.arraycopy(this.baseXYZoriginal, 0, this.baseXYZ, 0, nBaseCoords);
                        if (densityCheck || crystalPriority == 2) {
                            atoms1 = baseAssembly.getAtomArray();
                            file1 = baseAssembly.getFile();
                            name1 = baseAssembly.getName();
                            bondList1 = baseAssembly.getBondList();
                            forceField1 = baseAssembly.getForceField();
                            if (!lowMemory) {
                                atoms2 = this.atomCache[assemblyNum];
                                file2 = this.fileCache[assemblyNum];
                                name2 = this.nameCache[assemblyNum];
                                bondList2 = (List<Bond>)this.bondCache.get(assemblyNum);
                                forceField2 = this.forceFieldCache[assemblyNum];
                            } else {
                                MolecularAssembly mobileAssembly = this.targetFilter.getActiveMolecularSystem();
                                atoms2 = mobileAssembly.getAtomArray();
                                file2 = mobileAssembly.getFile();
                                name2 = mobileAssembly.getName();
                                bondList2 = mobileAssembly.getBondList();
                                forceField2 = mobileAssembly.getForceField();
                            }
                        } else {
                            double[] tempXYZ = new double[nBaseCoords];
                            System.arraycopy(this.baseXYZ, 0, tempXYZ, 0, nBaseCoords);
                            this.baseXYZ = new double[nTargetCoords];
                            System.arraycopy(this.targetXYZ, 0, this.baseXYZ, 0, nTargetCoords);
                            this.targetXYZ = new double[nBaseCoords];
                            System.arraycopy(tempXYZ, 0, this.targetXYZ, 0, nBaseCoords);
                            System.arraycopy(this.baseXYZoriginal, 0, tempXYZ, 0, nBaseCoords);
                            this.baseXYZoriginal = new double[nTargetCoords];
                            System.arraycopy(this.targetXYZoriginal, 0, this.baseXYZoriginal, 0, nTargetCoords);
                            this.targetXYZoriginal = new double[nBaseCoords];
                            System.arraycopy(tempXYZ, 0, this.targetXYZoriginal, 0, nBaseCoords);
                            tempXYZ = new double[nCoords];
                            System.arraycopy(reducedBaseCoords, 0, tempXYZ, 0, nCoords);
                            System.arraycopy(reducedTargetCoords, 0, reducedBaseCoords, 0, nCoords);
                            System.arraycopy(tempXYZ, 0, reducedTargetCoords, 0, nCoords);
                            ArrayList<SymOp> also = new ArrayList<SymOp>(this.baseSymOps);
                            this.baseSymOps = new ArrayList<SymOp>(this.targetSymOps);
                            this.targetSymOps = new ArrayList<SymOp>(also);
                            ArrayList<Integer> ali = new ArrayList<Integer>(this.baseDistMap);
                            this.baseDistMap = new ArrayList<Integer>(this.targetDistMap);
                            this.targetDistMap = new ArrayList<Integer>(ali);
                            DoubleIndexPair[] tempDIP = new DoubleIndexPair[nBaseMols];
                            System.arraycopy(this.baseAUDist, 0, tempDIP, 0, nBaseMols);
                            this.baseAUDist = new DoubleIndexPair[nTargetMols];
                            System.arraycopy(this.targetAUDist, 0, this.baseAUDist, 0, nTargetMols);
                            this.targetAUDist = new DoubleIndexPair[nBaseMols];
                            System.arraycopy(tempDIP, 0, this.targetAUDist, 0, nBaseMols);
                            double[][] tempDD = new double[nBaseMols][3];
                            System.arraycopy(this.baseCoM[0], 0, tempDD, 0, nBaseMols);
                            this.baseCoM = new double[3][nTargetMols][3];
                            System.arraycopy(this.targetCoM, 0, this.baseCoM[0], 0, nTargetMols);
                            this.targetCoM = new double[nBaseMols][3];
                            System.arraycopy(tempDD, 0, this.targetCoM, 0, nBaseMols);
                            atoms2 = baseAssembly.getAtomArray();
                            file2 = baseAssembly.getFile();
                            name2 = baseAssembly.getName();
                            bondList2 = baseAssembly.getBondList();
                            forceField2 = baseAssembly.getForceField();
                            int[] tempAtoms = (int[])comparisonAtoms.clone();
                            comparisonAtoms = (int[])comparisonAtoms2.clone();
                            comparisonAtoms2 = (int[])tempAtoms.clone();
                            int temp = z1;
                            z1 = z2;
                            z2 = temp;
                            temp = baseSearchValue;
                            baseSearchValue = targetSearchValue;
                            targetSearchValue = temp;
                            temp = nBaseCoords;
                            nBaseCoords = nTargetCoords;
                            nTargetCoords = temp;
                            temp = nBaseMols;
                            nBaseMols = nTargetMols;
                            nTargetMols = temp;
                            if (!lowMemory) {
                                atoms1 = this.atomCache[assemblyNum];
                                file1 = this.fileCache[assemblyNum];
                                name1 = this.nameCache[assemblyNum];
                                bondList1 = this.bondCache.get(assemblyNum);
                                forceField1 = this.forceFieldCache[assemblyNum];
                            } else {
                                MolecularAssembly staticAssembly = this.targetFilter.getActiveMolecularSystem();
                                atoms1 = staticAssembly.getAtomArray();
                                file1 = staticAssembly.getFile();
                                name1 = staticAssembly.getName();
                                bondList1 = staticAssembly.getBondList();
                                forceField1 = staticAssembly.getForceField();
                            }
                        }
                        this.allocateVariables(nAU, nCoords, z1, z2, useSym);
                        if (useSym) {
                            int i7;
                            for (i7 = 0; i7 < z1; ++i7) {
                                System.arraycopy(reducedBaseCoords, i7 * compareAtomsSize * 3, this.baseAUoriginal[i7], 0, compareAtomsSize * 3);
                            }
                            for (i7 = 0; i7 < z2; ++i7) {
                                System.arraycopy(reducedTargetCoords, i7 * compareAtomsSize2 * 3, this.targetAUoriginal[i7], 0, compareAtomsSize2 * 3);
                            }
                        }
                        if (logger.isLoggable(Level.FINER)) {
                            logger.finer(String.format(" %3d Molecules in Base Crystal \t %3d Molecules in Target Crystal", nBaseCoords / 3 / compareAtomsSize, nTargetCoords / 3 / compareAtomsSize));
                        }
                        if (logger.isLoggable(Level.FINEST) && saveClusters > 0) {
                            this.saveAssembly(file1, name1, bondList1, atoms1, forceField1, this.baseXYZoriginal, comparisonAtoms, nBaseCoords / 3, "_c1_rep", -1, saveClusters);
                            this.saveAssembly(file2, name2, bondList2, atoms2, forceField2, this.targetXYZoriginal, comparisonAtoms2, nTargetCoords / 3, "_c2_rep", -1, saveClusters);
                        }
                        rmsd = this.compare(file1, name1, bondList1, atoms1, forceField1, file2, name2, bondList2, atoms2, forceField2, z1, z2, compareAtomsSize, nAU, baseSearchValue, targetSearchValue, matchTol, row * this.targetSize + column, strict, saveClusters, machineLearning, linkage, inertia, gyrationComponents);
                        double timeSec = (double)(time += System.nanoTime()) * 1.0E-9;
                        if (timeSec < minTime) {
                            minTime = timeSec;
                        }
                        if (timeSec > maxTime) {
                            maxTime = timeSec;
                        }
                        double avgGyration = (this.gyrations[0] + this.gyrations[1]) / 2.0;
                        double diff = FastMath.max((double)this.gyrations[0], (double)this.gyrations[1]) - avgGyration;
                        this.stringBuilder.append(String.format("\n PAC %7s: %12s %7.4f A (%5.3f sec) G(r) %7.4f A +/- %7.4f\n", this.rmsdLabel, "", rmsd, timeSec, avgGyration, diff));
                        if (inertia) {
                            int i8;
                            this.stringBuilder.append("\n Moments of Inertia and Principle Axes for first crystal:\n  Moments (amu Ang^2): \t X-, Y-, and Z-Components of Axes:\n");
                            for (i8 = 1; i8 < 4; ++i8) {
                                this.stringBuilder.append(String.format("  %16.3f %12.6f %12.6f %12.6f\n", this.bestBaseMandV[i8 - 1][0], this.bestBaseMandV[0][i8], this.bestBaseMandV[1][i8], this.bestBaseMandV[2][i8]));
                            }
                            this.stringBuilder.append(" Moments of Inertia and Principle Axes for second crystal:\n  Moments (amu Ang^2): \t X-, Y-, and Z-Components of Axes:\n");
                            for (i8 = 1; i8 < 4; ++i8) {
                                this.stringBuilder.append(String.format("  %16.3f %12.6f %12.6f %12.6f\n", this.bestTargetMandV[i8 - 1][0], this.bestTargetMandV[0][i8], this.bestTargetMandV[1][i8], this.bestTargetMandV[2][i8]));
                            }
                        }
                        if (gyrationComponents) {
                            double Rmax = FastMath.max((double)FastMath.max((double)this.bestBaseRg[0], (double)this.bestBaseRg[1]), (double)this.bestBaseRg[2]);
                            Rmax *= Rmax;
                            double Rmed = FastMath.max((double)FastMath.min((double)this.bestBaseRg[0], (double)this.bestBaseRg[1]), (double)this.bestBaseRg[2]);
                            Rmed *= Rmed;
                            double Rmin = FastMath.min((double)FastMath.min((double)this.bestBaseRg[0], (double)this.bestBaseRg[1]), (double)this.bestBaseRg[2]);
                            Rmin *= Rmin;
                            double Rg = Rmax + Rmed + Rmin;
                            double asphericity = Rmax - 0.5 * (Rmin + Rmed);
                            double acylindricity = Rmed - Rmin;
                            double anisotropy = asphericity * asphericity + 0.75 * acylindricity * acylindricity;
                            double totalMass = Arrays.stream(mass).sum();
                            double volume = totalMass / FastMath.max((double)baseCrystal.getDensity(this.massSum), (double)targetCrystal.getDensity(this.massSum));
                            double targetRadius = FastMath.cbrt((double)(0.238732414637843 * volume));
                            this.stringBuilder.append(String.format(" Base Radius Metric: %7.4f", avgGyration / targetRadius));
                            if (logger.isLoggable(Level.FINER)) {
                                this.stringBuilder.append(String.format("\n Target Base Radius:           %9.3f \u00c5\n", targetRadius));
                                this.stringBuilder.append(String.format(" Asphericity:   (%6.3f \u00c5^2) %9.3f\n", asphericity, asphericity / Rmax));
                                this.stringBuilder.append(String.format(" Acylindricity: (%6.3f \u00c5^2) %9.3f\n", acylindricity, acylindricity / Rmax));
                                this.stringBuilder.append(String.format(" Anisotropy:    (%6.3f \u00c5) %9.3f\n", FastMath.sqrt((double)FastMath.sqrt((double)anisotropy)), anisotropy / (Rg * Rg)));
                                this.stringBuilder.append(String.format("  Ryz %9.3f\u00c5  Rxz %9.3f\u00c5  Rxy %9.3f\u00c5\n", this.bestBaseRg[0], this.bestBaseRg[1], this.bestBaseRg[2]));
                            }
                            Rmax = FastMath.max((double)FastMath.max((double)this.bestTargetRg[0], (double)this.bestTargetRg[1]), (double)this.bestTargetRg[2]);
                            Rmax *= Rmax;
                            Rmed = FastMath.max((double)FastMath.min((double)this.bestTargetRg[0], (double)this.bestTargetRg[1]), (double)this.bestTargetRg[2]);
                            Rmed *= Rmed;
                            Rmin = FastMath.min((double)FastMath.min((double)this.bestTargetRg[0], (double)this.bestTargetRg[1]), (double)this.bestTargetRg[2]);
                            Rmin *= Rmin;
                            Rg = Rmax + Rmed + Rmin;
                            asphericity = Rmax - 0.5 * (Rmin + Rmed);
                            acylindricity = Rmed - Rmin;
                            anisotropy = asphericity * asphericity + 0.75 * acylindricity * acylindricity;
                            totalMass = Arrays.stream(mass).sum();
                            volume = totalMass / targetDensity;
                            targetRadius = FastMath.cbrt((double)(0.238732414637843 * volume));
                            if (logger.isLoggable(Level.FINER)) {
                                this.stringBuilder.append(String.format("\n Target Target Radius:           %9.3f \u00c5\n", targetRadius));
                                this.stringBuilder.append(String.format(" Asphericity:   (%6.3f \u00c5) %9.3f\n", asphericity, asphericity / Rmax));
                                this.stringBuilder.append(String.format(" Acylindricity: (%6.3f \u00c5) %9.3f\n", acylindricity, acylindricity / Rmax));
                                this.stringBuilder.append(String.format(" Anisotropy:    (%6.3f \u00c5) %9.3f\n", FastMath.sqrt((double)FastMath.sqrt((double)anisotropy)), anisotropy / (Rg * Rg)));
                                this.stringBuilder.append(String.format("  Ryz %9.3f\u00c5  Rxz %9.3f\u00c5  Rxy %9.3f\u00c5\n", this.bestTargetRg[0], this.bestTargetRg[1], this.bestTargetRg[2]));
                            }
                        }
                        if (logger.isLoggable(Level.FINER)) {
                            this.stringBuilder.append(String.format("\n Gyration Crystal 1 (%s): %7.4f Crystal 2 (%s): %7.4f.\n", name1, this.gyrations[0], name2, this.gyrations[1]));
                        }
                        if (useSym) {
                            StringBuilder sbSO = new StringBuilder(String.format("\n Sym Op to move %s onto %s:\nsymop ", name2, name1));
                            StringBuilder sbInv = new StringBuilder(String.format("\n Inverted Sym Op to move %s onto %s:\nsymop ", name1, name2));
                            int[] mol1 = baseAssembly.getMoleculeNumbers();
                            int[] mol2 = targetAssembly.getMoleculeNumbers();
                            for (int i9 = 0; i9 < z1; ++i9) {
                                for (int j = 0; j < z2; ++j) {
                                    if (this.bestTargetTransformSymOp[i9][j] != null) {
                                        this.bestTargetTransformSymOp[i9][j] = this.bestTargetTransformSymOp[i9][j].prepend(this.bestTargetSymOp[i9][j]);
                                        this.bestBaseTransformSymOp[i9][j] = this.bestBaseTransformSymOp[i9][j].prepend(this.bestBaseSymOp[i9][j]);
                                        this.bestTargetTransformSymOp[i9][j] = this.bestTargetTransformSymOp[i9][j].append(SymOp.invertSymOp((SymOp)this.bestBaseTransformSymOp[i9][j]));
                                        if (!strict && !logger.isLoggable(Level.FINEST) && z1 == z2 && i9 != j) continue;
                                        SymOp inverted = SymOp.invertSymOp((SymOp)this.bestTargetTransformSymOp[i9][j]);
                                        if (logger.isLoggable(Level.FINEST)) {
                                            this.stringBuilder.append(String.format("\n Sym Op to move %s (%2d) onto %s (%2d):\n", name2, j, name1, i9)).append(this.bestTargetTransformSymOp[i9][j]).append("\n");
                                            this.stringBuilder.append(String.format("\n\n Inverted Sym Op to move %s (%2d) onto %s (%2d):\n", name1, i9, name2, j)).append(inverted).append("\n");
                                        }
                                        ArrayList<Integer> mol1list = new ArrayList<Integer>();
                                        ArrayList<Integer> mol2list = new ArrayList<Integer>();
                                        for (int k = 0; k < nAtoms; ++k) {
                                            if ((z1 == 1 || i9 == mol1[k]) && ArrayUtils.contains((int[])comparisonAtoms, (int)k)) {
                                                mol1list.add(k);
                                            }
                                            if (z2 != 1 && j != mol2[k] || !ArrayUtils.contains((int[])comparisonAtoms2, (int)k)) continue;
                                            mol2list.add(k);
                                        }
                                        int[] mol1arr = mol1list.stream().mapToInt(Integer::intValue).toArray();
                                        int[] mol2arr = mol2list.stream().mapToInt(Integer::intValue).toArray();
                                        if (mol1arr.length < 3 || mol2arr.length < 3) {
                                            logger.warning(" Less than 3 atoms were included for this sym op which likely leads to poor multipole overlap.");
                                        }
                                        sbSO.append(String.format("    %s     %s", StringUtils.writeAtomRanges((int[])mol1arr), StringUtils.writeAtomRanges((int[])mol2arr))).append(SymOp.asMatrixString((SymOp)this.bestTargetTransformSymOp[i9][j]));
                                        sbInv.append(String.format("    %s     %s", StringUtils.writeAtomRanges((int[])mol2arr), StringUtils.writeAtomRanges((int[])mol1arr))).append(SymOp.asMatrixString((SymOp)inverted));
                                        if (i9 + 1 < z1 || j + 1 < z2) {
                                            sbSO.append("\\\n");
                                            sbInv.append("\\\n");
                                        }
                                        if (createFE) {
                                            File newCoordFile2;
                                            File newCoordFile;
                                            StringBuilder fName1 = new StringBuilder();
                                            fName1.append(targetFE.getAbsolutePath()).append(File.separator).append(FilenameUtils.removeExtension((String)file1.getName())).append("_base");
                                            File newPropertyFile = new File(fName1.toString() + ".properties");
                                            if (!newPropertyFile.exists()) {
                                                StringBuilder propertyName = new StringBuilder();
                                                propertyName.append(FilenameUtils.removeExtension((String)file1.getName())).append(".properties");
                                                if (!ProgressiveAlignmentOfCrystals.copyFile(new File(propertyName.toString()), newPropertyFile)) {
                                                    logger.warning(" Error copying PROPERTIES file to FE directory (currently not implemented for KEY/PRM).");
                                                }
                                            }
                                            if (!(newCoordFile = new File(fName1.toString() + ".xyz")).exists()) {
                                                MolecularAssembly assembly = densityCheck || crystalPriority == 2 ? this.baseFilter.getActiveMolecularSystem() : this.targetFilter.getActiveMolecularSystem();
                                                File originalFile = assembly.getFile();
                                                String originalName = assembly.getName();
                                                XYZFilter xyzFilter = new XYZFilter(newCoordFile, assembly, assembly.getForceField(), assembly.getProperties());
                                                xyzFilter.writeFile(newCoordFile, false);
                                                assembly.setFile(originalFile);
                                                assembly.setName(originalName);
                                            }
                                            StringBuilder fName2 = new StringBuilder();
                                            fName2.append(targetFE.getAbsolutePath()).append(File.separator).append(FilenameUtils.getBaseName((String)file2.getName())).append("_target");
                                            File newPropertyFile2 = new File(fName2.toString() + ".properties");
                                            if (!newPropertyFile2.exists()) {
                                                StringBuilder propertyName = new StringBuilder();
                                                propertyName.append(FilenameUtils.getBaseName((String)file2.getName())).append(".properties");
                                                if (!ProgressiveAlignmentOfCrystals.copyFile(new File(propertyName.toString()), newPropertyFile2)) {
                                                    logger.warning(" Error copying PROPERTIES file to FE directory (currently not implemented for KEY/PRM).");
                                                }
                                            }
                                            if (!(newCoordFile2 = new File(fName2.toString() + ".xyz")).exists()) {
                                                MolecularAssembly assembly = densityCheck || crystalPriority == 2 ? this.targetFilter.getActiveMolecularSystem() : this.baseFilter.getActiveMolecularSystem();
                                                File originalFile = assembly.getFile();
                                                String originalName = assembly.getName();
                                                XYZFilter xyzFilter = new XYZFilter(newCoordFile2, assembly, assembly.getForceField(), assembly.getProperties());
                                                xyzFilter.writeFile(newCoordFile2, false);
                                                assembly.setFile(originalFile);
                                                assembly.setName(originalName);
                                            }
                                            if (writeSym) {
                                                BufferedWriter bw;
                                                try {
                                                    bw = new BufferedWriter(new FileWriter(newPropertyFile, newPropertyFile.exists()));
                                                    try {
                                                        String label = ProgressiveAlignmentOfCrystals.fileContainsString(newPropertyFile, "symop");
                                                        bw.write(String.format("%s    %s     %s", label, StringUtils.writeAtomRanges((int[])mol1arr), StringUtils.writeAtomRanges((int[])mol2arr)) + SymOp.asMatrixString((SymOp)this.bestTargetTransformSymOp[i9][j]) + "\\\n");
                                                    }
                                                    finally {
                                                        bw.close();
                                                    }
                                                }
                                                catch (Exception ex) {
                                                    logger.info(" Failed to append symmetry operator to target properties file.");
                                                    logger.warning(String.valueOf(ex) + Utilities.stackTraceToString(ex));
                                                }
                                                try {
                                                    bw = new BufferedWriter(new FileWriter(newPropertyFile2, newPropertyFile2.exists()));
                                                    try {
                                                        String label = ProgressiveAlignmentOfCrystals.fileContainsString(newPropertyFile2, "symop");
                                                        bw.write(String.format("%s    %s     %s", label, StringUtils.writeAtomRanges((int[])mol2arr), StringUtils.writeAtomRanges((int[])mol1arr)) + SymOp.asMatrixString((SymOp)inverted) + "\\\n");
                                                    }
                                                    finally {
                                                        bw.close();
                                                    }
                                                }
                                                catch (Exception ex) {
                                                    logger.info(" Failed to append symmetry operator to base properties file.");
                                                    logger.warning(String.valueOf(ex) + Utilities.stackTraceToString(ex));
                                                }
                                            }
                                        }
                                        if (!createFE && writeSym) {
                                            File newFile = new File(FilenameUtils.removeExtension((String)file1.getAbsolutePath()) + ".properties");
                                            try (BufferedWriter bw = new BufferedWriter(new FileWriter(newFile, newFile.exists()));){
                                                String label = ProgressiveAlignmentOfCrystals.fileContainsString(newFile, "symop");
                                                bw.write(String.format("%s    %s     %s", label, StringUtils.writeAtomRanges((int[])mol1arr), StringUtils.writeAtomRanges((int[])mol2arr)) + SymOp.asMatrixString((SymOp)this.bestTargetTransformSymOp[i9][j]) + "\\\n");
                                            }
                                            catch (Exception ex) {
                                                logger.info(" Failed to append symmetry operator to target properties file.");
                                                logger.warning(String.valueOf(ex) + Utilities.stackTraceToString(ex));
                                            }
                                            File newFile2 = new File(FilenameUtils.removeExtension((String)file2.getAbsolutePath()) + ".properties");
                                            try (BufferedWriter bw = new BufferedWriter(new FileWriter(newFile2, newFile2.exists()));){
                                                String label = ProgressiveAlignmentOfCrystals.fileContainsString(newFile2, "symop");
                                                bw.write(String.format("%s    %s     %s", label, StringUtils.writeAtomRanges((int[])mol2arr), StringUtils.writeAtomRanges((int[])mol1arr)) + SymOp.asMatrixString((SymOp)inverted) + "\\\n");
                                            }
                                            catch (Exception ex) {
                                                logger.info(" Failed to append symmetry operator to base properties file.");
                                                logger.warning(String.valueOf(ex) + Utilities.stackTraceToString(ex));
                                            }
                                        }
                                        if (densityCheck || crystalPriority == 2) {
                                            symOpsA.append(String.format("    %s     %s", StringUtils.writeAtomRanges((int[])mol1arr), StringUtils.writeAtomRanges((int[])mol2arr))).append(SymOp.asMatrixString((SymOp)this.bestTargetTransformSymOp[i9][j])).append("\\\n");
                                            symOpsB.append(String.format("    %s     %s", StringUtils.writeAtomRanges((int[])mol2arr), StringUtils.writeAtomRanges((int[])mol1arr))).append(SymOp.asMatrixString((SymOp)inverted)).append("\\\n");
                                        } else {
                                            symOpsA.append(String.format("    %s     %s", StringUtils.writeAtomRanges((int[])mol2arr), StringUtils.writeAtomRanges((int[])mol1arr))).append(SymOp.asMatrixString((SymOp)inverted)).append("\\\n");
                                            symOpsB.append(String.format("    %s     %s", StringUtils.writeAtomRanges((int[])mol1arr), StringUtils.writeAtomRanges((int[])mol2arr))).append(SymOp.asMatrixString((SymOp)this.bestTargetTransformSymOp[i9][j])).append("\\\n");
                                        }
                                        if (!logger.isLoggable(Level.FINER)) continue;
                                        this.stringBuilder.append(String.format("\n Sym Op Application from Scratch: Target: %s (%2d) onto Base: %s (%2d)", name2, j, name1, i9));
                                        double[] symMol = new double[nCoords];
                                        for (int k = 0; k < compareAtomsSize; ++k) {
                                            int l = k * 3;
                                            double[] xyz = new double[]{this.targetAUoriginal[j][l], this.targetAUoriginal[j][l + 1], this.targetAUoriginal[j][l + 2]};
                                            SymOp.applyCartesianSymOp((double[])xyz, (double[])xyz, (SymOp)this.bestTargetTransformSymOp[i9][j]);
                                            symMol[l] = xyz[0];
                                            symMol[l + 1] = xyz[1];
                                            symMol[l + 2] = xyz[2];
                                            this.stringBuilder.append(String.format("\n %8.3f %8.3f %8.3f moved to %8.3f %8.3f %8.3f compared to %8.3f %8.3f %8.3f", this.targetAUoriginal[j][l], this.targetAUoriginal[j][l + 1], this.targetAUoriginal[j][l + 2], symMol[l], symMol[l + 1], symMol[l + 2], this.baseAUoriginal[i9][l], this.baseAUoriginal[i9][l + 1], this.baseAUoriginal[i9][l + 2]));
                                        }
                                        if (saveClusters > 0) {
                                            this.saveAssembly(file2, name2, bondList2, atoms2, forceField2, symMol, comparisonAtoms, 1, "_moved", 0, saveClusters);
                                        }
                                        double value = Superpose.rmsd(this.baseAUoriginal[i9], symMol, this.massN);
                                        double[] symMol2 = new double[nCoords];
                                        this.stringBuilder.append("\n\n Sym Op Inverse Application:");
                                        for (int k = 0; k < compareAtomsSize; ++k) {
                                            int l = k * 3;
                                            double[] xyz = new double[]{symMol[l], symMol[l + 1], symMol[l + 2]};
                                            SymOp.applyCartesianSymOp((double[])xyz, (double[])xyz, (SymOp)inverted);
                                            symMol2[l] = xyz[0];
                                            symMol2[l + 1] = xyz[1];
                                            symMol2[l + 2] = xyz[2];
                                            this.stringBuilder.append(String.format("\n %8.3f %8.3f %8.3f moved to %8.3f %8.3f %8.3f compared to %8.3f %8.3f %8.3f", symMol[l], symMol[l + 1], symMol[l + 2], symMol2[l], symMol2[l + 1], symMol2[l + 2], this.targetAUoriginal[j][l], this.targetAUoriginal[j][l + 1], this.targetAUoriginal[j][l + 2]));
                                        }
                                        this.stringBuilder.append(String.format("\n\n Sym Op RMSD: %8.8f \n\n", value));
                                        continue;
                                    }
                                    if (!logger.isLoggable(Level.INFO)) continue;
                                    logger.info(String.format(" Symmetry Operator %2d %2d was filtered out. Try using a single asymmetric unit (--na 1).", i9, j));
                                }
                            }
                            this.stringBuilder.append(sbSO.toString()).append("\n").append(sbInv.toString()).append("\n");
                        }
                        if (!densityCheck && crystalPriority != 2) {
                            this.baseXYZ = new double[nTargetCoords];
                            System.arraycopy(this.targetXYZ, 0, this.baseXYZ, 0, nTargetCoords);
                            this.baseXYZoriginal = new double[nTargetCoords];
                            System.arraycopy(this.targetXYZoriginal, 0, this.baseXYZoriginal, 0, nTargetCoords);
                            System.arraycopy(reducedTargetCoords, 0, reducedBaseCoords, 0, nCoords);
                            this.baseSymOps = new ArrayList<SymOp>(this.targetSymOps);
                            this.baseDistMap = new ArrayList<Integer>(this.targetDistMap);
                            int[] tempAtoms = (int[])comparisonAtoms.clone();
                            comparisonAtoms = (int[])comparisonAtoms2.clone();
                            comparisonAtoms2 = (int[])tempAtoms.clone();
                            DoubleIndexPair[] tempDIP = new DoubleIndexPair[nBaseMols];
                            System.arraycopy(this.baseAUDist, 0, tempDIP, 0, nBaseMols);
                            this.baseAUDist = new DoubleIndexPair[nTargetMols];
                            System.arraycopy(this.targetAUDist, 0, this.baseAUDist, 0, nTargetMols);
                            this.targetAUDist = new DoubleIndexPair[nBaseMols];
                            System.arraycopy(tempDIP, 0, this.targetAUDist, 0, nBaseMols);
                            double[][] tempDD = new double[nBaseMols][3];
                            System.arraycopy(this.baseCoM[0], 0, tempDD, 0, nBaseMols);
                            this.baseCoM = new double[3][nTargetMols][3];
                            System.arraycopy(this.targetCoM, 0, this.baseCoM[0], 0, nTargetMols);
                            this.targetCoM = new double[nBaseMols][3];
                            System.arraycopy(tempDD, 0, this.targetCoM, 0, nBaseMols);
                            int temp = z1;
                            z1 = z2;
                            z2 = temp;
                            temp = baseSearchValue;
                            baseSearchValue = targetSearchValue;
                            targetSearchValue = temp;
                            nBaseCoords = nTargetCoords;
                            nBaseMols = nTargetMols;
                        }
                        if (hitTol >= 0.0 && hitTol > rmsd) {
                            ++this.numberOfHits;
                        }
                    }
                    this.myDistances[myIndex] = rmsd;
                    ++myIndex;
                    if (!this.stringBuilder.isEmpty()) {
                        logger.info(this.stringBuilder.toString());
                    }
                    if (save >= 0.0 && rmsd < save) {
                        XYZFilter xyzFilter = new XYZFilter(saveLocation1.getAbsoluteFile(), baseAssembly, baseAssembly.getForceField(), baseAssembly.getProperties());
                        xyzFilter.writeFile(saveLocation1.getAbsoluteFile(), true);
                        XYZFilter xyzFilter2 = new XYZFilter(saveLocation2.getAbsoluteFile(), targetAssembly, targetAssembly.getForceField(), targetAssembly.getProperties());
                        xyzFilter2.writeFile(saveLocation2.getAbsoluteFile(), true);
                    }
                }
                if (!lowMemory) continue;
                this.targetFilter.readNext(false, false, (column + 1) % this.numProc == this.rank);
            }
            this.restartColumn = 0;
            if (lowMemory) {
                this.targetFilter.readNext(true, false, 0 == this.rank);
            }
            this.baseFilter.readNext(false, false);
            this.gatherRMSDs(row, runningStatistics);
            if (this.rank != 0 || !write) continue;
            int firstColumn = this.isSymmetric ? row : 0;
            DistanceMatrixFilter.writeDistanceMatrixRow(pacFileName, this.distRow, firstColumn);
        }
        if (minTime < Double.MAX_VALUE) {
            logger.info(String.format("\n Minimum PAC Time: %7.4f", minTime));
        }
        if (logger.isLoggable(Level.FINE) && maxTime > Double.MIN_VALUE && maxTime != minTime) {
            logger.info(String.format(" Maximum PAC Time: %7.4f", maxTime));
        }
        if (this.rank == 0 || logger.isLoggable(Level.FINER)) {
            double min = runningStatistics.getMin();
            if (Double.MAX_VALUE - min < matchTol) {
                logger.warning(" SuperposeCrystals was not able to compare the provided structures.");
                if (logger.isLoggable(Level.FINE)) {
                    logger.info(String.format(" RMSD Minimum:  %8.6f", min));
                }
            } else {
                if (hitTol >= 0.0) {
                    logger.info(String.format(" Number of \"Hits\":  %8d", this.numberOfHits));
                }
                logger.info(String.format(" RMSD Minimum:  %8.6f", min));
                logger.info(String.format(" RMSD Maximum:  %8.6f", runningStatistics.getMax()));
                logger.info(String.format(" RMSD Mean:     %8.6f", runningStatistics.getMean()));
                double variance = runningStatistics.getVariance();
                if (!Double.isNaN(variance)) {
                    logger.info(String.format(" RMSD Variance: %8.6f", variance));
                }
            }
        }
        return runningStatistics;
    }

    private static boolean addLooseUnequal(List<Double> values, double value, double tol) {
        boolean found = false;
        for (Double dbl : values) {
            if (!(FastMath.abs((double)(dbl - value)) < tol)) continue;
            found = true;
            break;
        }
        if (!found) {
            values.add(value);
        }
        return !found;
    }

    public void addRotation(double[][] rot, double[][] totalTransform, boolean prepend) {
        Object transform = new double[][]{{rot[0][0], rot[0][1], rot[0][2], 0.0}, {rot[1][0], rot[1][1], rot[1][2], 0.0}, {rot[2][0], rot[2][1], rot[2][2], 0.0}, {0.0, 0.0, 0.0, 1.0}};
        transform = prepend ? MatrixMath.mat4Mat4((double[][])totalTransform, (double[][])transform) : MatrixMath.mat4Mat4((double[][])transform, (double[][])totalTransform);
        int length = totalTransform.length;
        for (int i = 0; i < length; ++i) {
            System.arraycopy(transform[i], 0, totalTransform[i], 0, totalTransform[i].length);
        }
    }

    public static void addTranslation(double[] translation, double[][] totalTransform, boolean prepend) {
        Object transform = new double[][]{{1.0, 0.0, 0.0, translation[0]}, {0.0, 1.0, 0.0, translation[1]}, {0.0, 0.0, 1.0, translation[2]}, {0.0, 0.0, 0.0, 1.0}};
        transform = prepend ? MatrixMath.mat4Mat4((double[][])totalTransform, (double[][])transform) : MatrixMath.mat4Mat4((double[][])transform, (double[][])totalTransform);
        int length = totalTransform.length;
        for (int i = 0; i < length; ++i) {
            System.arraycopy(transform[i], 0, totalTransform[i], 0, totalTransform[i].length);
        }
    }

    private void allocateVariables(int nAU, int nCoords, int z1, int z2, boolean useSym) {
        if (this.baseAU == null || this.baseAU.length != nCoords) {
            this.baseAU = new double[nCoords];
        }
        if (this.targetAU == null || this.targetAU.length != nCoords) {
            this.targetAU = new double[nCoords];
        }
        if (this.pairedAUs == null || this.pairedAUs.length != FastMath.max((int)3, (int)nAU)) {
            this.pairedAUs = new DoubleIndexPair[FastMath.max((int)3, (int)nAU)];
        }
        if (this.base3AUs == null || this.base3AUs.length != nCoords * 3) {
            this.base3AUs = new double[nCoords * 3];
        }
        if (this.target3AUs == null || this.target3AUs.length != nCoords * 3) {
            this.target3AUs = new double[nCoords * 3];
        }
        if (this.baseNAUs == null || this.baseNAUs[0].length != nAU * nCoords) {
            this.baseNAUs = new double[4][nAU * nCoords];
        }
        if (this.targetNAUs == null || this.targetNAUs.length != nAU * nCoords) {
            this.targetNAUs = new double[nAU * nCoords];
        }
        if (this.bestBaseNAUs == null || this.bestBaseNAUs.length != z1 || this.bestBaseNAUs[0].length != z2 || this.bestBaseNAUs[0][0].length != nAU * nCoords) {
            this.bestBaseNAUs = new double[z1][z2][nAU * nCoords];
        }
        if (this.bestTargetNAUs == null || this.bestTargetNAUs.length != z1 || this.bestTargetNAUs[0].length != z2 || this.bestTargetNAUs[0][0].length != nAU * nCoords) {
            this.bestTargetNAUs = new double[z1][z2][nAU * nCoords];
        }
        if (useSym) {
            if (this.baseSymOps == null) {
                this.baseSymOps = new ArrayList();
            }
            if (this.targetSymOps == null) {
                this.targetSymOps = new ArrayList();
            }
            if (this.baseAUoriginal == null || this.baseAUoriginal.length != z1 || this.baseAUoriginal[0].length != nCoords) {
                this.baseAUoriginal = new double[z1][nCoords];
            }
            if (this.targetAUoriginal == null || this.targetAUoriginal.length != z2 || this.targetAUoriginal[0].length != nCoords) {
                this.targetAUoriginal = new double[z2][nCoords];
            }
        }
    }

    private static void centerOfMass(double[][] centersOfMass, double[] coords, double[] mass, double massSum, int nAtoms) {
        int nAU = coords.length / (nAtoms * 3);
        for (int i = 0; i < nAU; ++i) {
            int j;
            int auIndex = i * nAtoms * 3;
            double[] comI = new double[3];
            for (j = 0; j < nAtoms; ++j) {
                int atomIndex = auIndex + j * 3;
                double m = mass[j];
                for (int k = 0; k < 3; ++k) {
                    int n = k;
                    comI[n] = comI[n] + coords[atomIndex + k] * m;
                }
            }
            j = 0;
            while (j < 3) {
                int n = j++;
                comI[n] = comI[n] / massSum;
            }
            centersOfMass[i] = comI;
        }
    }

    private static boolean checkInflatedSphere(double[] xyz, double[] massN, double massSum, int compareAtomsSize, int nAU, int linkage, int[] startLMN, ArrayList<SymOp> symOps, ArrayList<Integer> indexOrder) {
        double[][] centerOfMass = new double[xyz.length / 3][3];
        ProgressiveAlignmentOfCrystals.centerOfMass(centerOfMass, xyz, massN, massSum, compareAtomsSize);
        DoubleIndexPair[] auDist = new DoubleIndexPair[xyz.length / 3 / compareAtomsSize];
        ProgressiveAlignmentOfCrystals.prioritizeReplicates(xyz, centerOfMass, compareAtomsSize, auDist, 0, linkage);
        boolean redo = false;
        for (int i = 0; i < nAU; ++i) {
            int[] lmn;
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format(" i: %3d\t auDist Index: %3d \t indexOrder: %3d\t indget(au): %3d\t ReplicatesVector:  %2d (%2d) %2d (%2d) %2d (%2d)", i, auDist[i].index(), indexOrder.get(i), indexOrder.get(auDist[i].index()), symOps.get((int)indexOrder.get((int)auDist[i].index()).intValue()).replicatesVector[0] + 1, startLMN[0], symOps.get((int)indexOrder.get((int)auDist[i].index()).intValue()).replicatesVector[1] + 1, startLMN[1], symOps.get((int)indexOrder.get((int)auDist[i].index()).intValue()).replicatesVector[2] + 1, startLMN[2]));
            }
            if ((lmn = symOps.get((int)indexOrder.get((int)auDist[i].index()).intValue()).replicatesVector)[0] == 0 || lmn[0] == startLMN[0] - 1) {
                redo = true;
            }
            if (lmn[1] == 0 || lmn[1] == startLMN[1] - 1) {
                redo = true;
            }
            if (lmn[2] == 0 || lmn[2] == startLMN[2] - 1) {
                redo = true;
            }
            if (redo) break;
        }
        if (redo && logger.isLoggable(Level.FINE)) {
            logger.fine(" REDO EXPANSION.");
        }
        return redo;
    }

    private static void copyArrayValues(double[][] newArray, double[][] oldArray) {
        int arrayLength = newArray.length;
        for (int i = 0; i < arrayLength; ++i) {
            System.arraycopy(oldArray[i], 0, newArray[i], 0, newArray[i].length);
        }
    }

    private static boolean copyFile(File input, File output) {
        try (FileInputStream is = new FileInputStream(input);
             FileOutputStream os = new FileOutputStream(output);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)is).read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, length);
            }
        }
        catch (Exception ex) {
            logger.info(String.valueOf(ex) + Utilities.stackTraceToString(ex));
            return false;
        }
        return true;
    }

    private static void determineComparableAtoms(Atom[] atoms, ArrayList<Integer> indices, ArrayList<Integer> unique, boolean alphaCarbons, boolean includeHydrogen) {
        int nAtoms = atoms.length;
        for (int i = 0; i < nAtoms; ++i) {
            if (unique.contains(i)) continue;
            Atom atom = atoms[i];
            if (alphaCarbons) {
                boolean aminoCheck;
                String atomName = atom.getName();
                int atomAtNum = atom.getAtomicNumber();
                boolean proteinCheck = atomName.equals("CA") && atomAtNum == 6;
                boolean bl = aminoCheck = (atomName.equals("N1") || atomName.equals("N9")) && atomAtNum == 7;
                if (proteinCheck || aminoCheck) {
                    indices.add(i);
                }
            } else if (includeHydrogen || !atom.isHydrogen()) {
                indices.add(i);
            }
            atom.setActive(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String fileContainsString(File file, String string) {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            String line = br.readLine();
            while (line != null) {
                if (line.toUpperCase().contains(string.toUpperCase())) {
                    String string2 = "";
                    return string2;
                }
                line = br.readLine();
            }
            String string3 = string + " ";
            return string3;
        }
        catch (Exception ex) {
            logger.warning(String.valueOf(ex) + Utilities.stackTraceToString(ex));
            return "";
        }
    }

    private void gatherRMSDs(int row, RunningStatistics runningStatistics) {
        if (this.useMPI) {
            try {
                if (logger.isLoggable(Level.FINER)) {
                    logger.finer(" Receiving MPI results.");
                }
                this.world.gather(0, (Buf)this.myBuffer, (Buf[])this.buffers);
                if (this.rank == 0) {
                    for (int workItem = 0; workItem < this.numWorkItems; ++workItem) {
                        for (int proc = 0; proc < this.numProc; ++proc) {
                            int column = this.numProc * workItem + proc;
                            if (column >= this.targetSize) continue;
                            this.distRow[column] = this.distances[proc][workItem];
                            if (!this.isSymmetric) {
                                runningStatistics.addValue(this.distRow[column]);
                            } else if (column >= row) {
                                runningStatistics.addValue(this.distRow[column]);
                            }
                            if (!logger.isLoggable(Level.FINER)) continue;
                            logger.finer(String.format(" %d %d %14.8f", row, column, this.distances[proc][workItem]));
                        }
                    }
                }
                for (int workItem = 0; workItem < this.numWorkItems; ++workItem) {
                    int column = this.numProc * workItem + this.rank;
                    if (column >= this.targetSize) continue;
                    this.distRow[column] = this.distances[this.rank][workItem];
                    if (!this.isSymmetric) {
                        runningStatistics.addValue(this.distRow[column]);
                    } else if (column >= row) {
                        runningStatistics.addValue(this.distRow[column]);
                    }
                    if (!logger.isLoggable(Level.FINER)) continue;
                    logger.finer(String.format(" %d %d %14.8f", row, column, this.distances[this.rank][workItem]));
                }
            }
            catch (Exception ex) {
                logger.severe(" Exception collecting distance values." + String.valueOf(ex));
                logger.warning(String.valueOf(ex) + Utilities.stackTraceToString(ex));
            }
        } else {
            for (int i = 0; i < this.targetSize; ++i) {
                this.distRow[i] = this.myDistances[i];
                if (!this.isSymmetric) {
                    runningStatistics.addValue(this.distRow[i]);
                    continue;
                }
                if (i < row) continue;
                runningStatistics.addValue(this.distRow[i]);
            }
        }
    }

    private static double[] generateInflatedSphere(Crystal unitCell, double[] reducedCoords, int zPrime, int nAU, int linkage, double[] mass, int[] lmn, boolean strict, ArrayList<SymOp> symOps, ArrayList<Integer> indexOrder, double inflationFactor) {
        symOps.clear();
        indexOrder.clear();
        int nCoords = reducedCoords.length;
        int nAtoms = nCoords / 3;
        int zAtoms = nAtoms / zPrime;
        double[] x = new double[nAtoms];
        double[] y = new double[nAtoms];
        double[] z = new double[nAtoms];
        for (int i = 0; i < nAtoms; ++i) {
            int atomIndex = i * 3;
            x[i] = reducedCoords[atomIndex];
            y[i] = reducedCoords[atomIndex + 1];
            z[i] = reducedCoords[atomIndex + 2];
        }
        double volume = unitCell.volume / (double)unitCell.getNumSymOps() / (double)zPrime;
        double radius = FastMath.cbrt((double)(0.238732414637843 * volume * (double)FastMath.max((int)3, (int)nAU) * inflationFactor));
        Crystal replicatesCrystal = ReplicatesCrystal.replicatesCrystalFactory((Crystal)unitCell, (double)(radius * 2.0), (int[])lmn);
        int nSymm = replicatesCrystal.getNumSymOps();
        double[][] xS = new double[nSymm][nAtoms];
        double[][] yS = new double[nSymm][nAtoms];
        double[][] zS = new double[nSymm][nAtoms];
        int numEntities = nSymm * zPrime;
        double[][] cartCenterOfMass = new double[numEntities][3];
        List inflatedSymOps = replicatesCrystal.spaceGroup.symOps;
        for (int iSym = 0; iSym < nSymm; ++iSym) {
            SymOp symOp = (SymOp)inflatedSymOps.get(iSym);
            double[][] rot = new double[3][3];
            replicatesCrystal.getTransformationOperator(symOp, rot);
            replicatesCrystal.applySymOp(nAtoms, x, y, z, xS[iSym], yS[iSym], zS[iSym], symOp);
            for (int zp = 0; zp < zPrime; ++zp) {
                int i;
                int symIndex = zp * zAtoms;
                double[] centerOfMass = new double[3];
                double zMass = 0.0;
                for (int i2 = 0; i2 < zAtoms; ++i2) {
                    double m = mass[i2];
                    int coordIndex = symIndex + i2;
                    centerOfMass[0] = centerOfMass[0] + xS[iSym][coordIndex] * m;
                    centerOfMass[1] = centerOfMass[1] + yS[iSym][coordIndex] * m;
                    centerOfMass[2] = centerOfMass[2] + zS[iSym][coordIndex] * m;
                    zMass += m;
                }
                centerOfMass[0] = centerOfMass[0] / zMass;
                centerOfMass[1] = centerOfMass[1] / zMass;
                centerOfMass[2] = centerOfMass[2] / zMass;
                double[] translate = ProgressiveAlignmentOfCrystals.moveIntoCrystal(replicatesCrystal, centerOfMass);
                double[] trans = (double[])symOp.tr.clone();
                replicatesCrystal.toCartesianCoordinates(trans, trans);
                int translateLength = translate.length;
                for (i = 0; i < translateLength; ++i) {
                    int n = i;
                    trans[n] = trans[n] + translate[i];
                }
                symOps.add(new SymOp(rot, trans, symOp.replicatesVector));
                for (i = 0; i < zAtoms; ++i) {
                    int coordIndex = symIndex + i;
                    double[] dArray = xS[iSym];
                    int n = coordIndex;
                    dArray[n] = dArray[n] + translate[0];
                    centerOfMass[0] = centerOfMass[0] + translate[0];
                    double[] dArray2 = yS[iSym];
                    int n2 = coordIndex;
                    dArray2[n2] = dArray2[n2] + translate[1];
                    centerOfMass[1] = centerOfMass[1] + translate[1];
                    double[] dArray3 = zS[iSym];
                    int n3 = coordIndex;
                    dArray3[n3] = dArray3[n3] + translate[2];
                    centerOfMass[2] = centerOfMass[2] + translate[2];
                }
                cartCenterOfMass[iSym * zPrime + zp] = centerOfMass;
            }
        }
        Object[] auDist = new DoubleIndexPair[numEntities];
        double[] cartCenter = new double[3];
        double[] fracCenter = new double[]{0.5, 0.5, 0.5};
        replicatesCrystal.toCartesianCoordinates(fracCenter, cartCenter);
        if (logger.isLoggable(Level.FINER)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.finer(" Replicates crystal " + String.valueOf(replicatesCrystal));
            }
            logger.finer(String.format(" Replicates Volume: %8.4f", replicatesCrystal.volume));
            logger.finer(String.format(" Expanded Crystal Center: %14.8f %14.8f %14.8f", cartCenter[0], cartCenter[1], cartCenter[2]));
        }
        logger.fine(String.format(" Expanded Crystal Center: %14.8f %14.8f %14.8f", cartCenter[0], cartCenter[1], cartCenter[2]));
        for (int i = 0; i < numEntities; ++i) {
            auDist[i] = new DoubleIndexPair(i, DoubleMath.dist2((double[])cartCenter, (double[])cartCenterOfMass[i]));
        }
        Arrays.sort(auDist);
        for (Object molsDist : auDist) {
            indexOrder.add(molsDist.index());
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("\n Copy  SymOp        Distance");
        }
        double[] systemCoords = new double[numEntities * zAtoms * 3];
        for (int n = 0; n < nSymm; ++n) {
            for (int zp = 0; zp < zPrime; ++zp) {
                int index = n * zPrime + zp;
                int iSym = auDist[index].index();
                double distance = auDist[index].doubleValue();
                if (logger.isLoggable(Level.FINEST) && n < 30) {
                    logger.finest(String.format(" %4d  %5d  %14.8f", index, iSym, FastMath.sqrt((double)distance)));
                }
                for (int i = 0; i < zAtoms; ++i) {
                    int symIndex = index * zAtoms * 3;
                    int atomIndex = symIndex + i * 3;
                    int conversion = iSym / zPrime;
                    int shift = i + iSym % zPrime * zAtoms;
                    systemCoords[atomIndex] = xS[conversion][shift];
                    systemCoords[atomIndex + 1] = yS[conversion][shift];
                    systemCoords[atomIndex + 2] = zS[conversion][shift];
                }
            }
        }
        double massSum = Arrays.stream(mass).sum();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(String.format(" Checking replicates crystal.\n SysCoords: %3d (%3d)(%3d), reducedCoords Size: %3d (%3d)\n mass Size %3d, massSum: %6.3f, nAU: %2d, nCoords: %3d\n auDist Size: %3d, l: %2d, m: %2d, n: %2d, numEntities: %3d, nAtoms: %3d, zPrime: %3d, zAtoms: %3d", systemCoords.length, systemCoords.length / 3, systemCoords.length / 3 / zAtoms, reducedCoords.length, reducedCoords.length / 3, mass.length, massSum, nAU, nCoords, auDist.length, lmn[0], lmn[1], lmn[2], numEntities, nAtoms, zPrime, zAtoms));
        }
        if (strict && ProgressiveAlignmentOfCrystals.checkInflatedSphere(systemCoords, mass, massSum, zAtoms, nAU, linkage, lmn, symOps, indexOrder)) {
            systemCoords = ProgressiveAlignmentOfCrystals.generateInflatedSphere(unitCell, reducedCoords, zPrime, nAU, linkage, mass, lmn, true, symOps, indexOrder, inflationFactor += 5.0);
        }
        return systemCoords;
    }

    private static int guessZPrime(ArrayList<Integer> unique, int[] molNum, int numEntities) {
        int[] molSize = new int[numEntities];
        int nAtoms = molNum.length;
        for (int i = 0; i < nAtoms; ++i) {
            if (!unique.contains(i)) continue;
            int n = molNum[i];
            molSize[n] = molSize[n] + 1;
        }
        int z = switch (numEntities) {
            case 2 -> {
                if (molSize[0] == molSize[1]) {
                    yield 2;
                }
                yield 1;
            }
            case 3 -> {
                if (molSize[0] == molSize[1] && molSize[1] == molSize[2]) {
                    yield 3;
                }
                yield 1;
            }
            case 4 -> {
                if (molSize[0] == molSize[1] && molSize[1] == molSize[2] && molSize[2] == molSize[3]) {
                    yield 4;
                }
                if (molSize[0] == molSize[2] && molSize[1] == molSize[3]) {
                    yield 2;
                }
                yield 1;
            }
            case 5 -> {
                if (molSize[0] == molSize[1] && molSize[1] == molSize[2] && molSize[2] == molSize[3] && molSize[3] == molSize[4]) {
                    yield 5;
                }
                yield 1;
            }
            case 6 -> {
                if (molSize[0] == molSize[1] && molSize[1] == molSize[2] && molSize[2] == molSize[3] && molSize[3] == molSize[4] && molSize[4] == molSize[5]) {
                    yield 6;
                }
                if (molSize[0] == molSize[2] && molSize[2] == molSize[4] && molSize[1] == molSize[3] && molSize[3] == molSize[5]) {
                    yield 3;
                }
                if (molSize[0] == molSize[3] && molSize[1] == molSize[4] && molSize[2] == molSize[5]) {
                    yield 2;
                }
                yield 1;
            }
            default -> 1;
        };
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(String.format(" Number of species in asymmetric unit (Z Prime): %d", z));
        }
        return z;
    }

    private static boolean invalidAtomSelection(ArrayList<Integer> indices, Atom[] atoms, boolean alphaCarbons, boolean includeHydrogen) {
        ArrayList<Integer> unique = new ArrayList<Integer>();
        for (Integer value : indices) {
            if (unique.contains(value)) continue;
            unique.add(value);
        }
        indices.clear();
        ProgressiveAlignmentOfCrystals.determineComparableAtoms(atoms, indices, unique, alphaCarbons, includeHydrogen);
        return indices.isEmpty();
    }

    public static String matrixToString(double[][] matrix, int index, String description) {
        StringBuilder value = new StringBuilder(String.format("\n %s %d: ", description, index));
        for (double[] doubles : matrix) {
            value.append(String.format("\n\t%s", Arrays.toString(doubles)));
        }
        value.append("\n");
        return value.toString();
    }

    private static double[] moveIntoCrystal(Crystal crystal, double[] com) {
        double[] translate = new double[3];
        double[] currentCoM = new double[]{com[0], com[1], com[2]};
        crystal.toFractionalCoordinates(com, translate);
        translate[0] = ScalarMath.mod((double)translate[0], (double)1.0);
        translate[1] = ScalarMath.mod((double)translate[1], (double)1.0);
        translate[2] = ScalarMath.mod((double)translate[2], (double)1.0);
        crystal.toCartesianCoordinates(translate, translate);
        com[0] = translate[0];
        com[1] = translate[1];
        com[2] = translate[2];
        translate[0] = translate[0] - currentCoM[0];
        translate[1] = translate[1] - currentCoM[1];
        translate[2] = translate[2] - currentCoM[2];
        return translate;
    }

    private void numberUniqueAUs(double[] allCoords, DoubleIndexPair[] auDist, double[] auCoords, int nCoords, int upperLimit, boolean strict, int nAUinReplicates, double[] massN, double matchTol) {
        int numConfCheck;
        ArrayList<Double> uniqueDiffs = new ArrayList<Double>();
        ArrayList<double[]> tempListXYZ = new ArrayList<double[]>();
        this.tempListIndices.add(0);
        uniqueDiffs.add(Superpose.rmsd(auCoords, auCoords, massN));
        tempListXYZ.add(auCoords);
        int index = 1;
        boolean useSym = this.printSym >= 0.0;
        int n = numConfCheck = strict || upperLimit <= 0 || useSym ? nAUinReplicates : upperLimit;
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("RMSD Differences in Replicates Crystal:");
        }
        double[] target = new double[nCoords];
        System.arraycopy(tempListXYZ.get(0), 0, target, 0, nCoords);
        Superpose.translate(target, massN);
        while (uniqueDiffs.size() < numConfCheck) {
            double[] baseCheckMol = new double[nCoords];
            int auIndex = auDist[index].index();
            System.arraycopy(allCoords, auIndex * nCoords, baseCheckMol, 0, nCoords);
            Superpose.translate(baseCheckMol, massN);
            Superpose.rotate(target, baseCheckMol, massN);
            double value = Superpose.rmsd(target, baseCheckMol, massN);
            if (ProgressiveAlignmentOfCrystals.addLooseUnequal(uniqueDiffs, value, matchTol) || useSym) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest(String.format(" Sorted Index: %4d  Dist: %18.16f", auIndex, value));
                }
                this.tempListIndices.add(index);
                tempListXYZ.add(baseCheckMol);
            }
            if (++index < auDist.length) continue;
            break;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer(" RMSD_1 from 1st AU:\n i RMSD     AU Index");
            int numUnique = uniqueDiffs.size();
            for (int i = 0; i < numUnique; ++i) {
                logger.finer(String.format(" %d %4.4f    %4d", i, uniqueDiffs.get(i), auDist[this.tempListIndices.get(i)].index()));
            }
        }
    }

    private void pairEntities(int desiredAUs, int comparisonNum) {
        int i;
        this.tempListIndices.clear();
        for (DoubleIndexPair doubleIndexPair : this.targetAUDist_2) {
            this.tempListIndices.add(doubleIndexPair.index());
        }
        for (i = 0; i < desiredAUs; ++i) {
            double minDist = Double.MAX_VALUE;
            Integer minIndex = -1;
            double[] baseCoMCurr = this.baseCoM[comparisonNum][this.baseAUDist_2[i].index()];
            for (Integer target : this.tempListIndices) {
                double dist = DoubleMath.dist2((double[])baseCoMCurr, (double[])this.targetCoM[target]);
                if (dist < minDist) {
                    minIndex = target;
                    minDist = dist;
                }
                if (!(FastMath.abs((double)minDist) < 1.0E-12)) continue;
                if (!logger.isLoggable(Level.FINEST)) break;
                this.stringBuilder.append("\n \tExit out of match loop.\n");
                break;
            }
            this.pairedAUs[i] = new DoubleIndexPair(minIndex.intValue(), minDist);
            if (!this.tempListIndices.remove(minIndex)) {
                logger.warning(String.format(" Index value of %d was not found (%4.4f).", minIndex, minDist));
            }
            if (!logger.isLoggable(Level.FINEST)) continue;
            this.stringBuilder.append(String.format("\n Base position:   %d: %8.4f %8.4f %8.4f\n", i, this.baseCoM[comparisonNum][this.baseAUDist_2[i].index()][0], this.baseCoM[comparisonNum][this.baseAUDist_2[i].index()][1], this.baseCoM[comparisonNum][this.baseAUDist_2[i].index()][2]));
            this.stringBuilder.append(String.format(" Match Distance:  %d: %8.4f\n", i, FastMath.sqrt((double)this.pairedAUs[i].doubleValue())));
            int pairedIndex = this.pairedAUs[i].index();
            this.stringBuilder.append(String.format(" Target position: %d: %8.4f %8.4f %8.4f\n", i, this.targetCoM[pairedIndex][0], this.targetCoM[pairedIndex][1], this.targetCoM[pairedIndex][2]));
        }
        if (logger.isLoggable(Level.FINER)) {
            this.stringBuilder.append("  Distance between pairs:\n Index  Base Index  Target Index    Match Index    Distance\n");
            for (i = 0; i < desiredAUs; ++i) {
                this.stringBuilder.append(String.format(" %5d %10d %14d %14d %10.4f\n", i, this.baseAUDist_2[i].index(), this.targetAUDist_2[i].index(), this.pairedAUs[i].index(), FastMath.sqrt((double)this.pairedAUs[i].doubleValue())));
            }
        }
    }

    private void printSym(int compareAtomsSize, File file, String name, List<Bond> bondList, Atom[] atoms, ForceField forceField, int saveClusters, int currZ2) {
        double[][] tempTransform = new double[4][4];
        ProgressiveAlignmentOfCrystals.copyArrayValues(tempTransform, this.targetTransformSymOp.asMatrix());
        ProgressiveAlignmentOfCrystals.addTranslation(this.targetSymOp.tr, tempTransform, true);
        this.addRotation(this.targetSymOp.rot, tempTransform, true);
        double[] bestTranslation = new double[]{tempTransform[0][3] / tempTransform[3][3], tempTransform[1][3] / tempTransform[3][3], tempTransform[2][3] / tempTransform[3][3]};
        SymOp symOp = new SymOp((double[][])Arrays.copyOf(tempTransform, 3), bestTranslation);
        double[] newMol = new double[compareAtomsSize * 3];
        StringBuilder printString = new StringBuilder();
        Object title = String.format("\n Print Current Symmetry Operator (Z'=%2d):\n \t Original Coords \t\t  Current Coords \t==\t Applied Sym Op Coords", currZ2);
        double[] originalAU = this.targetAUoriginal[currZ2];
        for (int i = 0; i < compareAtomsSize; ++i) {
            int k = i * 3;
            double[] xyz = new double[]{originalAU[k], originalAU[k + 1], originalAU[k + 2]};
            SymOp.applyCartesianSymOp((double[])xyz, (double[])xyz, (SymOp)symOp);
            newMol[k] = xyz[0];
            newMol[k + 1] = xyz[1];
            newMol[k + 2] = xyz[2];
            printString.append(String.format("\n %9.3f %9.3f %9.3f to %9.3f %9.3f %9.3f to %9.3f %9.3f %9.3f", originalAU[k], originalAU[k + 1], originalAU[k + 2], this.targetAU[k], this.targetAU[k + 1], this.targetAU[k + 2], newMol[k], newMol[k + 1], newMol[k + 2]));
        }
        title = (String)title + String.format("    RMSD: %9.3f (should be 0.000)", Superpose.rmsd(newMol, this.targetAU, this.massN));
        this.stringBuilder.append((String)title).append((CharSequence)printString);
        this.saveAssembly(file, name, bondList, atoms, forceField, newMol, this.comparisonAtoms, 1, "_moveMethod", 0, saveClusters);
        this.stringBuilder.append("\n").append(symOp).append("\n");
    }

    private static void prioritizeReplicates(double[] coordsXYZ, double[][] centerOfMasses, int nAtoms, DoubleIndexPair[] auDist, int index, int linkage) {
        int length = coordsXYZ.length;
        int nCoords = nAtoms * 3;
        int nMols = length / nCoords;
        if (auDist.length != nMols) {
            logger.warning(" Number of molecules does not match distance sort array length.");
        }
        if (linkage == 0) {
            int centerIndex = index * nCoords;
            for (int i = 0; i < nMols; ++i) {
                double tempDist = Double.MAX_VALUE;
                int molIndex = i * nCoords;
                for (int j = 0; j < nAtoms; ++j) {
                    int centerAtomIndex = centerIndex + j * 3;
                    double[] centerXYZ = new double[]{coordsXYZ[centerAtomIndex], coordsXYZ[centerAtomIndex + 1], coordsXYZ[centerAtomIndex + 2]};
                    for (int k = 0; k < nAtoms; ++k) {
                        int atomIndex = molIndex + k * 3;
                        double[] dArray = new double[]{coordsXYZ[atomIndex], coordsXYZ[atomIndex + 1], coordsXYZ[atomIndex + 2]};
                        double[] xyz = dArray;
                        double currDist = DoubleMath.dist2((double[])centerXYZ, (double[])xyz);
                        if (currDist < tempDist) {
                            tempDist = currDist;
                        }
                        if (FastMath.abs((double)tempDist) < 1.0E-12) break;
                    }
                    if (FastMath.abs((double)tempDist) < 1.0E-12) break;
                }
                auDist[i] = new DoubleIndexPair(i, tempDist);
            }
            Arrays.sort(auDist);
        } else if (linkage == 1) {
            int i;
            double[] coordCenter = centerOfMasses[index];
            for (int i2 = 0; i2 < nMols; ++i2) {
                double[] moleculeCenter = centerOfMasses[i2];
                auDist[i2] = new DoubleIndexPair(i2, DoubleMath.dist2((double[])coordCenter, (double[])moleculeCenter));
            }
            Arrays.sort(auDist);
            Object[] molDists = new DoubleIndexPair[nMols];
            int auIndex0 = auDist[0].index();
            int auIndex1 = auDist[1].index();
            molDists[0] = new DoubleIndexPair(auIndex0, auDist[0].doubleValue());
            double[] avgCenter = new double[]{(centerOfMasses[auIndex0][0] + centerOfMasses[auIndex1][0]) / 2.0, (centerOfMasses[auIndex0][1] + centerOfMasses[auIndex1][1]) / 2.0, (centerOfMasses[auIndex0][2] + centerOfMasses[auIndex1][2]) / 2.0};
            for (int i3 = 1; i3 < nMols; ++i3) {
                auIndex0 = auDist[i3].index();
                double[] moleculeCenter = centerOfMasses[auIndex0];
                molDists[i3] = new DoubleIndexPair(auIndex0, DoubleMath.dist2((double[])avgCenter, (double[])moleculeCenter));
            }
            Arrays.sort(molDists);
            Object[] molDists3 = new DoubleIndexPair[nMols];
            molDists3[0] = new DoubleIndexPair(molDists[0].index(), molDists[0].doubleValue());
            molDists3[1] = new DoubleIndexPair(molDists[1].index(), molDists[1].doubleValue());
            avgCenter = new double[3];
            int bound = FastMath.min((int)3, (int)molDists.length);
            for (i = 0; i < bound; ++i) {
                int molIndex = molDists[i].index();
                avgCenter[0] = avgCenter[0] + centerOfMasses[molIndex][0];
                avgCenter[1] = avgCenter[1] + centerOfMasses[molIndex][1];
                avgCenter[2] = avgCenter[2] + centerOfMasses[molIndex][2];
            }
            i = 0;
            while (i < 3) {
                int n = i++;
                avgCenter[n] = avgCenter[n] / 3.0;
            }
            for (i = 2; i < nMols; ++i) {
                auIndex0 = molDists[i].index();
                double[] moleculeCenter = centerOfMasses[auIndex0];
                molDists3[i] = new DoubleIndexPair(auIndex0, DoubleMath.dist2((double[])avgCenter, (double[])moleculeCenter));
            }
            Arrays.sort(molDists3);
            System.arraycopy(molDists3, 0, auDist, 0, nMols);
        } else if (linkage == 2) {
            int centerIndex = index * nCoords;
            for (int i = 0; i < nMols; ++i) {
                double tempDist = 0.0;
                int molIndex = i * nCoords;
                for (int j = 0; j < nAtoms; ++j) {
                    int centerAtomIndex = centerIndex + j * 3;
                    double[] centerXYZ = new double[]{coordsXYZ[centerAtomIndex], coordsXYZ[centerAtomIndex + 1], coordsXYZ[centerAtomIndex + 2]};
                    for (int k = 0; k < nAtoms; ++k) {
                        int atomIndex = molIndex + k * 3;
                        double[] dArray = new double[]{coordsXYZ[atomIndex], coordsXYZ[atomIndex + 1], coordsXYZ[atomIndex + 2]};
                        double[] xyz = dArray;
                        double currDist = DoubleMath.dist2((double[])centerXYZ, (double[])xyz);
                        if (currDist > tempDist) {
                            tempDist = currDist;
                        }
                        if (FastMath.abs((double)tempDist) < 1.0E-12) break;
                    }
                    if (FastMath.abs((double)tempDist) < 1.0E-12) break;
                }
                auDist[i] = new DoubleIndexPair(i, tempDist);
            }
            Arrays.sort(auDist);
        } else {
            logger.severe(String.format(" Linkage value of %d was unrecognized. Try 0 (, 1, or 2.", linkage));
        }
    }

    private RunningStatistics readMatrix(String filename) {
        this.restartRow = 0;
        this.restartColumn = 0;
        DistanceMatrixFilter distanceMatrixFilter = new DistanceMatrixFilter();
        RunningStatistics runningStatistics = distanceMatrixFilter.readDistanceMatrix(filename, this.baseSize, this.targetSize);
        if (runningStatistics != null && runningStatistics.getCount() > 0L) {
            this.restartRow = distanceMatrixFilter.getRestartRow();
            this.restartColumn = distanceMatrixFilter.getRestartColumn();
            if (this.isSymmetric) {
                if (this.restartRow == this.baseSize && this.restartColumn == 1) {
                    logger.info(String.format(" Complete symmetric distance matrix found (%d x %d).", this.restartRow, this.restartRow));
                } else {
                    this.restartColumn = 0;
                    logger.info(String.format(" Incomplete symmetric distance matrix found.\n Restarting at row %d, column %d.", this.restartRow + 1, this.restartColumn + 1));
                }
            } else if (this.restartRow == this.baseSize && this.restartColumn == this.targetSize) {
                logger.info(String.format(" Complete distance matrix found (%d x %d).", this.restartRow, this.restartColumn));
            } else {
                this.restartColumn = 0;
                logger.info(String.format(" Incomplete distance matrix found.\n Restarting at row %d, column %d.", this.restartRow + 1, this.restartColumn + 1));
            }
        }
        return runningStatistics;
    }

    private static double[] reduceSystem(Atom[] atoms, int[] comparisonAtoms) {
        double[] reducedCoords = new double[comparisonAtoms.length * 3];
        int coordIndex = 0;
        int[] nArray = comparisonAtoms;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer value = nArray[i];
            Atom atom = atoms[value];
            reducedCoords[coordIndex++] = atom.getX();
            reducedCoords[coordIndex++] = atom.getY();
            reducedCoords[coordIndex++] = atom.getZ();
        }
        return reducedCoords;
    }

    private void saveAssembly(File file, String name, List<Bond> bondList, Atom[] atoms, ForceField forceField0, double[] coords, int[] comparisonAtoms, int nAU, String description, int compNum, int saveClusters) {
        File saveLocation;
        String fileName = FilenameUtils.removeExtension((String)file.getName());
        if (saveClusters == 2) {
            saveLocation = new File(fileName + description + ".xyz");
        } else if (saveClusters == 1) {
            saveLocation = new File(fileName + description + ".pdb");
        } else {
            return;
        }
        MolecularAssembly currentAssembly = new MolecularAssembly(name);
        ArrayList<Atom> newAtomList = new ArrayList<Atom>();
        int atomIndex = 1;
        int nCoords = coords.length / nAU;
        try {
            for (int n = 0; n < nAU; ++n) {
                ArrayList<Atom> atomList = new ArrayList<Atom>();
                int atomValue = 0;
                int[] atomSelection = new int[nCoords / 3];
                System.arraycopy(comparisonAtoms, 0, atomSelection, 0, nCoords / 3);
                Object object = atomSelection;
                int n2 = ((int[])object).length;
                for (int i = 0; i < n2; ++i) {
                    Integer i2 = object[i];
                    Atom a = atoms[i2];
                    double[] xyz = new double[3];
                    int coordIndex = n * nCoords + atomValue;
                    xyz[0] = coords[coordIndex];
                    xyz[1] = coords[coordIndex + 1];
                    xyz[2] = coords[coordIndex + 2];
                    Atom atom = new Atom(atomIndex++, a.getName(), a.getAtomType(), xyz);
                    atomList.add(atom);
                    atomValue += 3;
                }
                if (saveClusters == 2) {
                    object = bondList.iterator();
                    while (object.hasNext()) {
                        Atom newA2;
                        Atom newA1;
                        Bond bond = (Bond)object.next();
                        Atom a1 = bond.getAtom(0);
                        Atom a2 = bond.getAtom(1);
                        int a1Ind = a1.getIndex() - 1;
                        int a2Ind = a2.getIndex() - 1;
                        if (!IntStream.of(comparisonAtoms).anyMatch(x -> x == a1Ind) || !IntStream.of(comparisonAtoms).anyMatch(x -> x == a2Ind) || (newA1 = (Atom)atomList.get(a1Ind)).isBonded(newA2 = (Atom)atomList.get(a2Ind)) && newA2.isBonded(newA1)) continue;
                        Bond b = new Bond(newA1, newA2);
                        b.setBondType(bond.getBondType());
                    }
                }
                newAtomList.addAll(atomList);
            }
        }
        catch (Exception exception) {
            this.stringBuilder.append("\n Error saving moved coordinates to PDB.\n").append(exception).append("\n");
            logger.warning(String.valueOf(exception) + Utilities.stackTraceToString(exception));
        }
        if (logger.isLoggable(Level.FINEST)) {
            int newSize = newAtomList.size();
            this.stringBuilder.append(String.format("\n Save Num AU: %3d", nAU));
            this.stringBuilder.append(String.format("\n Save Num Active: %3d", nCoords));
            this.stringBuilder.append(String.format("\n Save Num Coords: %3d", coords.length));
            this.stringBuilder.append(String.format("\n Save Assembly Length: %3d", newSize));
            if (newSize > 0) {
                Atom zero = newAtomList.get(0);
                this.stringBuilder.append(String.format("\n Save Assembly First Atom: %3s %9.3f %9.3f %9.3f\n", zero.getName(), zero.getX(), zero.getY(), zero.getZ()));
            } else {
                this.stringBuilder.append("\n WARNING: New list containing new atoms was empty.\n");
            }
        }
        ForceField forceField = new ForceField(forceField0.getProperties());
        forceField.clearProperty("a-axis");
        forceField.clearProperty("b-axis");
        forceField.clearProperty("c-axis");
        forceField.clearProperty("alpha");
        forceField.clearProperty("beta");
        forceField.clearProperty("gamma");
        forceField.clearProperty("spacegroup");
        currentAssembly.setForceField(forceField);
        Utilities.biochemistry(currentAssembly, newAtomList);
        currentAssembly.setFile(file);
        if (saveClusters == 2) {
            block25: {
                File key = new File(fileName + ".key");
                File properties = new File(fileName + ".properties");
                if (key.exists()) {
                    File keyComparison = new File(fileName + description + ".key");
                    try {
                        if (keyComparison.createNewFile()) {
                            FileUtils.copyFile((File)key, (File)keyComparison);
                            break block25;
                        }
                        this.stringBuilder.append("\n Could not create properties file.\n");
                    }
                    catch (Exception ex) {
                        if (logger.isLoggable(Level.FINER)) {
                            this.stringBuilder.append(ex);
                            logger.warning(String.valueOf(ex) + Utilities.stackTraceToString(ex));
                        }
                        break block25;
                    }
                }
                if (properties.exists()) {
                    File propertiesComparison = new File(fileName + description + ".properties");
                    try {
                        if (propertiesComparison.createNewFile()) {
                            FileUtils.copyFile((File)properties, (File)propertiesComparison);
                        } else {
                            this.stringBuilder.append("\n Could not create properties file.\n");
                        }
                    }
                    catch (Exception ex) {
                        this.stringBuilder.append("\n Neither key nor properties file detected therefore only creating XYZ.\n");
                        if (!logger.isLoggable(Level.FINER)) break block25;
                        this.stringBuilder.append(ex);
                        logger.warning(String.valueOf(ex) + Utilities.stackTraceToString(ex));
                    }
                }
            }
            XYZFilter xyzFilter = new XYZFilter(saveLocation, currentAssembly, forceField, currentAssembly.getProperties());
            xyzFilter.writeFile(saveLocation, true);
        } else {
            PDBFilter pdbfilter = new PDBFilter(saveLocation, currentAssembly, forceField, currentAssembly.getProperties());
            pdbfilter.setModelNumbering(compNum);
            pdbfilter.writeFile(saveLocation, true, false, false);
        }
        currentAssembly.destroy();
    }

    private void saveAssembly(File file, String name, List<Bond> bondList, Atom[] atoms, ForceField forceField, double[] coords, int[] comparisonAtoms, int nAU, String description, double finalRMSD, int compNum, int saveClusters) {
        this.saveAssembly(file, name, bondList, atoms, forceField, coords, comparisonAtoms, nAU, description, compNum, saveClusters);
        String fileName = FilenameUtils.removeExtension((String)file.getName());
        try {
            File csv = PDBFilter.version(new File(fileName + description + ".csv"));
            if (csv.createNewFile()) {
                BufferedWriter bw = new BufferedWriter(new FileWriter(csv, false));
                bw.append("rms\n");
                bw.append(String.format("%4.4f\n", finalRMSD));
                bw.close();
            } else {
                logger.warning(" Could not create CSV file \"" + csv.getName() + "\"");
            }
        }
        catch (Exception ex) {
            logger.info(String.valueOf(ex) + Utilities.stackTraceToString(ex));
        }
    }
}

