/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.utils;

import ffx.potential.ForceFieldEnergy;
import ffx.potential.MolecularAssembly;
import ffx.potential.Utilities;
import ffx.potential.bonded.RotamerLibrary;
import ffx.potential.parameters.ForceField;
import ffx.potential.parsers.ARCFileFilter;
import ffx.potential.parsers.FileOpener;
import ffx.potential.parsers.ForceFieldFilter;
import ffx.potential.parsers.INTFileFilter;
import ffx.potential.parsers.INTFilter;
import ffx.potential.parsers.PDBFileFilter;
import ffx.potential.parsers.PDBFilter;
import ffx.potential.parsers.SystemFilter;
import ffx.potential.parsers.XYZFileFilter;
import ffx.potential.parsers.XYZFilter;
import ffx.utilities.Keyword;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.configuration2.CompositeConfiguration;
import org.apache.commons.io.FilenameUtils;

public class PotentialsFileOpener
implements FileOpener {
    private static final Logger logger = Logger.getLogger(PotentialsFileOpener.class.getName());
    private final File file;
    private final Path filepath;
    private final File[] allFiles;
    private final Path[] allPaths;
    private int nThreads = -1;
    private final List<MolecularAssembly> assemblies;
    private final List<CompositeConfiguration> propertyList;
    private MolecularAssembly activeAssembly;
    private CompositeConfiguration activeProperties;
    private SystemFilter filter;
    private List<PDBFilter.Mutation> mutationsToApply;

    public PotentialsFileOpener(File file) {
        Path absPath;
        Path pwdPath;
        if (!file.exists() || !file.isFile()) {
            throw new IllegalArgumentException(String.format(" File %s either did not exist or was not a file.", file.getName()));
        }
        this.file = file;
        try {
            pwdPath = Paths.get(new File("").getCanonicalPath(), new String[0]);
        }
        catch (IOException ex) {
            pwdPath = Paths.get(new File("").getAbsolutePath(), new String[0]);
        }
        try {
            absPath = Paths.get(file.getCanonicalPath(), new String[0]);
        }
        catch (IOException ex) {
            absPath = Paths.get(file.getAbsolutePath(), new String[0]);
        }
        this.filepath = pwdPath.relativize(absPath);
        this.allFiles = new File[1];
        this.allFiles[0] = this.file;
        this.allPaths = new Path[1];
        this.allPaths[0] = this.filepath;
        this.assemblies = new ArrayList<MolecularAssembly>();
        this.propertyList = new ArrayList<CompositeConfiguration>();
    }

    PotentialsFileOpener(String filename) {
        this(new File(filename));
    }

    PotentialsFileOpener(String[] filenames) {
        Path pwdPath;
        if (filenames == null) {
            throw new IllegalArgumentException(" Array of files to be opened was null.");
        }
        int numFiles = filenames.length;
        if (numFiles == 0) {
            throw new IllegalArgumentException(" Array of files to be opened was empty.");
        }
        ArrayList<File> fileList = new ArrayList<File>();
        ArrayList<Path> pathList = new ArrayList<Path>();
        try {
            pwdPath = Paths.get(new File("").getCanonicalPath(), new String[0]);
        }
        catch (IOException ex) {
            pwdPath = Paths.get(new File("").getAbsolutePath(), new String[0]);
        }
        for (String filename : filenames) {
            try {
                Path absPath;
                File tryFile = new File(filename);
                if (!tryFile.exists() || !tryFile.isFile()) continue;
                try {
                    absPath = Paths.get(tryFile.getCanonicalPath(), new String[0]);
                }
                catch (IOException ex) {
                    absPath = Paths.get(tryFile.getAbsolutePath(), new String[0]);
                }
                Path thisPath = pwdPath.relativize(absPath);
                fileList.add(tryFile);
                pathList.add(thisPath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        int numAccepted = fileList.size();
        if (numAccepted < 1) {
            throw new IllegalArgumentException(" No valid files could be found to open.");
        }
        this.allFiles = fileList.toArray(new File[numAccepted]);
        this.allPaths = pathList.toArray(new Path[numAccepted]);
        this.file = this.allFiles[0];
        this.filepath = this.allPaths[0];
        this.assemblies = new ArrayList<MolecularAssembly>();
        this.propertyList = new ArrayList<CompositeConfiguration>();
    }

    @Override
    public MolecularAssembly[] getAllAssemblies() {
        return this.assemblies.toArray(new MolecularAssembly[0]);
    }

    @Override
    public CompositeConfiguration[] getAllProperties() {
        return this.propertyList.toArray(new CompositeConfiguration[0]);
    }

    @Override
    public MolecularAssembly getAssembly() {
        return this.activeAssembly;
    }

    public SystemFilter getFilter() {
        return this.filter;
    }

    @Override
    public CompositeConfiguration getProperties() {
        return this.activeProperties;
    }

    @Override
    public void run() {
        int numFiles = this.allFiles.length;
        for (int i = 0; i < numFiles; ++i) {
            String[] patches;
            File fileI = this.allFiles[i];
            Path pathI = this.allPaths[i];
            MolecularAssembly assembly = new MolecularAssembly(pathI.toString());
            assembly.setFile(fileI);
            CompositeConfiguration properties = Keyword.loadProperties((File)fileI);
            ForceFieldFilter forceFieldFilter = new ForceFieldFilter(properties);
            ForceField forceField = forceFieldFilter.parse();
            for (String patch : patches = properties.getStringArray("patch")) {
                logger.info(" Attempting to read force field patch from " + patch + ".");
                CompositeConfiguration patchConfiguration = new CompositeConfiguration();
                try {
                    patchConfiguration.addProperty("propertyFile", (Object)fileI.getCanonicalPath());
                }
                catch (IOException e) {
                    logger.log(Level.INFO, " Error loading {0}.", patch);
                }
                patchConfiguration.addProperty("parameters", (Object)patch);
                forceFieldFilter = new ForceFieldFilter(patchConfiguration);
                ForceField patchForceField = forceFieldFilter.parse();
                forceField.append(patchForceField);
                if (!RotamerLibrary.addRotPatch(patch)) continue;
                logger.info(String.format(" Loaded rotamer definitions from patch %s.", patch));
            }
            assembly.setForceField(forceField);
            if (new PDBFileFilter().acceptDeep(fileI)) {
                this.filter = new PDBFilter(fileI, assembly, forceField, properties);
            } else if (new XYZFileFilter().acceptDeep(fileI)) {
                this.filter = new XYZFilter(fileI, assembly, forceField, properties);
            } else if (new INTFileFilter().acceptDeep(fileI) || new ARCFileFilter().accept(fileI)) {
                this.filter = new INTFilter(fileI, assembly, forceField, properties);
            } else {
                throw new IllegalArgumentException(String.format(" File %s could not be recognized as a valid PDB, XYZ, INT, or ARC file.", pathI));
            }
            if (this.mutationsToApply != null && !this.mutationsToApply.isEmpty()) {
                if (!(this.filter instanceof PDBFilter)) {
                    throw new UnsupportedOperationException("Applying mutations during open only supported by PDB filter atm.");
                }
                ((PDBFilter)this.filter).mutate(this.mutationsToApply);
            }
            if (this.filter.readFile()) {
                if (!(this.filter instanceof PDBFilter)) {
                    Utilities.biochemistry(assembly, this.filter.getAtomList());
                }
                this.filter.applyAtomProperties();
                assembly.finalize(true, forceField);
                ForceFieldEnergy energy = this.nThreads > 0 ? ForceFieldEnergy.energyFactory(assembly, this.nThreads) : ForceFieldEnergy.energyFactory(assembly);
                assembly.setPotential(energy);
                this.assemblies.add(assembly);
                this.propertyList.add(properties);
                SystemFilter systemFilter = this.filter;
                if (!(systemFilter instanceof PDBFilter)) continue;
                PDBFilter pdbFilter = (PDBFilter)systemFilter;
                List<Character> altLocs = pdbFilter.getAltLocs();
                if (altLocs.size() > 1 || altLocs.get(0).charValue() != ' ') {
                    StringBuilder altLocString = new StringBuilder("\n Alternate locations found [ ");
                    for (Character c : altLocs) {
                        if (c.charValue() == ' ') continue;
                        altLocString.append(String.format("(%s) ", c));
                    }
                    altLocString.append("]\n");
                    logger.info(altLocString.toString());
                }
                for (Character c : altLocs) {
                    if (c.equals(Character.valueOf(' ')) || c.equals(Character.valueOf('A'))) continue;
                    MolecularAssembly newAssembly = new MolecularAssembly(pathI.toString());
                    newAssembly.setFile(fileI);
                    newAssembly.setForceField(assembly.getForceField());
                    pdbFilter.setAltID(newAssembly, c);
                    pdbFilter.clearSegIDs();
                    if (!pdbFilter.readFile()) continue;
                    String fileName = assembly.getFile().getAbsolutePath();
                    newAssembly.setName(FilenameUtils.getBaseName((String)fileName) + " " + c);
                    this.filter.applyAtomProperties();
                    newAssembly.finalize(true, assembly.getForceField());
                    energy = this.nThreads > 0 ? ForceFieldEnergy.energyFactory(assembly, this.nThreads) : ForceFieldEnergy.energyFactory(assembly);
                    newAssembly.setPotential(energy);
                    this.assemblies.add(newAssembly);
                }
                continue;
            }
            logger.warning(String.format(" Failed to read file %s", fileI));
        }
        this.activeAssembly = this.assemblies.get(0);
        this.activeProperties = this.propertyList.get(0);
    }

    void setMutations(List<PDBFilter.Mutation> mutations) {
        this.mutationsToApply = mutations;
    }

    void setNThreads(int nThreads) {
        this.nThreads = nThreads;
    }
}

