/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.utils;

import ffx.numerics.math.DoubleMath;
import ffx.potential.bonded.SturmMethod;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.util.FastMath;

public class LoopClosure {
    private static final Logger logger = Logger.getLogger(LoopClosure.class.getName());
    private static final int MAX_SOLUTIONS = 16;
    private static final double[] BOND_LENS;
    private static final double[] BOND_ANGLES;
    private static final double AA_LEN;
    private static final double AA13_MIN_SQR;
    private static final double AA13_MAX_SQR;
    private static final double[] XI;
    private static final double[] DELTA;
    private static final double[] ETA;
    private final double[] alpha = new double[3];
    private final double[] theta = new double[3];
    private final double[] cos_alpha = new double[3];
    private final double[] sin_alpha = new double[3];
    private final double[] cos_theta = new double[3];
    private final double[] cos_delta = new double[4];
    private final double[] sin_delta = new double[4];
    private final double[] cos_xi = new double[3];
    private final double[] cos_eta = new double[3];
    private final double[] sin_xi = new double[3];
    private final double[] sin_eta = new double[3];
    private final double[] r_a1a3 = new double[3];
    private final double[] r_a1n1 = new double[3];
    private final double[] r_a3c3 = new double[3];
    private final double[] b_a1a3 = new double[3];
    private final double[] b_a1n1 = new double[3];
    private final double[] b_a3c3 = new double[3];
    private final double[] len_na = new double[3];
    private final double[] len_ac = new double[3];
    private final double[][] C0 = new double[3][3];
    private final double[][] C1 = new double[3][3];
    private final double[][] C2 = new double[3][3];
    private final double[][] Q = new double[5][17];
    private final double[][] R = new double[3][17];

    public double calcT1(double t0, double t2) {
        double t0_2 = t0 * t0;
        double t2_2 = t2 * t2;
        double U11 = this.C0[0][0] + this.C0[0][1] * t0 + this.C0[0][2] * t0_2;
        double U12 = this.C1[0][0] + this.C1[0][1] * t0 + this.C1[0][2] * t0_2;
        double U13 = this.C2[0][0] + this.C2[0][1] * t0 + this.C2[0][2] * t0_2;
        double U31 = this.C0[1][0] + this.C0[1][1] * t2 + this.C0[1][2] * t2_2;
        double U32 = this.C1[1][0] + this.C1[1][1] * t2 + this.C1[1][2] * t2_2;
        double U33 = this.C2[1][0] + this.C2[1][1] * t2 + this.C2[1][2] * t2_2;
        return (U31 * U13 - U11 * U33) / (U12 * U33 - U13 * U32);
    }

    public double calcT2(double t0) {
        double t0_2 = t0 * t0;
        double t0_3 = t0_2 * t0;
        double t0_4 = t0_3 * t0;
        double A0 = this.Q[0][0] + this.Q[0][1] * t0 + this.Q[0][2] * t0_2 + this.Q[0][3] * t0_3 + this.Q[0][4] * t0_4;
        double A1 = this.Q[1][0] + this.Q[1][1] * t0 + this.Q[1][2] * t0_2 + this.Q[1][3] * t0_3 + this.Q[1][4] * t0_4;
        double A2 = this.Q[2][0] + this.Q[2][1] * t0 + this.Q[2][2] * t0_2 + this.Q[2][3] * t0_3 + this.Q[2][4] * t0_4;
        double A3 = this.Q[3][0] + this.Q[3][1] * t0 + this.Q[3][2] * t0_2 + this.Q[3][3] * t0_3 + this.Q[3][4] * t0_4;
        double A4 = this.Q[4][0] + this.Q[4][1] * t0 + this.Q[4][2] * t0_2 + this.Q[4][3] * t0_3 + this.Q[4][4] * t0_4;
        double B0 = this.R[0][0] + this.R[0][1] * t0 + this.R[0][2] * t0_2;
        double B1 = this.R[1][0] + this.R[1][1] * t0 + this.R[1][2] * t0_2;
        double B2 = this.R[2][0] + this.R[2][1] * t0 + this.R[2][2] * t0_2;
        double B2_2 = B2 * B2;
        double B2_3 = B2_2 * B2;
        double K0 = A2 * B2 - A4 * B0;
        double K1 = A3 * B2 - A4 * B1;
        double K2 = A1 * B2_2 - K1 * B0;
        double K3 = K0 * B2 - K1 * B1;
        return (K3 * B0 - A0 * B2_3) / (K2 * B2 - K3 * B1);
    }

    private void getCoordsFromPolyRoots(int numSolutions, double[] roots, double[] r_n1, double[] r_a1, double[] r_a3, double[] r_c3, double[][][] r_soln_n, double[][][] r_soln_a, double[][][] r_soln_c) {
        int i;
        double[] ex = new double[3];
        double[] ey = new double[3];
        double[] ez = new double[3];
        double[] b_a1a2 = new double[3];
        double[] b_a3a2 = new double[3];
        double[] r_tmp = new double[3];
        double[][] p_s = new double[3][3];
        double[][] s1 = new double[3][3];
        double[][] s2 = new double[3][3];
        double[][] p_t = new double[3][3];
        double[][] t1 = new double[3][3];
        double[][] t2 = new double[3][3];
        double[][] p_s_c = new double[3][3];
        double[][] s1_s = new double[3][3];
        double[][] s2_s = new double[3][3];
        double[][] p_t_c = new double[3][3];
        double[][] t1_s = new double[3][3];
        double[][] t2_s = new double[3][3];
        double[] half_tan = new double[3];
        double[] cos_tau = new double[4];
        double[] sin_tau = new double[4];
        double[] cos_sig = new double[3];
        double[] sin_sig = new double[3];
        double[] r_s = new double[3];
        double[] r_t = new double[3];
        double[] r0 = new double[3];
        double[][] r_n = new double[3][3];
        double[][] r_a = new double[3][3];
        double[][] r_c = new double[3][3];
        double[] rr_a1c1 = new double[3];
        double[] rr_c1n2 = new double[3];
        double[] rr_n2a2 = new double[3];
        double[] rr_a2c2 = new double[3];
        double[] rr_c2n3 = new double[3];
        double[] rr_n3a3 = new double[3];
        double[] rr_a1a2 = new double[3];
        double[] rr_a2a3 = new double[3];
        double[] ex_tmp = new double[3];
        double[] tmp_array = new double[3];
        double[] tmp_array1 = new double[3];
        double[] tmp_array2 = new double[3];
        double[] tmp_array3 = new double[3];
        double[] mat11 = new double[3];
        double[] mat22 = new double[3];
        double[] mat33 = new double[3];
        double[] mat44 = new double[3];
        double[] mat55 = new double[3];
        System.arraycopy(this.b_a1a3, 0, ex, 0, 3);
        DoubleMath.X((double[])this.r_a1n1, (double[])ex, (double[])ez);
        double tmp_value = FastMath.sqrt((double)DoubleMath.dot((double[])ez, (double[])ez));
        for (i = 0; i < 3; ++i) {
            ez[i] = ez[i] / tmp_value;
        }
        DoubleMath.X((double[])ez, (double[])ex, (double[])ey);
        for (i = 0; i < 3; ++i) {
            b_a1a2[i] = -this.cos_alpha[0] * ex[i] + this.sin_alpha[0] * ey[i];
            b_a3a2[i] = this.cos_alpha[2] * ex[i] + this.sin_alpha[2] * ey[i];
        }
        for (i = 0; i < 3; ++i) {
            p_s[0][i] = -ex[i];
            s1[0][i] = ez[i];
            s2[0][i] = ey[i];
            p_t[0][i] = b_a1a2[i];
            t1[0][i] = ez[i];
            t2[0][i] = this.sin_alpha[0] * ex[i] + this.cos_alpha[0] * ey[i];
        }
        for (i = 0; i < 3; ++i) {
            p_s[1][i] = -b_a1a2[i];
            s1[1][i] = -ez[i];
            s2[1][i] = t2[0][i];
            p_t[1][i] = -b_a3a2[i];
            t1[1][i] = -ez[i];
            t2[1][i] = this.sin_alpha[2] * ex[i] - this.cos_alpha[2] * ey[i];
        }
        for (i = 0; i < 3; ++i) {
            p_s[2][i] = b_a3a2[i];
            s2[2][i] = t2[1][i];
            s1[2][i] = ez[i];
            p_t[2][i] = ex[i];
            t1[2][i] = ez[i];
            t2[2][i] = -ey[i];
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                p_s_c[i][j] = p_s[i][j] * this.cos_xi[i];
                s1_s[i][j] = s1[i][j] * this.sin_xi[i];
                s2_s[i][j] = s2[i][j] * this.sin_xi[i];
                p_t_c[i][j] = p_t[i][j] * this.cos_eta[i];
                t1_s[i][j] = t1[i][j] * this.sin_eta[i];
                t2_s[i][j] = t2[i][j] * this.sin_eta[i];
            }
        }
        for (i = 0; i < 3; ++i) {
            r_tmp[i] = (this.r_a1n1[i] / this.len_na[0] - p_s_c[0][i]) / this.sin_xi[0];
        }
        double sig1Init = DoubleMath.angle((double[])s1[0], (double[])r_tmp);
        sig1Init = DoubleMath.dot((double[])r_tmp, (double[])s2[0]) >= 0.0 ? FastMath.abs((double)sig1Init) : -FastMath.abs((double)sig1Init);
        for (int i2 = 0; i2 < 3; ++i2) {
            r_a[0][i2] = r_a1[i2];
            r_a[1][i2] = r_a1[i2] + AA_LEN * b_a1a2[i2];
            r_a[2][i2] = r_a3[i2];
            r0[i2] = r_a1[i2];
        }
        for (int i_soln = 0; i_soln < numSolutions; ++i_soln) {
            int i3;
            int i4;
            int i5;
            half_tan[2] = roots[i_soln];
            half_tan[1] = this.calcT2(half_tan[2]);
            half_tan[0] = this.calcT1(half_tan[2], half_tan[1]);
            for (i5 = 1; i5 <= 3; ++i5) {
                double ht = half_tan[i5 - 1];
                double tmp = 1.0 + ht * ht;
                cos_tau[i5] = (1.0 - ht * ht) / tmp;
                sin_tau[i5] = 2.0 * ht / tmp;
            }
            cos_tau[0] = cos_tau[3];
            sin_tau[0] = sin_tau[3];
            for (i5 = 0; i5 < 3; ++i5) {
                cos_sig[i5] = this.cos_delta[i5] * cos_tau[i5] + this.sin_delta[i5] * sin_tau[i5];
                sin_sig[i5] = this.sin_delta[i5] * cos_tau[i5] - this.cos_delta[i5] * sin_tau[i5];
            }
            for (i5 = 0; i5 < 3; ++i5) {
                for (int j = 0; j < 3; ++j) {
                    r_s[j] = p_s_c[i5][j] + cos_sig[i5] * s1_s[i5][j] + sin_sig[i5] * s2_s[i5][j];
                    r_t[j] = p_t_c[i5][j] + cos_tau[i5 + 1] * t1_s[i5][j] + sin_tau[i5 + 1] * t2_s[i5][j];
                    r_n[i5][j] = r_s[j] * this.len_na[i5] + r_a[i5][j];
                    r_c[i5][j] = r_t[j] * this.len_ac[i5] + r_a[i5][j];
                }
            }
            double sig1 = FastMath.atan2((double)sin_sig[0], (double)cos_sig[0]);
            ex_tmp[0] = -ex[0];
            ex_tmp[1] = -ex[1];
            ex_tmp[2] = -ex[2];
            tmp_value = -(sig1 - sig1Init) * 0.25;
            double[][] rotMatrix = LoopClosure.rotationMatrix(ex_tmp, tmp_value);
            for (int i6 = 0; i6 < 3; ++i6) {
                mat11[i6] = r_c[0][i6] - r0[i6];
                mat22[i6] = r_n[1][i6] - r0[i6];
                mat33[i6] = r_a[1][i6] - r0[i6];
                mat44[i6] = r_c[1][i6] - r0[i6];
                mat55[i6] = r_n[2][i6] - r0[i6];
            }
            double[] mat1 = LoopClosure.matrixMultiplication(rotMatrix, mat11);
            double[] mat2 = LoopClosure.matrixMultiplication(rotMatrix, mat22);
            double[] mat3 = LoopClosure.matrixMultiplication(rotMatrix, mat33);
            double[] mat4 = LoopClosure.matrixMultiplication(rotMatrix, mat44);
            double[] mat5 = LoopClosure.matrixMultiplication(rotMatrix, mat55);
            for (i4 = 0; i4 < 3; ++i4) {
                r_soln_n[i_soln][0][i4] = r_n1[i4];
                r_soln_a[i_soln][0][i4] = r_a1[i4];
                r_soln_c[i_soln][0][i4] = mat1[i4] + r0[i4];
                r_soln_n[i_soln][1][i4] = mat2[i4] + r0[i4];
                r_soln_a[i_soln][1][i4] = mat3[i4] + r0[i4];
                r_soln_c[i_soln][1][i4] = mat4[i4] + r0[i4];
                r_soln_n[i_soln][2][i4] = mat5[i4] + r0[i4];
                r_soln_a[i_soln][2][i4] = r_a3[i4];
                r_soln_c[i_soln][2][i4] = r_c3[i4];
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("roots: t0\t\t t2\t\t t1\t\t %d\n%15.6f %15.6f %15.6f\n", i_soln, half_tan[2], half_tan[1], half_tan[0]));
            }
            for (i4 = 0; i4 < 3; ++i4) {
                rr_a1c1[i4] = r_soln_c[i_soln][0][i4] - r_soln_a[i_soln][0][i4];
                rr_c1n2[i4] = r_soln_n[i_soln][1][i4] - r_soln_c[i_soln][0][i4];
                rr_n2a2[i4] = r_soln_a[i_soln][1][i4] - r_soln_n[i_soln][1][i4];
                rr_a2c2[i4] = r_soln_c[i_soln][1][i4] - r_soln_a[i_soln][1][i4];
                rr_c2n3[i4] = r_soln_n[i_soln][2][i4] - r_soln_c[i_soln][1][i4];
                rr_n3a3[i4] = r_soln_a[i_soln][2][i4] - r_soln_n[i_soln][2][i4];
                rr_a1a2[i4] = r_soln_a[i_soln][1][i4] - r_soln_a[i_soln][0][i4];
                rr_a2a3[i4] = r_soln_a[i_soln][2][i4] - r_soln_a[i_soln][1][i4];
            }
            if (!logger.isLoggable(Level.FINE)) continue;
            double a1c1 = FastMath.sqrt((double)DoubleMath.dot((double[])rr_a1c1, (double[])rr_a1c1));
            double c1n2 = FastMath.sqrt((double)DoubleMath.dot((double[])rr_c1n2, (double[])rr_c1n2));
            double n2a2 = FastMath.sqrt((double)DoubleMath.dot((double[])rr_n2a2, (double[])rr_n2a2));
            double a2c2 = FastMath.sqrt((double)DoubleMath.dot((double[])rr_a2c2, (double[])rr_a2c2));
            double c2n3 = FastMath.sqrt((double)DoubleMath.dot((double[])rr_c2n3, (double[])rr_c2n3));
            double n3a3 = FastMath.sqrt((double)DoubleMath.dot((double[])rr_n3a3, (double[])rr_n3a3));
            double a1a2 = FastMath.sqrt((double)DoubleMath.dot((double[])rr_a1a2, (double[])rr_a1a2));
            double a2a3 = FastMath.sqrt((double)DoubleMath.dot((double[])rr_a2a3, (double[])rr_a2a3));
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("na: n2a2, n3a3 = %9.3f%9.3f%9.3f\n", BOND_LENS[2], n2a2, n3a3));
            sb.append(String.format("ac: a1c1, a2c2 = %9.3f%9.3f%9.3f\n", BOND_LENS[0], a1c1, a2c2));
            sb.append(String.format("cn: c1n2, c2n3 = %9.3f%9.3f%9.3f\n", BOND_LENS[1], c1n2, c2n3));
            sb.append(String.format("aa: a1a2, a2a3 = %9.3f%9.3f%9.3f%9.3f\n", AA_LEN, a1a2, AA_LEN, a2a3));
            logger.fine(sb.toString());
            sb.setLength(0);
            for (i3 = 0; i3 < 3; ++i3) {
                tmp_array[i3] = rr_a1a2[i3] / a1a2;
            }
            DoubleMath.angle((double[])this.b_a1a3, (double[])tmp_array);
            for (i3 = 0; i3 < 3; ++i3) {
                tmp_array[i3] = rr_a2a3[i3] / a2a3;
            }
            DoubleMath.angle((double[])tmp_array, (double[])this.b_a1a3);
            for (i3 = 0; i3 < 3; ++i3) {
                tmp_array[i3] = rr_a1c1[i3] / a1c1;
            }
            DoubleMath.angle((double[])this.b_a1n1, (double[])tmp_array);
            for (i3 = 0; i3 < 3; ++i3) {
                tmp_array[i3] = -rr_n3a3[i3] / n3a3;
            }
            DoubleMath.angle((double[])this.b_a3c3, (double[])tmp_array);
            for (i3 = 0; i3 < 3; ++i3) {
                tmp_array1[i3] = rr_a2c2[i3] / a2c2;
                tmp_array2[i3] = -rr_n2a2[i3] / n2a2;
            }
            DoubleMath.angle((double[])tmp_array1, (double[])tmp_array2);
            for (i3 = 0; i3 < 3; ++i3) {
                tmp_array1[i3] = rr_a1c1[i3] / a1c1;
                tmp_array2[i3] = rr_c1n2[i3] / c1n2;
                tmp_array3[i3] = rr_n2a2[i3] / n2a2;
            }
            double a1c1n2a2 = DoubleMath.dihedralAngle((double[])tmp_array1, (double[])tmp_array2, (double[])tmp_array3);
            for (int i7 = 0; i7 < 3; ++i7) {
                tmp_array1[i7] = rr_a2c2[i7] / a2c2;
                tmp_array2[i7] = rr_c2n3[i7] / c2n3;
                tmp_array3[i7] = rr_n3a3[i7] / n3a3;
            }
            double a2c2n3a3 = DoubleMath.dihedralAngle((double[])tmp_array1, (double[])tmp_array2, (double[])tmp_array3);
            sb.append(String.format("t_ang1 = %9.3f\n", FastMath.toDegrees((double)a1c1n2a2)));
            sb.append(String.format("t_ang2 = %9.3f\n", FastMath.toDegrees((double)a2c2n3a3)));
            logger.fine(sb.toString());
        }
    }

    public boolean getInputAngles(double[] r_n1, double[] r_a1, double[] r_a3, double[] r_c3) {
        int i;
        double[] tmp_val = new double[3];
        for (int i2 = 0; i2 < 3; ++i2) {
            this.r_a1a3[i2] = r_a3[i2] - r_a1[i2];
        }
        double dr_sqr = DoubleMath.dot((double[])this.r_a1a3, (double[])this.r_a1a3);
        if (dr_sqr < AA13_MIN_SQR || dr_sqr > AA13_MAX_SQR) {
            return false;
        }
        double a1A3Len = FastMath.sqrt((double)dr_sqr);
        for (i = 0; i < 3; ++i) {
            this.r_a1n1[i] = r_n1[i] - r_a1[i];
        }
        this.len_na[0] = FastMath.sqrt((double)DoubleMath.dot((double[])this.r_a1n1, (double[])this.r_a1n1));
        this.len_na[1] = BOND_LENS[2];
        this.len_na[2] = BOND_LENS[2];
        for (i = 0; i < 3; ++i) {
            this.r_a3c3[i] = r_c3[i] - r_a3[i];
        }
        this.len_ac[0] = BOND_LENS[0];
        this.len_ac[1] = BOND_LENS[0];
        this.len_ac[2] = FastMath.sqrt((double)DoubleMath.dot((double[])this.r_a3c3, (double[])this.r_a3c3));
        for (i = 0; i < 3; ++i) {
            this.b_a1n1[i] = this.r_a1n1[i] / this.len_na[0];
            this.b_a3c3[i] = this.r_a3c3[i] / this.len_ac[2];
            this.b_a1a3[i] = this.r_a1a3[i] / a1A3Len;
        }
        for (i = 0; i < 3; ++i) {
            tmp_val[i] = -this.b_a1n1[i];
        }
        LoopClosure.DELTA[3] = DoubleMath.dihedralAngle((double[])r_n1, (double[])r_a1, (double[])r_a3, (double[])r_c3);
        LoopClosure.DELTA[0] = DELTA[3];
        for (i = 0; i < 3; ++i) {
            tmp_val[i] = -this.b_a1a3[i];
        }
        LoopClosure.XI[0] = DoubleMath.angle((double[])tmp_val, (double[])this.b_a1n1);
        LoopClosure.ETA[2] = DoubleMath.angle((double[])this.b_a1a3, (double[])this.b_a3c3);
        for (i = 0; i < 3; ++i) {
            this.cos_delta[i + 1] = FastMath.cos((double)DELTA[i + 1]);
            this.sin_delta[i + 1] = FastMath.sin((double)DELTA[i + 1]);
            this.cos_xi[i] = FastMath.cos((double)XI[i]);
            this.sin_xi[i] = FastMath.sin((double)XI[i]);
            this.sin_xi[i] = FastMath.sin((double)XI[i]);
            this.cos_eta[i] = FastMath.cos((double)ETA[i]);
            this.sin_eta[i] = FastMath.sin((double)ETA[i]);
        }
        this.cos_delta[0] = this.cos_delta[3];
        this.sin_delta[0] = this.sin_delta[3];
        this.theta[0] = BOND_ANGLES[0];
        this.theta[1] = BOND_ANGLES[0];
        this.theta[2] = BOND_ANGLES[0];
        for (i = 0; i < 3; ++i) {
            this.cos_theta[i] = FastMath.cos((double)this.theta[i]);
        }
        this.cos_alpha[0] = -(a1A3Len * a1A3Len + AA_LEN * AA_LEN - AA_LEN * AA_LEN) / (2.0 * a1A3Len * AA_LEN);
        this.alpha[0] = FastMath.acos((double)this.cos_alpha[0]);
        this.sin_alpha[0] = FastMath.sin((double)this.alpha[0]);
        this.cos_alpha[1] = (AA_LEN * AA_LEN + AA_LEN * AA_LEN - a1A3Len * a1A3Len) / (2.0 * AA_LEN * AA_LEN);
        this.alpha[1] = FastMath.acos((double)this.cos_alpha[1]);
        this.sin_alpha[1] = FastMath.sin((double)this.alpha[1]);
        this.alpha[2] = Math.PI - this.alpha[0] + this.alpha[1];
        this.cos_alpha[2] = FastMath.cos((double)this.alpha[2]);
        this.sin_alpha[2] = FastMath.sin((double)this.alpha[2]);
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(" xi = %9.4f%9.4f%9.4f\n", FastMath.toDegrees((double)XI[0]), FastMath.toDegrees((double)XI[1]), FastMath.toDegrees((double)XI[2])));
            sb.append(String.format(" eta = %9.4f%9.4f%9.4f\n", FastMath.toDegrees((double)ETA[0]), FastMath.toDegrees((double)ETA[1]), FastMath.toDegrees((double)ETA[2])));
            sb.append(String.format(" delta = %9.4f%9.4f%9.4f\n", FastMath.toDegrees((double)DELTA[1]), FastMath.toDegrees((double)DELTA[2]), FastMath.toDegrees((double)DELTA[3])));
            sb.append(String.format(" theta = %9.4f%9.4f%9.4f\n", FastMath.toDegrees((double)this.theta[0]), FastMath.toDegrees((double)this.theta[1]), FastMath.toDegrees((double)this.theta[2])));
            sb.append(String.format(" alpha = %9.4f%9.4f%9.4f\n", FastMath.toDegrees((double)this.alpha[0]), FastMath.toDegrees((double)this.alpha[1]), FastMath.toDegrees((double)this.alpha[2])));
            logger.fine(sb.toString());
        }
        for (int i3 = 0; i3 < 3; ++i3) {
            if (this.testTwoConeExistenceSoln(this.theta[i3], XI[i3], ETA[i3], this.alpha[i3])) continue;
            return false;
        }
        return true;
    }

    public void getPolyCoeff(double[] polyCoeff) {
        int i;
        double[] B0 = new double[3];
        double[] B1 = new double[3];
        double[] B2 = new double[3];
        double[] B3 = new double[3];
        double[] B4 = new double[3];
        double[] B5 = new double[3];
        double[] B6 = new double[3];
        double[] B7 = new double[3];
        double[] B8 = new double[3];
        double[][] u11 = new double[5][5];
        double[][] u12 = new double[5][5];
        double[][] u13 = new double[5][5];
        double[][] u31 = new double[5][5];
        double[][] u32 = new double[5][5];
        double[][] u33 = new double[5][5];
        double[][] um1 = new double[5][5];
        double[][] um2 = new double[5][5];
        double[][] um3 = new double[5][5];
        double[][] um4 = new double[5][5];
        double[][] um5 = new double[5][5];
        double[][] um6 = new double[5][5];
        double[][] q_tmp = new double[5][5];
        int[] p1 = new int[2];
        int[] p3 = new int[2];
        int[] p_um1 = new int[2];
        int[] p_um2 = new int[2];
        int[] p_um3 = new int[2];
        int[] p_um4 = new int[2];
        int[] p_um5 = new int[2];
        int[] p_um6 = new int[2];
        int[] p_Q = new int[2];
        int[] p_f1 = new int[1];
        int[] p_f2 = new int[1];
        int[] p_f3 = new int[1];
        int[] p_f4 = new int[1];
        int[] p_f5 = new int[1];
        int[] p_f6 = new int[1];
        int[] p_f7 = new int[1];
        int[] p_f8 = new int[1];
        int[] p_f9 = new int[1];
        int[] p_f10 = new int[1];
        int[] p_f11 = new int[1];
        int[] p_f12 = new int[1];
        int[] p_f13 = new int[1];
        int[] p_f14 = new int[1];
        int[] p_f15 = new int[1];
        int[] p_f16 = new int[1];
        int[] p_f17 = new int[1];
        int[] p_f18 = new int[1];
        int[] p_f19 = new int[1];
        int[] p_f20 = new int[1];
        int[] p_f21 = new int[1];
        int[] p_f22 = new int[1];
        int[] p_f23 = new int[1];
        int[] p_f24 = new int[1];
        int[] p_f25 = new int[1];
        int[] p_f26 = new int[1];
        int[] p_final = new int[1];
        double[] f1 = new double[17];
        double[] f2 = new double[17];
        double[] f3 = new double[17];
        double[] f4 = new double[17];
        double[] f5 = new double[17];
        double[] f6 = new double[17];
        double[] f7 = new double[17];
        double[] f8 = new double[17];
        double[] f9 = new double[17];
        double[] f10 = new double[17];
        double[] f11 = new double[17];
        double[] f12 = new double[17];
        double[] f13 = new double[17];
        double[] f14 = new double[17];
        double[] f15 = new double[17];
        double[] f16 = new double[17];
        double[] f17 = new double[17];
        double[] f18 = new double[17];
        double[] f19 = new double[17];
        double[] f20 = new double[17];
        double[] f21 = new double[17];
        double[] f22 = new double[17];
        double[] f23 = new double[17];
        double[] f24 = new double[17];
        double[] f25 = new double[17];
        double[] f26 = new double[17];
        for (i = 0; i < 3; ++i) {
            double A0 = this.cos_alpha[i] * this.cos_xi[i] * this.cos_eta[i] - this.cos_theta[i];
            double A1 = -this.sin_alpha[i] * this.cos_xi[i] * this.sin_eta[i];
            double A2 = this.sin_alpha[i] * this.sin_xi[i] * this.cos_eta[i];
            double A3 = this.sin_xi[i] * this.sin_eta[i];
            double A4 = A3 * this.cos_alpha[i];
            double A21 = A2 * this.cos_delta[i];
            double A22 = A2 * this.sin_delta[i];
            double A31 = A3 * this.cos_delta[i];
            double A32 = A3 * this.sin_delta[i];
            double A41 = A4 * this.cos_delta[i];
            double A42 = A4 * this.sin_delta[i];
            B0[i] = A0 + A22 + A31;
            B1[i] = 2.0 * (A1 + A42);
            B2[i] = 2.0 * (A32 - A21);
            B3[i] = -4.0 * A41;
            B4[i] = A0 + A22 - A31;
            B5[i] = A0 - A22 - A31;
            B6[i] = -2.0 * (A21 + A32);
            B7[i] = 2.0 * (A1 - A42);
            B8[i] = A0 - A22 + A31;
        }
        this.C0[0][0] = B0[0];
        this.C0[0][1] = B2[0];
        this.C0[0][2] = B5[0];
        this.C1[0][0] = B1[0];
        this.C1[0][1] = B3[0];
        this.C1[0][2] = B7[0];
        this.C2[0][0] = B4[0];
        this.C2[0][1] = B6[0];
        this.C2[0][2] = B8[0];
        for (i = 1; i < 3; ++i) {
            this.C0[i][0] = B0[i];
            this.C0[i][1] = B1[i];
            this.C0[i][2] = B4[i];
            this.C1[i][0] = B2[i];
            this.C1[i][1] = B3[i];
            this.C1[i][2] = B6[i];
            this.C2[i][0] = B5[i];
            this.C2[i][1] = B7[i];
            this.C2[i][2] = B8[i];
        }
        for (i = 0; i < 3; ++i) {
            u11[0][i] = this.C0[0][i];
            u12[0][i] = this.C1[0][i];
            u13[0][i] = this.C2[0][i];
            u31[i][0] = this.C0[1][i];
            u32[i][0] = this.C1[1][i];
            u33[i][0] = this.C2[1][i];
        }
        p1[0] = 2;
        p1[1] = 0;
        p3[0] = 0;
        p3[1] = 2;
        this.polyMulSub2(u32, u32, u31, u33, p3, p3, p3, p3, um1, p_um1);
        this.polyMulSub2(u12, u32, u11, u33, p1, p3, p1, p3, um2, p_um2);
        this.polyMulSub2(u12, u33, u13, u32, p1, p3, p1, p3, um3, p_um3);
        this.polyMulSub2(u11, u33, u31, u13, p1, p3, p3, p1, um4, p_um4);
        this.polyMulSub2(u13, um1, u33, um2, p1, p_um1, p3, p_um2, um5, p_um5);
        this.polyMulSub2(u13, um4, u12, um3, p1, p_um4, p1, p_um3, um6, p_um6);
        this.polyMulSub2(u11, um5, u31, um6, p1, p_um5, p3, p_um6, q_tmp, p_Q);
        for (i = 0; i < 5; ++i) {
            System.arraycopy(q_tmp[i], 0, this.Q[i], 0, 5);
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 17; ++j) {
                this.R[i][j] = 0.0;
            }
        }
        for (i = 0; i < 3; ++i) {
            this.R[0][i] = this.C0[2][i];
            this.R[1][i] = this.C1[2][i];
            this.R[2][i] = this.C2[2][i];
        }
        int p2 = 2;
        int p4 = 4;
        this.polyMulSub1(this.R[1], this.R[1], this.R[0], this.R[2], p2, p2, p2, p2, f1, p_f1);
        this.polyMul1(this.R[1], this.R[2], p2, p2, f2, p_f2);
        this.polyMulSub1(this.R[1], f1, this.R[0], f2, p2, p_f1[0], p2, p_f2[0], f3, p_f3);
        this.polyMul1(this.R[2], f1, p2, p_f1[0], f4, p_f4);
        this.polyMulSub1(this.R[1], f3, this.R[0], f4, p2, p_f3[0], p2, p_f4[0], f5, p_f5);
        this.polyMulSub1(this.Q[1], this.R[1], this.Q[0], this.R[2], p4, p2, p4, p2, f6, p_f6);
        this.polyMulSub1(this.Q[2], f1, this.R[2], f6, p4, p_f1[0], p2, p_f6[0], f7, p_f7);
        this.polyMulSub1(this.Q[3], f3, this.R[2], f7, p4, p_f3[0], p2, p_f7[0], f8, p_f8);
        this.polyMulSub1(this.Q[4], f5, this.R[2], f8, p4, p_f5[0], p2, p_f8[0], f9, p_f9);
        this.polyMulSub1(this.Q[3], this.R[1], this.Q[4], this.R[0], p4, p2, p4, p2, f10, p_f10);
        this.polyMulSub1(this.Q[2], f1, this.R[0], f10, p4, p_f1[0], p2, p_f10[0], f11, p_f11);
        this.polyMulSub1(this.Q[1], f3, this.R[0], f11, p4, p_f3[0], p2, p_f11[0], f12, p_f12);
        this.polyMulSub1(this.Q[2], this.R[1], this.Q[1], this.R[2], p4, p2, p4, p2, f13, p_f13);
        this.polyMulSub1(this.Q[3], f1, this.R[2], f13, p4, p_f1[0], p2, p_f13[0], f14, p_f14);
        this.polyMulSub1(this.Q[3], this.R[1], this.Q[2], this.R[2], p4, p2, p4, p2, f15, p_f15);
        this.polyMulSub1(this.Q[4], f1, this.R[2], f15, p4, p_f1[0], p2, p_f15[0], f16, p_f16);
        this.polyMulSub1(this.Q[1], f14, this.Q[0], f16, p4, p_f14[0], p4, p_f16[0], f17, p_f17);
        this.polyMulSub1(this.Q[2], this.R[2], this.Q[3], this.R[1], p4, p2, p4, p2, f18, p_f18);
        this.polyMulSub1(this.Q[1], this.R[2], this.Q[3], this.R[0], p4, p2, p4, p2, f19, p_f19);
        this.polyMulSub1(this.Q[3], f19, this.Q[2], f18, p4, p_f19[0], p4, p_f18[0], f20, p_f20);
        this.polyMulSub1(this.Q[1], this.R[1], this.Q[2], this.R[0], p4, p2, p4, p2, f21, p_f21);
        this.polyMul1(this.Q[4], f21, p4, p_f21[0], f22, p_f22);
        this.polySub1(f20, f22, p_f20, p_f22, f23, p_f23);
        this.polyMul1(this.R[0], f23, p2, p_f23[0], f24, p_f24);
        this.polySub1(f17, f24, p_f17, p_f24, f25, p_f25);
        this.polyMulSub1(this.Q[4], f12, this.R[2], f25, p4, p_f12[0], p2, p_f25[0], f26, p_f26);
        this.polyMulSub1(this.Q[0], f9, this.R[0], f26, p4, p_f9[0], p2, p_f26[0], polyCoeff, p_final);
        if (p_final[0] != 16) {
            logger.info("Error. Degree of polynomial is not 16!");
            return;
        }
        if (polyCoeff[16] < 0.0) {
            int i2 = 0;
            while (i2 < 17) {
                int n = i2++;
                polyCoeff[n] = polyCoeff[n] * -1.0;
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder string = new StringBuilder();
            string.append(" Polynomial Coefficients\n");
            for (int i3 = 0; i3 < 17; ++i3) {
                string.append(String.format(" %5d %15.6f\n", i3, polyCoeff[i3]));
            }
            string.append("\n");
            logger.fine(string.toString());
        }
    }

    private static double[] matrixMultiplication(double[][] ma, double[] mb) {
        Array2DRowRealMatrix matrix = new Array2DRowRealMatrix(ma);
        matrix.multiply((RealMatrix)matrix);
        ArrayRealVector vector = new ArrayRealVector(mb);
        RealVector result = matrix.operate((RealVector)vector);
        return result.toArray();
    }

    public void polyMul1(double[] u1, double[] u2, int p1, int p2, double[] u3, int[] p3) {
        p3[0] = p1 + p2;
        for (int i = 0; i < 17; ++i) {
            u3[i] = 0.0;
        }
        for (int i1 = 0; i1 <= p1; ++i1) {
            double u1i = u1[i1];
            for (int i2 = 0; i2 <= p2; ++i2) {
                int i3 = i1 + i2;
                u3[i3] = u3[i3] + u1i * u2[i2];
            }
        }
    }

    public void polyMul2(double[][] u1, double[][] u2, int[] p1, int[] p2, double[][] u3, int[] p3) {
        int i;
        for (i = 0; i < 2; ++i) {
            p3[i] = p1[i] + p2[i];
        }
        for (i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                u3[i][j] = 0.0;
            }
        }
        int p11 = p1[0];
        int p12 = p1[1];
        int p21 = p2[0];
        int p22 = p2[1];
        for (int i1 = 0; i1 <= p12; ++i1) {
            for (int j1 = 0; j1 <= p11; ++j1) {
                double u1ij = u1[i1][j1];
                for (int i2 = 0; i2 <= p22; ++i2) {
                    int i3 = i1 + i2;
                    for (int j2 = 0; j2 <= p21; ++j2) {
                        int j3 = j1 + j2;
                        u3[i3][j3] = u3[i3][j3] + u1ij * u2[i2][j2];
                    }
                }
            }
        }
    }

    public void polyMulSub1(double[] u1, double[] u2, double[] u3, double[] u4, int p1, int p2, int p3, int p4, double[] u5, int[] p5) {
        double[] d1 = new double[17];
        double[] d2 = new double[17];
        int[] pd1 = new int[1];
        int[] pd2 = new int[1];
        this.polyMul1(u1, u2, p1, p2, d1, pd1);
        this.polyMul1(u3, u4, p3, p4, d2, pd2);
        this.polySub1(d1, d2, pd1, pd2, u5, p5);
    }

    public void polyMulSub2(double[][] u1, double[][] u2, double[][] u3, double[][] u4, int[] p1, int[] p2, int[] p3, int[] p4, double[][] u5, int[] p5) {
        double[][] d1 = new double[5][5];
        double[][] d2 = new double[5][5];
        int[] pd1 = new int[2];
        int[] pd2 = new int[2];
        this.polyMul2(u1, u2, p1, p2, d1, pd1);
        this.polyMul2(u3, u4, p3, p4, d2, pd2);
        this.polySub2(d1, d2, pd1, pd2, u5, p5);
    }

    public void polySub1(double[] u1, double[] u2, int[] p1, int[] p2, double[] u3, int[] p3) {
        p3[0] = FastMath.max((int)p1[0], (int)p2[0]);
        for (int i = 0; i <= p3[0]; ++i) {
            u3[i] = i > p2[0] ? u1[i] : (i > p1[0] ? -u2[i] : u1[i] - u2[i]);
        }
    }

    public void polySub2(double[][] u1, double[][] u2, int[] p1, int[] p2, double[][] u3, int[] p3) {
        int p11 = p1[0];
        int p12 = p1[1];
        int p21 = p2[0];
        int p22 = p2[1];
        p3[0] = FastMath.max((int)p11, (int)p21);
        p3[1] = FastMath.max((int)p12, (int)p22);
        for (int i = 0; i <= p3[1]; ++i) {
            boolean i1_ok = i > p12;
            boolean i2_ok = i > p22;
            for (int j = 0; j <= p3[0]; ++j) {
                u3[i][j] = i2_ok || j > p21 ? u1[i][j] : (i1_ok || j > p11 ? -u2[i][j] : u1[i][j] - u2[i][j]);
            }
        }
    }

    private static double[][] rotationMatrix(double[] axis, double angle) {
        double tan_w = FastMath.tan((double)angle);
        double tan_sqr = tan_w * tan_w;
        double tan1 = 1.0 + tan_sqr;
        double cosine = (1.0 - tan_sqr) / tan1;
        double sine = 2.0 * tan_w / tan1;
        double[] quaternion = new double[]{cosine, axis[0] * sine, axis[1] * sine, axis[2] * sine};
        double b0 = 2.0 * quaternion[0];
        double b1 = 2.0 * quaternion[1];
        double q00 = b0 * quaternion[0] - 1.0;
        double q02 = b0 * quaternion[2];
        double q03 = b0 * quaternion[3];
        double q11 = b1 * quaternion[1];
        double q12 = b1 * quaternion[2];
        double q13 = b1 * quaternion[3];
        double b2 = 2.0 * quaternion[2];
        double b3 = 2.0 * quaternion[3];
        double q01 = b0 * quaternion[1];
        double q22 = b2 * quaternion[2];
        double q23 = b2 * quaternion[3];
        double q33 = b3 * quaternion[3];
        double[][] result = new double[3][3];
        result[0][0] = q00 + q11;
        result[0][1] = q12 - q03;
        result[0][2] = q13 + q02;
        result[1][0] = q12 + q03;
        result[1][1] = q00 + q22;
        result[1][2] = q23 - q01;
        result[2][0] = q13 - q02;
        result[2][1] = q23 + q01;
        result[2][2] = q00 + q33;
        return result;
    }

    public int solve3PepPoly(double[] r_n1, double[] r_a1, double[] r_a3, double[] r_c3, double[][][] r_soln_n, double[][][] r_soln_a, double[][][] r_soln_c) {
        double[] polyCoeff = new double[17];
        double[] roots = new double[16];
        if (!this.getInputAngles(r_n1, r_a1, r_a3, r_c3)) {
            return 0;
        }
        this.getPolyCoeff(polyCoeff);
        SturmMethod sturmMethod = new SturmMethod();
        int solutions = sturmMethod.solveSturm(16, polyCoeff, roots);
        if (solutions > 0) {
            this.getCoordsFromPolyRoots(solutions, roots, r_n1, r_a1, r_a3, r_c3, r_soln_n, r_soln_a, r_soln_c);
        } else {
            logger.info("Could not find alternative loop solutions using KIC.");
        }
        return solutions;
    }

    private boolean testTwoConeExistenceSoln(double tt, double kx, double et, double ap) {
        double at = ap - tt;
        double ex = kx + et;
        double abs_at = FastMath.abs((double)at);
        return abs_at <= ex;
    }

    static {
        XI = new double[3];
        DELTA = new double[4];
        ETA = new double[3];
        BOND_LENS = new double[3];
        LoopClosure.BOND_LENS[0] = 1.52;
        LoopClosure.BOND_LENS[1] = 1.33;
        LoopClosure.BOND_LENS[2] = 1.45;
        BOND_ANGLES = new double[3];
        LoopClosure.BOND_ANGLES[0] = Math.toRadians(111.6);
        LoopClosure.BOND_ANGLES[1] = Math.toRadians(117.5);
        LoopClosure.BOND_ANGLES[2] = Math.toRadians(120.0);
        double[][] rotMatrix = LoopClosure.rotationMatrix(new double[]{1.0, 0.0, 0.0}, 0.7853981633974483);
        double[] relCarboxyl = new double[]{FastMath.cos((double)BOND_ANGLES[1]) * BOND_LENS[0], FastMath.sin((double)BOND_ANGLES[1]) * BOND_LENS[0], 0.0};
        double[] relNitrogen = new double[]{BOND_LENS[1], 0.0, 0.0};
        double[] relAlpha2 = new double[]{-FastMath.cos((double)BOND_ANGLES[2]) * BOND_LENS[2], FastMath.sin((double)BOND_ANGLES[2]) * BOND_LENS[2], 0.0};
        relAlpha2 = LoopClosure.matrixMultiplication(rotMatrix, relAlpha2);
        double[] alpha1Alpha2 = new double[3];
        double[] alpha2N = new double[3];
        for (int i = 0; i < 3; ++i) {
            alpha1Alpha2[i] = relAlpha2[i] + relNitrogen[i] - relCarboxyl[i];
            alpha2N[i] = -relAlpha2[i];
        }
        AA_LEN = FastMath.sqrt((double)DoubleMath.dot((double[])alpha1Alpha2, (double[])alpha1Alpha2));
        double[] tmp_val = new double[3];
        for (int i = 0; i < 2; ++i) {
            int j;
            for (j = 0; j < 3; ++j) {
                tmp_val[j] = -alpha1Alpha2[j];
            }
            LoopClosure.XI[i + 1] = DoubleMath.angle((double[])tmp_val, (double[])alpha2N);
            for (j = 0; j < 3; ++j) {
                tmp_val[j] = -relCarboxyl[j];
            }
            LoopClosure.ETA[i] = DoubleMath.angle((double[])alpha1Alpha2, (double[])tmp_val);
            LoopClosure.DELTA[i + 1] = Math.PI - DoubleMath.dihedralAngle((double[])relCarboxyl, (double[])alpha1Alpha2, (double[])alpha2N);
        }
        double a_min = BOND_ANGLES[0] - (XI[1] + ETA[1]);
        double a_max = FastMath.min((double)(BOND_ANGLES[0] + (XI[1] + ETA[1])), (double)Math.PI);
        AA13_MIN_SQR = FastMath.pow((double)AA_LEN, (int)2) + FastMath.pow((double)AA_LEN, (int)2) - 2.0 * AA_LEN * AA_LEN * FastMath.cos((double)a_min);
        AA13_MAX_SQR = FastMath.pow((double)AA_LEN, (int)2) + FastMath.pow((double)AA_LEN, (int)2) - 2.0 * AA_LEN * AA_LEN * FastMath.cos((double)a_max);
    }
}

