/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.utils;

import ffx.numerics.math.DoubleMath;
import ffx.potential.MolecularAssembly;
import ffx.potential.bonded.AminoAcidUtils;
import ffx.potential.bonded.Atom;
import ffx.potential.bonded.Residue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.logging.Logger;

public class GetProteinFeatures {
    private static final HashMap<AminoAcidUtils.AminoAcid3, String> polarityMap = new HashMap();
    private static final HashMap<AminoAcidUtils.AminoAcid3, String> acidityMap = new HashMap();
    private static final NavigableMap<Double, String> phiToStructure = new TreeMap<Double, String>();
    private static final NavigableMap<Double, String> psiToStructure = new TreeMap<Double, String>();
    private static final HashMap<AminoAcidUtils.AminoAcid3, Double> standardSurfaceArea = new HashMap();
    private static final HashMap<String, AminoAcidUtils.AminoAcid3> aminoAcidCodes = new HashMap();
    private double phi;
    private double psi;
    private double omega;
    private double totalSurfaceArea = 0.0;
    MolecularAssembly molecularAssembly;
    private static final Logger logger = Logger.getLogger(GetProteinFeatures.class.getName());

    public GetProteinFeatures(MolecularAssembly molecularAssembly) {
        this.molecularAssembly = molecularAssembly;
    }

    public String[] saveFeatures(Residue residue, double surfaceArea, boolean includeAngles, boolean includeStructure, boolean includePPI) {
        String omegaString;
        String psiString;
        String phiString;
        String structure;
        int nFeat = 3;
        if (includeAngles) {
            nFeat += 3;
        }
        if (includeStructure) {
            ++nFeat;
        }
        if (includePPI) {
            ++nFeat;
        }
        String[] features = new String[nFeat];
        String interfaceResString = "";
        if (residue.getNextResidue() == null) {
            structure = "Extended";
            this.getPhi(residue);
            phiString = String.valueOf(this.phi);
            psiString = null;
            omegaString = null;
        } else if (residue.getPreviousResidue() == null) {
            structure = "Extended";
            this.getPsi(residue);
            this.getOmega(residue);
            psiString = String.valueOf(this.psi);
            omegaString = String.valueOf(this.omega);
            phiString = null;
        } else {
            this.getPhi(residue);
            this.getPsi(residue);
            this.getOmega(residue);
            phiString = String.valueOf(this.phi);
            psiString = String.valueOf(this.psi);
            omegaString = String.valueOf(this.omega);
            structure = this.getSecondaryStructure();
        }
        this.totalSurfaceArea += surfaceArea;
        String surfaceAreaString = String.valueOf(Math.floor(surfaceArea * 100.0) / 100.0);
        double standSurfaceArea = standardSurfaceArea.getOrDefault((Object)residue.getAminoAcid3(), 0.0);
        String normalizedSAString = "";
        if (standSurfaceArea != 0.0) {
            double normSA = surfaceArea / standSurfaceArea;
            if ((normSA = Math.floor(normSA * 100.0) / 100.0) > 1.0) {
                normSA = 1.0;
            }
            normalizedSAString = String.valueOf(normSA);
        }
        String confidence = String.valueOf(this.getConfidenceScore(residue));
        String interactingGene = " ";
        if (includePPI && !(interactingGene = this.getPPI(residue)).equals(" ")) {
            interfaceResString = interactingGene;
        }
        features[0] = surfaceAreaString;
        features[1] = normalizedSAString;
        features[2] = confidence;
        if (includeAngles) {
            features[3] = phiString;
            features[4] = psiString;
            features[5] = omegaString;
            if (includeStructure) {
                features[6] = structure;
            }
            if (includePPI) {
                features[7] = interfaceResString;
            }
        } else if (includeStructure) {
            features[3] = structure;
            if (includePPI) {
                features[4] = interfaceResString;
            }
        } else if (includePPI) {
            features[3] = interfaceResString;
        }
        return features;
    }

    public void getPhi(Residue currentRes) {
        Residue previousRes = currentRes.getPreviousResidue();
        double[] cCoor = new double[3];
        double[] nCoor = new double[3];
        double[] caCoor = new double[3];
        double[] c2Coor = new double[3];
        this.phi = DoubleMath.dihedralAngle((double[])previousRes.getAtomByName("C", true).getXYZ(cCoor), (double[])currentRes.getAtomByName("N", true).getXYZ(nCoor), (double[])currentRes.getAtomByName("CA", true).getXYZ(caCoor), (double[])currentRes.getAtomByName("C", true).getXYZ(c2Coor)) * 180.0 / Math.PI;
    }

    public void getPsi(Residue currentRes) {
        Residue nextRes = currentRes.getNextResidue();
        double[] nCoor = new double[3];
        double[] caCoor = new double[3];
        double[] cCoor = new double[3];
        double[] n2Coor = new double[3];
        this.psi = DoubleMath.dihedralAngle((double[])currentRes.getAtomByName("N", true).getXYZ(nCoor), (double[])currentRes.getAtomByName("CA", true).getXYZ(caCoor), (double[])currentRes.getAtomByName("C", true).getXYZ(cCoor), (double[])nextRes.getAtomByName("N", true).getXYZ(n2Coor)) * 180.0 / Math.PI;
    }

    public void getOmega(Residue currentRes) {
        Residue nextRes = currentRes.getNextResidue();
        double[] ca1Coor = new double[3];
        double[] cCoor = new double[3];
        double[] nCoor = new double[3];
        double[] ca2Coor = new double[3];
        this.omega = DoubleMath.dihedralAngle((double[])currentRes.getAtomByName("CA", true).getXYZ(ca1Coor), (double[])currentRes.getAtomByName("C", true).getXYZ(cCoor), (double[])nextRes.getAtomByName("N", true).getXYZ(nCoor), (double[])nextRes.getAtomByName("CA", true).getXYZ(ca2Coor)) * 180.0 / Math.PI;
    }

    public String getSecondaryStructure() {
        String secondaryStructure;
        Double lowPhiKey = phiToStructure.floorKey(this.phi);
        String lowPhiStruct = (String)phiToStructure.get(lowPhiKey);
        Double highPhiKey = phiToStructure.ceilingKey(this.phi);
        String highPhiStruct = (String)phiToStructure.get(highPhiKey);
        if (lowPhiStruct.equals("Extended") || highPhiStruct.equals("Extended")) {
            secondaryStructure = "Extended";
        } else {
            Double lowPsiKey = psiToStructure.floorKey(this.psi);
            String lowPsiStruct = (String)psiToStructure.get(lowPsiKey);
            Double highPsiKey = psiToStructure.ceilingKey(this.psi);
            String highPsiStruct = (String)psiToStructure.get(highPsiKey);
            secondaryStructure = lowPsiStruct.equals("Extended") || highPsiStruct.equals("Extended") ? "Extended" : lowPsiStruct;
        }
        return secondaryStructure;
    }

    public double getTotalSurfaceArea() {
        return Math.floor(this.totalSurfaceArea);
    }

    public double getConfidenceScore(Residue currentRes) {
        return currentRes.getAtomByName("CA", true).getTempFactor();
    }

    public List<String> ddgunToNPChange(List<String> ddgun) {
        ArrayList<String> npChanges = new ArrayList<String>();
        for (String s : ddgun) {
            String[] splits = s.split("\t");
            String currentNP = splits[2];
            String wt = String.valueOf(currentNP.charAt(0));
            String mut = String.valueOf(currentNP.charAt(currentNP.length() - 1));
            String pos = currentNP.substring(1, currentNP.length() - 1);
            String wt3Letter = aminoAcidCodes.get(wt).toString();
            String mut3Letter = aminoAcidCodes.get(mut).toString();
            String wildType = wt3Letter.charAt(0) + wt3Letter.substring(1, 3).toLowerCase();
            String mutant = mut3Letter.charAt(0) + mut3Letter.substring(1, 3).toLowerCase();
            String npChange = "p." + wildType + pos + mutant;
            npChanges.add(npChange);
        }
        return npChanges;
    }

    public List<Double[]> getDDGunValues(List<String> ddgun) {
        ArrayList<Double[]> values = new ArrayList<Double[]>();
        for (String s : ddgun) {
            String[] splits = s.split("\t");
            Double[] value = new Double[]{Double.parseDouble(splits[3]) * -1.0, Math.abs(Double.parseDouble(splits[3]))};
            values.add(value);
        }
        return values;
    }

    public List<String[]> getPolarityAndAcidityChange(List<String> npChanges, boolean includePolarity, boolean includeAcidity) {
        ArrayList<String[]> polarityAndAcidity = new ArrayList<String[]>();
        for (String npChange : npChanges) {
            String change = npChange.split("p\\.")[1].toUpperCase(Locale.ROOT);
            String[] value = new String[2];
            AminoAcidUtils.AminoAcid3 wt = AminoAcidUtils.AminoAcid3.valueOf(change.substring(0, 3));
            AminoAcidUtils.AminoAcid3 mut = AminoAcidUtils.AminoAcid3.valueOf(change.substring(change.length() - 3));
            if (includeAcidity) {
                if (acidityMap.get((Object)wt).equals("basic") && acidityMap.get((Object)mut).equals("neutral")) {
                    value[0] = "bn";
                } else if (acidityMap.get((Object)wt).equals("neutral") && acidityMap.get((Object)mut).equals("basic")) {
                    value[0] = "nb";
                } else if (acidityMap.get((Object)wt).equals("acidic") && acidityMap.get((Object)mut).equals("neutral")) {
                    value[0] = "an";
                } else if (acidityMap.get((Object)wt).equals("neutral") && acidityMap.get((Object)mut).equals("acidic")) {
                    value[0] = "na";
                } else if (acidityMap.get((Object)wt).equals("basic") && acidityMap.get((Object)mut).equals("acidic")) {
                    value[0] = "ba";
                } else if (acidityMap.get((Object)wt).equals("acidic") && acidityMap.get((Object)mut).equals("basic")) {
                    value[0] = "ab";
                } else if (acidityMap.get((Object)wt).equals(acidityMap.get((Object)mut))) {
                    value[0] = "=";
                }
            } else {
                value[0] = null;
            }
            value[1] = includePolarity ? (polarityMap.get((Object)wt).equals("polar") && polarityMap.get((Object)mut).equals("nonpolar") ? "-" : (polarityMap.get((Object)wt).equals("nonpolar") && polarityMap.get((Object)mut).equals("polar") ? "+" : "=")) : null;
            polarityAndAcidity.add(value);
        }
        return polarityAndAcidity;
    }

    public String getPPI(Residue residue) {
        List<String> chainNames = Arrays.stream(this.molecularAssembly.getChainNames()).toList();
        if (chainNames.size() == 1) {
            logger.info(" Only one chain in the structure.");
            return " ";
        }
        String name = this.molecularAssembly.getFile().getName();
        String[] geneSplit = name.split("_");
        String[] genes = new String[chainNames.size()];
        for (int i = 1; i < chainNames.size() + 1; ++i) {
            genes[i - 1] = geneSplit[i];
        }
        char chainID = residue.getChainID().charValue();
        for (Atom atom : this.molecularAssembly.getAtomList()) {
            if (atom.getChainID().charValue() == chainID) continue;
            for (Atom resAtom : residue.getAtomList()) {
                if (!(resAtom.getXYZ().dist(atom.getXYZ()) <= 10.0)) continue;
                int index = chainNames.indexOf(atom.getChainID().toString());
                return genes[index];
            }
        }
        return " ";
    }

    static {
        polarityMap.put(AminoAcidUtils.AminoAcid3.ARG, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.ASN, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.ASP, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.ASH, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.CYS, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.GLN, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.GLU, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.GLH, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.HIS, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.HIE, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.HID, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.LYS, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.LYD, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.SER, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.THR, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.TYR, "polar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.ALA, "nonpolar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.GLY, "nonpolar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.ILE, "nonpolar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.LEU, "nonpolar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.MET, "nonpolar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.PHE, "nonpolar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.PRO, "nonpolar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.TRP, "nonpolar");
        polarityMap.put(AminoAcidUtils.AminoAcid3.VAL, "nonpolar");
        acidityMap.put(AminoAcidUtils.AminoAcid3.ASP, "acidic");
        acidityMap.put(AminoAcidUtils.AminoAcid3.ASH, "acidic");
        acidityMap.put(AminoAcidUtils.AminoAcid3.ASN, "acidic");
        acidityMap.put(AminoAcidUtils.AminoAcid3.GLU, "acidic");
        acidityMap.put(AminoAcidUtils.AminoAcid3.GLH, "acidic");
        acidityMap.put(AminoAcidUtils.AminoAcid3.ARG, "basic");
        acidityMap.put(AminoAcidUtils.AminoAcid3.HIS, "basic");
        acidityMap.put(AminoAcidUtils.AminoAcid3.HIE, "basic");
        acidityMap.put(AminoAcidUtils.AminoAcid3.HID, "basic");
        acidityMap.put(AminoAcidUtils.AminoAcid3.LYS, "basic");
        acidityMap.put(AminoAcidUtils.AminoAcid3.LYD, "basic");
        acidityMap.put(AminoAcidUtils.AminoAcid3.LEU, "neutral");
        acidityMap.put(AminoAcidUtils.AminoAcid3.GLN, "neutral");
        acidityMap.put(AminoAcidUtils.AminoAcid3.GLY, "neutral");
        acidityMap.put(AminoAcidUtils.AminoAcid3.ALA, "neutral");
        acidityMap.put(AminoAcidUtils.AminoAcid3.VAL, "neutral");
        acidityMap.put(AminoAcidUtils.AminoAcid3.ILE, "neutral");
        acidityMap.put(AminoAcidUtils.AminoAcid3.SER, "neutral");
        acidityMap.put(AminoAcidUtils.AminoAcid3.CYS, "neutral");
        acidityMap.put(AminoAcidUtils.AminoAcid3.THR, "neutral");
        acidityMap.put(AminoAcidUtils.AminoAcid3.MET, "neutral");
        acidityMap.put(AminoAcidUtils.AminoAcid3.PRO, "neutral");
        acidityMap.put(AminoAcidUtils.AminoAcid3.PHE, "neutral");
        acidityMap.put(AminoAcidUtils.AminoAcid3.TYR, "neutral");
        acidityMap.put(AminoAcidUtils.AminoAcid3.TRP, "neutral");
        phiToStructure.put(-180.0, "Extended");
        phiToStructure.put(-150.0, "Structure");
        phiToStructure.put(-50.0, "Structure");
        phiToStructure.put(0.0, "Extended");
        phiToStructure.put(50.0, "Structure");
        phiToStructure.put(70.0, "Structure");
        phiToStructure.put(180.0, "Extended");
        psiToStructure.put(-180.0, "Extended");
        psiToStructure.put(-70.0, "Alpha Helix");
        psiToStructure.put(-50.0, "Alpha Helix");
        psiToStructure.put(0.0, "Extended");
        psiToStructure.put(85.0, "Extended");
        psiToStructure.put(100.0, "Beta Sheet");
        psiToStructure.put(150.0, "Beta Sheet");
        psiToStructure.put(180.0, "Extended");
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.ALA, 127.15871);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.ARG, 269.42558);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.ASH, 158.67385);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.ASP, 159.97984);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.ASN, 159.82709);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.CYS, 154.52801);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.GLH, 195.30608);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.GLN, 197.7517);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.GLU, 195.27081);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.GLY, 95.346188);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.HID, 202.31302);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.HIE, 203.22195);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.HIS, 205.40232);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.ILE, 196.15872);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.LEU, 192.85123);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.LYD, 235.49182);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.LYS, 236.71473);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.MET, 216.53318);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.PHE, 229.75038);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.PRO, 157.30011);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.SER, 137.9072);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.THR, 157.33759);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.TRP, 262.32819);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.TYR, 239.91172);
        standardSurfaceArea.put(AminoAcidUtils.AminoAcid3.VAL, 171.89211);
        aminoAcidCodes.put("A", AminoAcidUtils.AminoAcid3.ALA);
        aminoAcidCodes.put("R", AminoAcidUtils.AminoAcid3.ARG);
        aminoAcidCodes.put("N", AminoAcidUtils.AminoAcid3.ASN);
        aminoAcidCodes.put("D", AminoAcidUtils.AminoAcid3.ASP);
        aminoAcidCodes.put("C", AminoAcidUtils.AminoAcid3.CYS);
        aminoAcidCodes.put("E", AminoAcidUtils.AminoAcid3.GLU);
        aminoAcidCodes.put("Q", AminoAcidUtils.AminoAcid3.GLN);
        aminoAcidCodes.put("G", AminoAcidUtils.AminoAcid3.GLY);
        aminoAcidCodes.put("H", AminoAcidUtils.AminoAcid3.HIS);
        aminoAcidCodes.put("I", AminoAcidUtils.AminoAcid3.ILE);
        aminoAcidCodes.put("L", AminoAcidUtils.AminoAcid3.LEU);
        aminoAcidCodes.put("K", AminoAcidUtils.AminoAcid3.LYS);
        aminoAcidCodes.put("M", AminoAcidUtils.AminoAcid3.MET);
        aminoAcidCodes.put("F", AminoAcidUtils.AminoAcid3.PHE);
        aminoAcidCodes.put("P", AminoAcidUtils.AminoAcid3.PRO);
        aminoAcidCodes.put("S", AminoAcidUtils.AminoAcid3.SER);
        aminoAcidCodes.put("T", AminoAcidUtils.AminoAcid3.THR);
        aminoAcidCodes.put("W", AminoAcidUtils.AminoAcid3.TRP);
        aminoAcidCodes.put("Y", AminoAcidUtils.AminoAcid3.TYR);
        aminoAcidCodes.put("V", AminoAcidUtils.AminoAcid3.VAL);
    }
}

