/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.utils;

import ffx.numerics.math.DoubleMath;
import ffx.numerics.quickhull.QuickHull3D;
import ffx.potential.bonded.Atom;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.stream.IntStream;
import org.apache.commons.math3.util.FastMath;

public class ConvexHullOps {
    private static final Logger logger = Logger.getLogger(ConvexHullOps.class.getName());

    public static QuickHull3D constructHull(Atom[] atoms) {
        int nAts = atoms.length;
        if (nAts < 4) {
            throw new IllegalArgumentException(String.format(" 3D convex hull ill-defined for less than 4 points, found %d", nAts));
        }
        double[] xyz = new double[nAts * 3];
        for (int i = 0; i < nAts; ++i) {
            Atom at = atoms[i];
            int i3 = 3 * i;
            xyz[i3] = at.getX();
            xyz[i3 + 1] = at.getY();
            xyz[i3 + 2] = at.getZ();
        }
        return new QuickHull3D(xyz);
    }

    public static Atom[] identifyHullAtoms(QuickHull3D quickHull3D, Atom[] allAtoms) {
        int[] indices = quickHull3D.getVertexPointIndices();
        return (Atom[])Arrays.stream(indices).mapToObj(i -> allAtoms[i]).toArray(Atom[]::new);
    }

    public static double maxDist(QuickHull3D quickHull3D) {
        long time = -System.nanoTime();
        int nVerts = quickHull3D.getNumVertices();
        if (nVerts < 2) {
            return 0.0;
        }
        double[] vertPoints = new double[3 * nVerts];
        quickHull3D.getVertices(vertPoints);
        double maxDist = IntStream.range(0, nVerts).parallel().mapToDouble(i -> {
            double[] xyz = new double[3];
            System.arraycopy(vertPoints, 3 * i, xyz, 0, 3);
            double mij = 0.0;
            for (int j = i + 1; j < nVerts; ++j) {
                double[] xyzJ = new double[3];
                System.arraycopy(vertPoints, 3 * j, xyzJ, 0, 3);
                double distIJ = DoubleMath.dist2((double[])xyz, (double[])xyzJ);
                mij = FastMath.max((double)mij, (double)distIJ);
            }
            return mij;
        }).max().getAsDouble();
        maxDist = FastMath.sqrt((double)maxDist);
        time += System.nanoTime();
        if ((double)time > 1.0E9) {
            logger.warning(String.format(" Required %12.6g sec to find max distance on a convex hull. It may be time to further optimize this!", 1.0E-9 * (double)time));
        }
        return maxDist;
    }

    public static double maxDist(Atom[] atoms) {
        int nAts = atoms.length;
        if (nAts < 2) {
            return 0.0;
        }
        if (nAts > 10) {
            return ConvexHullOps.maxDist(ConvexHullOps.constructHull(atoms));
        }
        double maxDist = 0.0;
        for (int i = 0; i < nAts - 1; ++i) {
            Atom atI = atoms[i];
            double[] xyzI = new double[3];
            xyzI = atI.getXYZ(xyzI);
            for (int j = i + 1; j < nAts; ++j) {
                Atom atJ = atoms[j];
                double[] xyzJ = new double[3];
                xyzJ = atJ.getXYZ(xyzJ);
                double dist = DoubleMath.dist2((double[])xyzI, (double[])xyzJ);
                maxDist = FastMath.max((double)dist, (double)maxDist);
            }
        }
        return FastMath.sqrt((double)maxDist);
    }
}

