/*
 * Decompiled with CFR 0.152.
 */
package ffx.potential.terms;

import ffx.potential.bonded.BondedTerm;
import ffx.potential.bonded.StretchTorsion;
import ffx.potential.terms.EnergyTerm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;

public class StretchTorsionPotentialEnergy
extends EnergyTerm {
    private static final Logger logger = Logger.getLogger(StretchTorsionPotentialEnergy.class.getName());
    private final List<StretchTorsion> stretchTorsions = new ArrayList<StretchTorsion>();

    public StretchTorsionPotentialEnergy(String name) {
        super(name);
    }

    public StretchTorsionPotentialEnergy(String name, int forceGroup) {
        super(name, forceGroup);
    }

    public StretchTorsionPotentialEnergy(String name, int forceGroup, List<StretchTorsion> stretchTorsions) {
        super(name, forceGroup);
        if (stretchTorsions != null) {
            Collections.sort(stretchTorsions);
            this.stretchTorsions.addAll(stretchTorsions);
            logger.info(String.format("  Stretch-Torsions:                  %10d", this.getNumberOfStretchTorsions()));
        }
    }

    @Override
    public int getNumberOfTerms() {
        return this.getNumberOfStretchTorsions();
    }

    @Override
    public BondedTerm[] getBondedTermsArray() {
        return this.getStretchTorsionArray();
    }

    public StretchTorsionPotentialEnergy(String name, Collection<StretchTorsion> stretchTorsions) {
        super(name);
        if (stretchTorsions != null) {
            this.stretchTorsions.addAll(stretchTorsions);
        }
    }

    public boolean addStretchTorsion(StretchTorsion stretchTorsion) {
        if (stretchTorsion == null) {
            return false;
        }
        return this.stretchTorsions.add(stretchTorsion);
    }

    public boolean addStretchTorsions(StretchTorsion[] stretchTorsions) {
        if (stretchTorsions == null) {
            return false;
        }
        Collections.addAll(this.stretchTorsions, stretchTorsions);
        return true;
    }

    public boolean addStretchTorsions(List<StretchTorsion> stretchTorsions) {
        if (stretchTorsions == null) {
            return false;
        }
        this.stretchTorsions.addAll(stretchTorsions);
        return true;
    }

    public boolean removeStretchTorsion(StretchTorsion stretchTorsion) {
        if (stretchTorsion == null) {
            return false;
        }
        return this.stretchTorsions.remove(stretchTorsion);
    }

    public StretchTorsion getStretchTorsion(int index) {
        return this.stretchTorsions.get(index);
    }

    public List<StretchTorsion> getStretchTorsions() {
        return Collections.unmodifiableList(this.stretchTorsions);
    }

    public StretchTorsion[] getStretchTorsionArray() {
        return this.stretchTorsions.toArray(new StretchTorsion[0]);
    }

    public int getNumberOfStretchTorsions() {
        return this.stretchTorsions.size();
    }

    @Override
    public void log() {
        if (this.getNumberOfStretchTorsions() <= 0) {
            return;
        }
        logger.info("\n Stretch-Torsion Interactions:");
        for (StretchTorsion stretchTorsion : this.getStretchTorsions()) {
            logger.info(" Stretch-Torsion \t" + stretchTorsion.toString());
        }
    }

    @Override
    public String toPDBString() {
        if (this.getNumberOfStretchTorsions() <= 0) {
            return "";
        }
        return String.format("REMARK   3   %s %g (%d)\n", "STRETCH-TORSION            : ", this.getEnergy(), this.getNumberOfStretchTorsions());
    }

    @Override
    public String toString() {
        return String.format("  %s %20.8f %12d %12.3f\n", "Stretch-Torsion   ", this.getEnergy(), this.getNumberOfStretchTorsions(), this.getTime());
    }
}

